
;*****************************************************************
; Wait for start of next vertical retrace                        *
;*****************************************************************

        PUBLIC  _Vertical_Retrace

_Vertical_Retrace       PROC    NEAR
        PUSH    ES
        XOR     AX,AX                   ;Get address of STATUS register
        MOV     ES,AX                   ;From segment 0
        MOV     DX,3BAH                 ;Assume monochrome addressing
        TEST    BYTE PTR ES:[BIOS_Equipment],2  ;Is mono display attached?
        JNZ     VR_Address_Ok           ;...Yes, address is ok
        MOV     DX,3DAH                 ;...No, must set color addressing
VR_Address_Ok:

        IN      AL,DX                   ;Read in status
        JMP     $+2
        TEST    AL,08H                  ;Is retrace ON? (if ON bit = 1)
        JZ      Wait_For_On             ;...no, go wait for start
Wait_For_Off:                           ;...yes, wait for it to go OFF
        IN      AL,DX
        JMP     $+2
        TEST    AL,08H                  ;Is retrace OFF?
        JNZ     Wait_For_Off            ;...No, keep waiting
Wait_For_On:
        IN      AL,DX
        JMP     $+2
        TEST    AL,08H                  ;Is retrace ON?
        JZ      Wait_For_On             ;...No, keep on waiting
        POP     ES
        RET
_Vertical_Retrace       ENDP
