TITLE GAME3D: PADDLE CONTROL

EXTRN PADDLE_TOP:WORD, PADDLE_BOTTOM:WORD
PUBLIC DRAW_PADDLE, MOVE_PADDLE

.MODEL SMALL
.CODE

DRAW_HAND_COLUMN MACRO X
LOCAL TOP
;INPUT: AL = PIXEL VALUE, CX= COLUMN, DX= ROW, X= LENGTH OF COLUMN
;OUTPUT: Draws a horizontal line starting from the given position indicated
;        by CX and DX

	PUSH BX
	MOV AH, 0CH
	MOV BX, X
	XOR BH, BH

TOP:    INT 10H
	INC DX
	DEC BX
	JNZ TOP
	POP BX
	ENDM

DRAW_PADDLE PROC

	PUSH AX
	PUSH BX
	PUSH CX
	PUSH DX

;The following lines will draw the hand by incrementing and decrementing
;CX and DX according to a graphical analysis.
;It utilizes the Draw_Hand_Column macro (which takes in the lenght of
;the hand portion to be drawn.

	MOV CX, 11
	MOV DX, PADDLE_TOP              ;FIRST COLUMN
	PUSH DX                         
	ADD DX, 3
	DRAW_HAND_COLUMN 5
	ADD DX, 3
	DRAW_HAND_COLUMN 5
	POP DX
	PUSH DX
	INC CX           ;NEXT COLUMN (SECOND COLUMN)
	ADD DX, 3
	DRAW_HAND_COLUMN 5
	ADD DX, 3
	DRAW_HAND_COLUMN 5
	POP DX
	PUSH DX
	INC CX           ;NEXT COLUMN (THIRD COLUMN)
	ADD DX, 2
	DRAW_HAND_COLUMN 6
	ADD DX, 3
	DRAW_HAND_COLUMN 6
	POP DX
	PUSH DX
	INC CX           ;NEXT COLUMN (FOURTH COLUMN)
	DRAW_HAND_COLUMN 8
	ADD DX, 3
	DRAW_HAND_COLUMN 8
	POP DX
	PUSH DX
	INC CX           ;NEXT COLUMN (FIFTH COLUMN)
	DRAW_HAND_COLUMN 1
	ADD DX, 1
	DRAW_HAND_COLUMN 7
	ADD DX, 1
	DRAW_HAND_COLUMN 7
	ADD DX, 1
	DRAW_HAND_COLUMN 1
	POP DX
	PUSH DX
	INC CX           ;NEXT COLUMN (SIXTH COLUMN)
	DRAW_HAND_COLUMN 1
	ADD DX, 1
	DRAW_HAND_COLUMN 7
	ADD DX, 1
	DRAW_HAND_COLUMN 7
	ADD DX, 1
	DRAW_HAND_COLUMN 1
	POP DX
	PUSH DX
	INC CX           ;NEXT COLUMN (SEVETHTH COLUMN)
	ADD DX,2
	DRAW_HAND_COLUMN 1
	ADD DX, 1
	DRAW_HAND_COLUMN 1
	ADD DX, 1
	DRAW_HAND_COLUMN 1
	ADD DX, 1
	DRAW_HAND_COLUMN 1
	ADD DX, 1
	DRAW_HAND_COLUMN 1
	ADD DX, 1
	DRAW_HAND_COLUMN 1
	ADD DX, 1
	DRAW_HAND_COLUMN 1
	ADD DX, 1
	DRAW_HAND_COLUMN 1
	POP DX
	PUSH DX
	INC CX           ;NEXT COLUMN (EIGHTH COLUMN)
	ADD DX,2
	DRAW_HAND_COLUMN 1
	ADD DX, 1
	DRAW_HAND_COLUMN 1
	ADD DX, 1
	DRAW_HAND_COLUMN 1
	ADD DX, 1
	DRAW_HAND_COLUMN 1
	ADD DX, 1
	DRAW_HAND_COLUMN 1
	ADD DX, 1
	DRAW_HAND_COLUMN 1
	ADD DX, 1
	DRAW_HAND_COLUMN 1
	ADD DX, 1
	DRAW_HAND_COLUMN 1
	POP DX
	PUSH DX
	INC CX           ;NEXT COLUMN (NINTH COLUMN)
	ADD DX,2
	DRAW_HAND_COLUMN 1
	ADD DX, 1
	DRAW_HAND_COLUMN 1
	ADD DX, 1
	DRAW_HAND_COLUMN 1
	ADD DX, 5
	DRAW_HAND_COLUMN 1
	ADD DX, 1
	DRAW_HAND_COLUMN 1
	ADD DX, 1
	DRAW_HAND_COLUMN 1
	POP DX
	INC CX           ;NEXT COLUMN (TENTH COLUMN)
	ADD DX,4
	DRAW_HAND_COLUMN 1
	ADD DX, 9
	DRAW_HAND_COLUMN 1
	
	POP DX            ;restore registers.
	POP CX
	POP BX
	POP AX
	RET

DRAW_PADDLE ENDP

		

MOVE_PADDLE PROC
;Input: AX =  2 (to move hand down 2 pixels)
;           = -2 (to move hand up 2 pixels)

	MOV BX,AX               ;copy BX

	CMP AX,0
	JL UP                    ;neg, move up.

	CMP PADDLE_BOTTOM,188    ;at bottom?
	JGE DONE                 ;yes, cannot move
	JMP UPDATE               ;no, update hand

UP:     CMP PADDLE_TOP,11        ;at top?
	JLE DONE                 ;yes, cannot move

UPDATE:
	MOV AL,0                 ;background color
	CALL DRAW_PADDLE

	ADD PADDLE_TOP,BX
	ADD PADDLE_BOTTOM,BX
	MOV AL,5                  ;color of hand
	CALL DRAW_PADDLE

DONE:   RET

MOVE_PADDLE ENDP

END     
