/* file: stm.h
 * Code for the simulated toy machine (STM), 
 * a simulated architecture supporting variable-length partitions.
 *
 * FOR MOST OF OUR PROJECTS, YOU MUST NOT MODIFY THIS CODE
 * AS IT REPRESENTS OUR HARDWARE.
 *
 * THIS CODE IS modified from the original stm.c code from
 * 	Professor Ernie Davis with permission.
 ***************************************************/

#ifndef H_STM
#define H_STM

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#define RAMSIZE 262144  /* 2**18 address space */
#define NUMREGS 16
#define NAMESIZE 32 /* maximum size of process name */

/****************************************************
 * Global variables for the simulated architecture
 ****************************************************/
int   mem[RAMSIZE],  /* Core memory */
      regs[NUMREGS], /* Number of registers */
      base,          /* Base register */
      limit;         /* limit register */
      
char codes[16][4];   /* Op codes */
     

/****************************************************
 * Other global variables 
 ****************************************************/

int  debug,          /* Level of debugging */
     error, 		    /* Error flag */
     terminate,		    /* Termination flag */
     maxinst,  		    /* Maximum number of instructions */
     procindex;         /* Index of process */

char procname[NAMESIZE];  /* name of process */


/****************************************************
 * parse_flags(argc, argv)
 *
 * Extract the flags from the command line: base, debug, and maxinst.
 * The index of the STM filename in the command is returned as the value.
 ****************************************************/

extern int parse_flags(int argc, char * argv[]);

/****************************************************
 * Load the STML code into memory 
 * It is assumed that STML files are correctly formatted;
 * 	therefore, this does no error checking
 * NOTE: You are allowed to change this function for project 1;
 * 	however, there is no need to do so.
 ****************************************************/

extern void load_stm(char filename[]);

/* Set global flags, load the STM file, initialize the STM process */

extern void initialize(int argc, char* argv[]);


/* Convert a relative address to a physical address. Check that it
   lies within bounds */
/* Note: This is considered part of the "hardware" of the virtual machine.
   You may not change it in any of the projects. */

extern int phys_address(int reladd);


/* Display STM instruction for level-2 debugging */

extern void show_inst(int op, int ra, int ad, int rb, int rc, int rd);


/* Decompose an STM instruction into its components */
/* Note: This is considered part of the "hardware" of the virtual machine.
   You may not change it in any of the projects. */

extern void get_inst(int inst,
	int* pop, int* pra, int* pad, int* prb, int* prc, int* prd);


/* Execute an STM instruction. This is what does the actual work of
   carrying out the STM code */
/* Note: This is considered part of the "hardware" of the virtual machine.
   You may not change it in any of the projects. */

extern int exec_inst(int op, int ra, int ad, int rb, int rc, int rd);

/* Execute a trap */

extern void exec_trap();
 
/* fetch and execute an instruction of STM code */

extern void exec_stm();

#endif
// END of stm.h
