//HW1

#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>

extern int errno;     /* system error number */

void syserr(char* );  /* error report, abort routine */ 

int main(int argc, char *argv[])
{
  pid_t pid;
  int rc;
 
  pid = getpid();
  printf("Process ID before fork: %d\n", pid);

  while(true){//Infinite loop to continuously produces processes
    switch (fork()) {
    case -1:
      syserr("fork");
    case 0:
    pid = getpid();
    printf("Process ID in child after fork: %d\n", pid);
    execlp("sleepy", "sleepy", "10",NULL);
    syserr("execl");
  }

  pid = getpid();

  printf("Process ID in parent after fork: %d\n", pid);
}


void syserr(char * msg)
  {//Error message in case of errors
  fprintf("Stuff went wrong!","%s: %s", strerror(errno), msg);
  abort();
}
