// file: fork.c
// The following code is from
// Dr Ian G Graham, Department of Information Technology, GUGC
// Copyright  2000-2003
//
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
 
extern int errno;     /* system error number */
 
void syserr(char* );  /* error report, abort routine */ 
 
int main(int argc, char *argv[])
{
   pid_t pid;
   int rc;
 
   pid = getpid();
   printf("Process ID before fork: %d\n", pid);
	
   switch (fork()) {
      case -1:
         syserr("fork");
      case 0:
      
/* execution in child process */ 
 
         pid = getpid();
         printf("Process ID in child after fork: %d\n", pid);
         execlp("sleep", "sleep", "10",NULL);
         syserr("execl");
   }
 
/* continued execution in parent process */
 
   pid = getpid();
   printf("Process ID in parent after fork: %d\n", pid);
 
   exit(0);
}
 
void syserr(char * msg)
{
   fprintf(stderr,"%s: %s", strerror(errno), msg);
   //abort(errno); // variant
   abort();
}

