// MultiGCD inter-system program, using the CommunIface code I wrote separately.

#include "CommunIface.h"
#include <stdio.h>
#include <windows.h>
#include <process.h>

// --- CLIENT --

#define   MAX(l,r)   l >= r ? l : r
#define   MIN(l,r)   l <= r ? l : r

int    GCDEuclid   (int iLeft, int iRight, HServer hSrv, HClient hClient)
{
	// Compute the proper modulus.
	int   iModDvsr  = MAX(iLeft, iRight);
	int   iModDvdnd = MIN(iLeft, iRight);
	int   iModResult;
	HDS   hds  = ClientGetDS (hClient);

	if (!iRight)
		return iLeft;

	if (!iLeft)
		return  iRight;  // For symmetry.

	RequestDataSpace (hds);
	WriteDataSpace (hds, &iModDvsr, 0, sizeof(int) );
	WriteDataSpace (hds, &iModDvdnd,  sizeof(int) * 1, sizeof(int) );
	ReleaseDataSpace (hds);  // As quickly as possible.
	CLTSubmitRequest (hSrv, hClient);

	RequestDataSpace (hds);
	ReadDataSpace (hds, &iModResult, 0, sizeof(int) );
	ReleaseDataSpace (hds);


	return GCDEuclid (iModResult, MIN(iLeft, iRight), hSrv, hClient);

}

void   GCDClient   (HServer hSrv, HClient hClient)
{
	HDS hds = ClientGetDS (hClient);

	// Our input is the pair of numbers.
	int   iLeft, iRight, iGCD;

	RequestDataSpace (hds);
	ReadDataSpace (hds, &iLeft, 0, sizeof(int) );
	ReadDataSpace (hds, &iRight,  sizeof(int) * 1, sizeof(int) );
	ReleaseDataSpace (hds);  // As quickly as possible.

	// The recursive GCDEuclid summons the server.
	iGCD = GCDEuclid (iLeft, iRight, hSrv, hClient);

	printf ("GCD of %i and %i is %i.\n", iLeft, iRight, iGCD);
}

// --- SERVER --

void   GCDRequests (HDS hds)
{
	// hds contains a request for a remainder computation.
	int    iDividend, iDivisor, iResult;

	RequestDataSpace (hds);
	ReadDataSpace (hds, &iDividend, 0, sizeof(int) );
	ReadDataSpace (hds, &iDivisor,  sizeof(int) * 1, sizeof(int) );
	iResult = iDividend % iDivisor;
	WriteDataSpace (hds, &iResult, 0, sizeof(int) );
	ReleaseDataSpace (hds);
}

int  main (int argc, char* argv[])
{
	HServer hSrv = SRVInitialize (GCDRequests);

	// Loop to spawn clients.
	int i;
	
	for (i = 1; i < argc; i += 2) {
		// GCD integers.
		int iGCDLeft = atoi (argv[i]);
		int iGCDRight = atoi (argv[i + 1]);

		// Spawn clients.
		HClient hClient = SRVMakeClient (hSrv, GCDClient);
		HDS  hClientDS = ClientGetDS (hClient);
		RequestDataSpace (hClientDS);
		WriteDataSpace (hClientDS, &iGCDLeft, 0, sizeof(int) );
		WriteDataSpace (hClientDS, &iGCDRight, sizeof(int), sizeof(int) );
		ReleaseDataSpace (hClientDS);
		SRVLaunchClient (hSrv, hClient);
	}

	//  The clients will block until the handler can execute.
	SRVEnterHandler (hSrv);

}