// Common communications interface.

#ifndef _CIFACE
#define _CIFACE

typedef int    BOOL;
#define FALSE  0
#define TRUE   1

typedef void*  HServer;
typedef void*  HClient;   // "None of your business".
typedef void*  HDS;

typedef void (*PROCClientBase) (HServer, HClient);
typedef void (*PROCServerRequest) (HDataSpace);

#ifdef _WIN32
// Memory references are DWORDs
typedef __int32 MEMREF;
#endif

// --DATA SPACES--
HDS  MakeDataSpace ();
BOOL   RequestDataSpace (HDS hds);
BOOL  ReleaseDataSpace (HDS hds);
BOOL  FreeDataSpace (HDS hds);
void WriteDataSpace (HDS hDS, const void* pvVar, MEMREF mrOff, MEMREF mrSize);
void ReadDataSpace (HDS hDS, void* pvVar, MEMREF mrOff, MEMREF mrSize);

// Client functions.
BOOL CLTSubmitRequest (HServer hSrv, HClient hClient);

// Server functions.
HServer SRVInitialize (PROCServerRequest pfnRQ);
HClient  SRVMakeClient (HServer hSrv, PROCClientBase pfn);
void SRVLaunchClient (HServer hSrv, HClient hClt);
BOOL  SRVEnterHandler (HServer hSrv);


// Cracking public data.
//   We need only these two.
HDS  ClientGetDS (HClient hClient);
HDS  ServerGetRequestDS (HServer hSrv);


#endif // _CIFACE