#include <stdio.h>
#include <signal.h>
#include <setjmp.h>
#include <fcntl.h>

void forkprocess(int, char**, int);
void setNonBlocking(int);
int numToSpawn;
int count = -1;
int pipesin[1000];
int pipesout[1000];
int location = 1;

main(int argc, char **argv)
{
	// check the command line input to make sure it's pairs of numbers
	if (argc % 2 == 0 || argc == 1)
	{
		printf("input must be a set of pairs of numbers");
	        exit(0);
	}
	int i = 1;
	int j;
	while(i < argc)
	{
		for(j = 0; j < strlen(argv[i]); j++)
		{
			if (!isdigit(argv[i][j]))		
			{
				printf("input must be a set of pairs of numbers");
	        		exit(0);
			}	
		}
		i++;
	}
	
	numToSpawn = (argc - 1) / 2;
	forkprocess(argc, argv, 1);
}

void forkprocess(int argc, char **argv, int position)
{	
	int pipev[2];
	int pipev2[2];
	int length;

	// open one pipe to read from child
       	if (pipe(pipev) == -1)
		perror("open pipe");
	//open second pipe to write to child
	if (pipe(pipev2) == -1)
		   perror("open pipe");
	
	pipesin[count] = pipev[0];
	pipesout[count] = pipev2[1];
	count++;
	
	int pid = fork();
	numToSpawn--;
	/* error */
	if (pid < 0)
		perror("fork");
	/* child */
	else if (pid == 0)
	{
		close(pipev[0]);
		close(pipev2[1]);	
		int last;
		sscanf(argv[position + 1], "%d", &last);
		int next;
		sscanf(argv[position], "%d", &next);
		char buf[1024];
		char buf2[1024];
		sprintf(buf, "%s %s", argv[position], argv[position + 1]);
		length = strlen(buf);
		if (write(pipev[1], buf, length) != length)
	   		perror("write to pipe");
		while(1)
		{
			next = last;
			read(pipev2[0], buf2, 1024);
			sscanf(buf2, "%d", &last);
			sprintf(buf, "%d %d", next, last);
			if (last == 0) 
			{
				printf("%d ", next);
				break;
			}
	       		if (write(pipev[1], buf, length) != length)
	   			perror("write to pipe");
		}
	}
	/* parent */
	else if (pid > 0)
	{
		close(pipev[1]);
		close(pipev2[0]);
		char outbuf[1024];
		int a, b, c;
		//setNonBlocking(pipev[0]);
		
		while(1)
		{
			read(pipev[0], outbuf, 1024);
			sscanf(outbuf, "%d %d", &a, &b);
			c = a - b;
			while (c > -1)
			{
				c = c - b;
			}
			c = c + b;
			sprintf(outbuf, "%d", c);
			length = strlen(outbuf);
			if (write(pipev2[1], outbuf, length) != length)
	   			perror("write to pipe");
			if (c == 0)
				break;
		}
		if (numToSpawn > 0)
			forkprocess(argc, argv, position + 2);
	}
}

void setNonBlocking(int fd)
{
	int val;
	if ((val = fcntl(fd, F_GETFL, 0)) < 0)
		perror("fcntl F_GETFL error");
	val |= O_NONBLOCK;	// turn on flags
	if (fcntl(fd, F_SETFL, val)<0)
		perror("fcntl F_SETFL error");
}
