/* WARNING: Automatically generated code.
 * This code has been generated by the DH compiler.
 */
#ifdef HAVE_CONFIG_H
# include "lushconf.h"
#endif

/*
 * USER DEFINED HEADERS
 */
#include <gsl/gsl_eigen.h>
#include <gsl/gsl_linalg.h>
#define IDX2GSL_VECTOR(_idxv_,_gslv_,_type_) _gslv_.data = IDX_PTR(_idxv_,_type_); _gslv_.size = _idxv_->dim[0]; _gslv_.stride = _idxv_->mod[0]; _gslv_.block = NULL; _gslv_.owner=0
#define IDX2GSL_VECTOR_COMPLEX(_idxv_,_gslv_,_type_) _gslv_.data = IDX_PTR(_idxv_,_type_); _gslv_.size = _idxv_->dim[0]; _gslv_.stride = _idxv_->mod[0]/2; _gslv_.block = NULL; _gslv_.owner=0
#define IDX2GSL_MATRIX(_idxv_,_gslv_,_type_) _gslv_.data = IDX_PTR(_idxv_,_type_); _gslv_.size1 = _idxv_->dim[0]; _gslv_.size2 = _idxv_->dim[1]; _gslv_.tda = _idxv_->mod[0]; _gslv_.block = NULL; _gslv_.owner=0
#define IDX2GSL_MATRIX_COMPLEX(_idxv_,_gslv_,_type_) _gslv_.data = IDX_PTR(_idxv_,_type_); _gslv_.size1 = _idxv_->dim[0]; _gslv_.size2 = _idxv_->dim[1]; _gslv_.tda = _idxv_->mod[0]/2; _gslv_.block = NULL; _gslv_.owner=0
#define IDX2GSL_PERMUTATION(_idxv_,_gslv_) _gslv_.data = (size_t *)IDX_PTR(_idxv_,int); _gslv_.size = _idxv_->dim[0]
/*
 * LUSH HEADERS
 */
#include "header.h"
#include "dh.h"
#include "idxmac.h"
#include "idxops.h"
#include "check_func.h"

/*
 * DECLARATIONS
 */
extern_c char C_idx_d1sortdown (struct idx *);

/* ---------------------------------------- */

/*
 * FUNCTION dummy-linalgebra
 */
extern_c char
C_dummy_linalgebra ()
{
  TRACE_PUSH ("C_dummy_linalgebra");
  {
    TRACE_POP ("C_dummy_linalgebra");
    return 0;
  }
}

/*
 * FUNCTION eigen-symm-inplace
 */
extern_c int
C_eigen_symm_inplace (struct idx *L1_m, struct idx *L1_v)
{
  TRACE_PUSH ("C_eigen_symm_inplace");
  {
    int L_Tmp0;
    {
      int L2_1_n;
      int L2_2_ret;
      char L_Tmp3;
      L2_1_n = (L1_m)->dim[0];
      L2_2_ret = 0;
      if ((L2_1_n != (L1_v)->dim[0]))
	{
	  L_Tmp3 = 1;
	}
      else
	{
	  if ((L2_1_n != (L1_m)->dim[1]))
	    {
	      L_Tmp3 = 1;
	    }
	  else
	    {
	      L_Tmp3 = 0;
	    }
	}
      if (L_Tmp3)
	{
	  run_time_error ("arguments have incompatible sizes");
	}
      {
	gsl_eigen_symm_workspace *p = gsl_eigen_symm_alloc ((L2_1_n));
	gsl_matrix gm;
	gsl_vector gv;
	IDX2GSL_MATRIX ((L1_m), gm, double);
	IDX2GSL_VECTOR ((L1_v), gv, double);
	(L2_2_ret) = gsl_eigen_symm (&gm, &gv, p);
	gsl_eigen_symm_free (p);
      }
      C_idx_d1sortdown (L1_v);
      L_Tmp0 = L2_2_ret;
    }
    TRACE_POP ("C_eigen_symm_inplace");
    return L_Tmp0;
  }
}

/*
 * FUNCTION eigen-symmv-inplace
 */
extern_c int
C_eigen_symmv_inplace (struct idx *L1_m, struct idx *L1_ev, struct idx *L1_v)
{
  TRACE_PUSH ("C_eigen_symmv_inplace");
  {
    int L_Tmp0;
    {
      int L2_1_n0;
      int L2_2_n1;
      int L2_3_ret;
      char L_Tmp4;
      L2_1_n0 = (L1_m)->dim[0];
      L2_2_n1 = (L1_m)->dim[1];
      L2_3_ret = 0;
      if (((L1_ev)->dim[0] != L2_1_n0))
	{
	  L_Tmp4 = 1;
	}
      else
	{
	  if (((L1_ev)->dim[1] != L2_2_n1))
	    {
	      L_Tmp4 = 1;
	    }
	  else
	    {
	      if ((L2_1_n0 != L2_2_n1))
		{
		  L_Tmp4 = 1;
		}
	      else
		{
		  if ((L2_1_n0 != (L1_v)->dim[0]))
		    {
		      L_Tmp4 = 1;
		    }
		  else
		    {
		      L_Tmp4 = 0;
		    }
		}
	    }
	}
      if (L_Tmp4)
	{
	  run_time_error ("arguments have incompatible sizes");
	}
      {
	gsl_eigen_symmv_workspace *p = gsl_eigen_symmv_alloc ((L2_1_n0));
	gsl_matrix gm;
	gsl_matrix gev;
	gsl_vector gv;
	IDX2GSL_MATRIX ((L1_m), gm, double);
	IDX2GSL_MATRIX ((L1_ev), gev, double);
	IDX2GSL_VECTOR ((L1_v), gv, double);
	(L2_3_ret) = gsl_eigen_symmv (&gm, &gv, &gev, p);
	gsl_eigen_symmv_sort (&gv, &gev, GSL_EIGEN_SORT_VAL_DESC);
	gsl_eigen_symmv_free (p);
      }
      L_Tmp0 = L2_3_ret;
    }
    TRACE_POP ("C_eigen_symmv_inplace");
    return L_Tmp0;
  }
}

/*
 * FUNCTION eigen-herm-inplace
 */
extern_c char
C_eigen_herm_inplace (struct idx *L1_m, struct idx *L1_v)
{
  TRACE_PUSH ("C_eigen_herm_inplace");
  {
    char L_Tmp0;
    {
      int L2_1_n;
      char L_Tmp2;
      L2_1_n = (L1_m)->dim[0];
      if ((L2_1_n != (L1_m)->dim[1]))
	{
	  L_Tmp2 = 1;
	}
      else
	{
	  if ((L2_1_n != (L1_v)->dim[0]))
	    {
	      L_Tmp2 = 1;
	    }
	  else
	    {
	      L_Tmp2 = 0;
	    }
	}
      if (L_Tmp2)
	{
	  run_time_error ("arguments have incompatible sizes");
	}
      {
	gsl_eigen_herm_workspace *p = gsl_eigen_herm_alloc ((L2_1_n));
	gsl_matrix_complex gm;
	gsl_vector gv;
	IDX2GSL_MATRIX_COMPLEX ((L1_m), gm, double);
	IDX2GSL_VECTOR ((L1_v), gv, double);
	gsl_eigen_herm (&gm, &gv, p);
	gsl_eigen_herm_free (p);
      }
      C_idx_d1sortdown (L1_v);
      L_Tmp0 = 0;
    }
    TRACE_POP ("C_eigen_herm_inplace");
    return 0;
  }
}

/*
 * FUNCTION eigen-hermv-inplace
 */
extern_c int
C_eigen_hermv_inplace (struct idx *L1_m, struct idx *L1_ev, struct idx *L1_v)
{
  TRACE_PUSH ("C_eigen_hermv_inplace");
  {
    int L_Tmp0;
    {
      int L2_1_n0;
      int L2_2_n1;
      int L2_3_ret;
      char L_Tmp4;
      L2_1_n0 = (L1_m)->dim[0];
      L2_2_n1 = (L1_m)->dim[1];
      L2_3_ret = 0;
      if (((L1_ev)->dim[0] != L2_1_n0))
	{
	  L_Tmp4 = 1;
	}
      else
	{
	  if (((L1_ev)->dim[1] != L2_2_n1))
	    {
	      L_Tmp4 = 1;
	    }
	  else
	    {
	      if (((L1_v)->dim[0] != L2_1_n0))
		{
		  L_Tmp4 = 1;
		}
	      else
		{
		  if ((L2_1_n0 != L2_2_n1))
		    {
		      L_Tmp4 = 1;
		    }
		  else
		    {
		      L_Tmp4 = 0;
		    }
		}
	    }
	}
      if (L_Tmp4)
	{
	  run_time_error ("arguments have incompatible sizes");
	}
      {
	gsl_eigen_hermv_workspace *p = gsl_eigen_hermv_alloc ((L2_2_n1));
	gsl_matrix_complex gm;
	gsl_matrix_complex gev;
	gsl_vector gv;
	IDX2GSL_MATRIX_COMPLEX ((L1_m), gm, double);
	IDX2GSL_MATRIX_COMPLEX ((L1_ev), gev, double);
	IDX2GSL_VECTOR ((L1_v), gv, double);
	(L2_3_ret) = gsl_eigen_hermv (&gm, &gv, &gev, p);
	gsl_eigen_hermv_sort (&gv, &gev, 1);
	gsl_eigen_hermv_free (p);
      }
      L_Tmp0 = L2_3_ret;
    }
    TRACE_POP ("C_eigen_hermv_inplace");
    return L_Tmp0;
  }
}

/*
 * FUNCTION svd-inplace
 */
extern_c int
C_svd_inplace (struct idx *L1_a, struct idx *L1_v, struct idx *L1_s)
{
  TRACE_PUSH ("C_svd_inplace");
  {
    int L_Tmp0;
    {
      real L2_1_n;
      char L_Tmp2;
      L2_1_n = (L1_a)->dim[1];
      if (((L1_a)->dim[0] < L2_1_n))
	{
	  run_time_error ("must have M>=N for SVD of MxN matrix");
	}
      if ((L2_1_n != (L1_v)->dim[0]))
	{
	  L_Tmp2 = 1;
	}
      else
	{
	  if ((L2_1_n != (L1_v)->dim[1]))
	    {
	      L_Tmp2 = 1;
	    }
	  else
	    {
	      if ((L2_1_n != (L1_s)->dim[0]))
		{
		  L_Tmp2 = 1;
		}
	      else
		{
		  L_Tmp2 = 0;
		}
	    }
	}
      if (L_Tmp2)
	{
	  run_time_error ("incompatible matrix sizes for SVD");
	}
    }
    {
      Midx_declare (L2_3_0_matrix, 1);
      Msrg_declare (L2_4_0_srg);
      struct idx *L2_5_w;
      int L2_6_ret;
      Midx_init (L2_3_0_matrix, 1);
      Msrg_init (L2_4_0_srg, ST_D);
      (L2_3_0_matrix)->srg = L2_4_0_srg;
      Midx_init_dim1 (L2_3_0_matrix, (L1_a)->dim[1]);
      RTERR_DIM (L2_3_0_matrix->dim[0] <= 0);
      Midx_maclear (L2_3_0_matrix, real);
      L2_5_w = L2_3_0_matrix;
      L2_6_ret = 0;
      {
	gsl_matrix ga;
	gsl_matrix gv;
	gsl_vector gs;
	gsl_vector gw;
	IDX2GSL_MATRIX ((L1_a), ga, double);
	IDX2GSL_MATRIX ((L1_v), gv, double);
	IDX2GSL_VECTOR ((L1_s), gs, double);
	IDX2GSL_VECTOR ((L2_5_w), gw, double);
	(L2_6_ret) = gsl_linalg_SV_decomp (&ga, &gv, &gs, &gw);
      }
      L_Tmp0 = L2_6_ret;
      Msrg_free (L2_4_0_srg);
    }
    TRACE_POP ("C_svd_inplace");
    return L_Tmp0;
  }
}

/*
 * FUNCTION lu-decomp-inplace
 */
extern_c int
C_lu_decomp_inplace (struct idx *L1_a, struct idx *L1_p,
		     struct idx *L1_signum)
{
  TRACE_PUSH ("C_lu_decomp_inplace");
  {
    int L_Tmp0;
    {
      int L2_1_ret;
      int L2_2_m;
      int L2_3_n;
      L2_1_ret = 0;
      L2_2_m = (L1_a)->dim[0];
      L2_3_n = (L1_a)->dim[1];
      if ((L2_2_m != L2_3_n))
	{
	  run_time_error ("matrix is not square");
	}
      {
	gsl_matrix ga;
	gsl_permutation gp;
	Midx_init_dim1 ((L1_p), (L2_3_n));
	IDX2GSL_MATRIX ((L1_a), ga, double);
	IDX2GSL_PERMUTATION ((L1_p), gp);
	(L2_1_ret) =
	  gsl_linalg_LU_decomp (&ga, &gp, IDX_PTR ((L1_signum), int));
      }
      L_Tmp0 = L2_1_ret;
    }
    TRACE_POP ("C_lu_decomp_inplace");
    return L_Tmp0;
  }
}

/*
 * FUNCTION lu-decomp-complex-inplace
 */
extern_c int
C_lu_decomp_complex_inplace (struct idx *L1_a, struct idx *L1_p,
			     struct idx *L1_signum)
{
  TRACE_PUSH ("C_lu_decomp_complex_inplace");
  {
    int L_Tmp0;
    {
      int L2_1_ret;
      int L2_2_m;
      int L2_3_n;
      L2_1_ret = 0;
      L2_2_m = (L1_a)->dim[0];
      L2_3_n = (L1_a)->dim[1];
      if ((L2_2_m != L2_3_n))
	{
	  run_time_error ("matrix is not square");
	}
      Midx_init_dim1 (L1_p, L2_3_n);
      {
	gsl_matrix_complex ga;
	gsl_permutation gp;
	IDX2GSL_MATRIX_COMPLEX ((L1_a), ga, double);
	IDX2GSL_PERMUTATION ((L1_p), gp);
	(L2_1_ret) =
	  gsl_linalg_complex_LU_decomp (&ga, &gp, IDX_PTR ((L1_signum), int));
      }
      L_Tmp0 = L2_1_ret;
    }
    TRACE_POP ("C_lu_decomp_complex_inplace");
    return L_Tmp0;
  }
}

/*
 * FUNCTION cholesky-decomp-inplace
 */
extern_c int
C_cholesky_decomp_inplace (struct idx *L1_a)
{
  TRACE_PUSH ("C_cholesky_decomp_inplace");
  {
    int L_Tmp0;
    {
      int L2_1_ret;
      int L2_2_n;
      L2_1_ret = 0;
      L2_2_n = (L1_a)->dim[1];
      if (((L1_a)->dim[0] != L2_2_n))
	{
	  run_time_error ("matrix is not square");
	}
      {
	gsl_matrix ga;
	IDX2GSL_MATRIX ((L1_a), ga, double);
	(L2_1_ret) = gsl_linalg_cholesky_decomp (&ga);
      }
      L_Tmp0 = L2_1_ret;
    }
    TRACE_POP ("C_cholesky_decomp_inplace");
    return L_Tmp0;
  }
}

/*
 * FUNCTION solve-sv-inplace
 */
extern_c int
C_solve_sv_inplace (struct idx *L1_a, struct idx *L1_b, struct idx *L1_x)
{
  TRACE_PUSH ("C_solve_sv_inplace");
  {
    int L_Tmp0;
    {
      real L2_1_n1;
      real L2_2_n0;
      L2_1_n1 = (L1_a)->dim[1];
      L2_2_n0 = (L1_a)->dim[0];
      if ((L2_2_n0 < L2_1_n1))
	{
	  run_time_error ("must have M>=N for SVD of MxN matrix");
	}
      if ((L2_2_n0 != (L1_b)->dim[0]))
	{
	  run_time_error ("A and b have incompatible sizes");
	}
      {
	Midx_declare (L3_3_0_matrix, 2);
	Msrg_declare (L3_4_0_srg);
	struct idx *L3_5_v;
	Midx_declare (L3_6_1_matrix, 1);
	Msrg_declare (L3_7_1_srg);
	struct idx *L3_8_s;
	Midx_declare (L3_9_2_matrix, 1);
	Msrg_declare (L3_10_2_srg);
	struct idx *L3_11_w;
	int L3_12_ret;
	Midx_init (L3_3_0_matrix, 2);
	Msrg_init (L3_4_0_srg, ST_D);
	Midx_init (L3_6_1_matrix, 1);
	Msrg_init (L3_7_1_srg, ST_D);
	Midx_init (L3_9_2_matrix, 1);
	Msrg_init (L3_10_2_srg, ST_D);
	(L3_3_0_matrix)->srg = L3_4_0_srg;
	Midx_init_dim2 (L3_3_0_matrix, L2_2_n0, L2_1_n1);
	RTERR_DIM (L3_3_0_matrix->dim[0] <= 0);
	RTERR_DIM (L3_3_0_matrix->dim[1] <= 0);
	L3_5_v = L3_3_0_matrix;
	(L3_6_1_matrix)->srg = L3_7_1_srg;
	Midx_init_dim1 (L3_6_1_matrix, L2_1_n1);
	RTERR_DIM (L3_6_1_matrix->dim[0] <= 0);
	L3_8_s = L3_6_1_matrix;
	(L3_9_2_matrix)->srg = L3_10_2_srg;
	Midx_init_dim1 (L3_9_2_matrix, L2_1_n1);
	RTERR_DIM (L3_9_2_matrix->dim[0] <= 0);
	L3_11_w = L3_9_2_matrix;
	L3_12_ret = 0;
	{
	  gsl_matrix ga;
	  gsl_matrix gv;
	  gsl_vector gb;
	  gsl_vector gs;
	  gsl_vector gw;
	  gsl_vector gx;
	  IDX2GSL_MATRIX ((L1_a), ga, double);
	  IDX2GSL_MATRIX ((L3_5_v), gv, double);
	  IDX2GSL_VECTOR ((L1_b), gb, double);
	  IDX2GSL_VECTOR ((L3_8_s), gs, double);
	  IDX2GSL_VECTOR ((L3_11_w), gw, double);
	  IDX2GSL_VECTOR ((L1_x), gx, double);
	  gsl_linalg_SV_decomp (&ga, &gv, &gs, &gw);
	  (L3_12_ret) = gsl_linalg_SV_solve (&ga, &gv, &gs, &gb, &gx);
	}
	L_Tmp0 = L3_12_ret;
	Msrg_free (L3_4_0_srg);
	Msrg_free (L3_7_1_srg);
	Msrg_free (L3_10_2_srg);
      }
    }
    TRACE_POP ("C_solve_sv_inplace");
    return L_Tmp0;
  }
}

/*
 * FUNCTION solve-hh-inplace
 */
extern_c int
C_solve_hh_inplace (struct idx *L1_a, struct idx *L1_b)
{
  TRACE_PUSH ("C_solve_hh_inplace");
  {
    int L_Tmp0;
    {
      int L2_1_ret;
      L2_1_ret = 0;
      {
	gsl_matrix ga;
	gsl_vector gb;
	IDX2GSL_MATRIX ((L1_a), ga, double);
	IDX2GSL_VECTOR ((L1_b), gb, double);
	(L2_1_ret) = gsl_linalg_HH_svx (&ga, &gb);
      }
      L_Tmp0 = L2_1_ret;
    }
    TRACE_POP ("C_solve_hh_inplace");
    return L_Tmp0;
  }
}

/*
 * FUNCTION solve-lu-inplace
 */
extern_c int
C_solve_lu_inplace (struct idx *L1_a, struct idx *L1_b)
{
  TRACE_PUSH ("C_solve_lu_inplace");
  {
    int L_Tmp0;
    {
      real L2_1_n;
      int L2_2_ret;
      L2_1_n = (L1_a)->dim[0];
      L2_2_ret = 0;
      {
	gsl_matrix ga;
	gsl_vector gb;
	gsl_permutation *p;
	int signum;
	p = gsl_permutation_alloc ((L2_1_n));
	IDX2GSL_MATRIX ((L1_a), ga, double);
	IDX2GSL_VECTOR ((L1_b), gb, double);
	gsl_linalg_LU_decomp (&ga, p, &signum);
	(L2_2_ret) = gsl_linalg_LU_svx (&ga, p, &gb);
	gsl_permutation_free (p);
      }
      L_Tmp0 = L2_2_ret;
    }
    TRACE_POP ("C_solve_lu_inplace");
    return L_Tmp0;
  }
}

/*
 * FUNCTION solve-lu-complex-inplace
 */
extern_c int
C_solve_lu_complex_inplace (struct idx *L1_a, struct idx *L1_b)
{
  TRACE_PUSH ("C_solve_lu_complex_inplace");
  {
    int L_Tmp0;
    {
      real L2_1_n;
      int L2_2_ret;
      L2_1_n = (L1_a)->dim[0];
      L2_2_ret = 0;
      {
	gsl_matrix_complex ga;
	gsl_vector_complex gb;
	gsl_permutation *p;
	int signum;
	p = gsl_permutation_alloc ((L2_1_n));
	IDX2GSL_MATRIX_COMPLEX ((L1_a), ga, double);
	IDX2GSL_VECTOR_COMPLEX ((L1_b), gb, double);
	gsl_linalg_complex_LU_decomp (&ga, p, &signum);
	(L2_2_ret) = gsl_linalg_complex_LU_svx (&ga, p, &gb);
	gsl_permutation_free (p);
      }
      L_Tmp0 = L2_2_ret;
    }
    TRACE_POP ("C_solve_lu_complex_inplace");
    return L_Tmp0;
  }
}

/*
 * FUNCTION inverse-lu-inplace
 */
extern_c int
C_inverse_lu_inplace (struct idx *L1_a, struct idx *L1_i)
{
  TRACE_PUSH ("C_inverse_lu_inplace");
  {
    int L_Tmp0;
    {
      int L2_1_ret;
      int L2_2_n;
      char L_Tmp3;
      L2_1_ret = 0;
      L2_2_n = (L1_a)->dim[1];
      if (((L1_a)->dim[0] != L2_2_n))
	{
	  run_time_error ("matrix is not square");
	}
      if ((L2_2_n != (L1_i)->dim[0]))
	{
	  L_Tmp3 = 1;
	}
      else
	{
	  if ((L2_2_n != (L1_i)->dim[1]))
	    {
	      L_Tmp3 = 1;
	    }
	  else
	    {
	      L_Tmp3 = 0;
	    }
	}
      if (L_Tmp3)
	{
	  run_time_error ("matrix and its inverse have different sizes");
	}
      {
	gsl_matrix ga;
	gsl_matrix gi;
	gsl_permutation *p;
	int signum;
	p = gsl_permutation_alloc ((L2_2_n));
	IDX2GSL_MATRIX ((L1_a), ga, double);
	IDX2GSL_MATRIX ((L1_i), gi, double);
	gsl_linalg_LU_decomp (&ga, p, &signum);
	(L2_1_ret) = gsl_linalg_LU_invert (&ga, p, &gi);
	gsl_permutation_free (p);
      }
      L_Tmp0 = L2_1_ret;
    }
    TRACE_POP ("C_inverse_lu_inplace");
    return L_Tmp0;
  }
}

/*
 * FUNCTION inverse-lu-complex-inplace
 */
extern_c int
C_inverse_lu_complex_inplace (struct idx *L1_a, struct idx *L1_i)
{
  TRACE_PUSH ("C_inverse_lu_complex_inplace");
  {
    int L_Tmp0;
    {
      int L2_1_ret;
      int L2_2_n;
      char L_Tmp3;
      L2_1_ret = 0;
      L2_2_n = (L1_a)->dim[1];
      if (((L1_a)->dim[0] != L2_2_n))
	{
	  run_time_error ("matrix is not square");
	}
      if ((L2_2_n != (L1_i)->dim[0]))
	{
	  L_Tmp3 = 1;
	}
      else
	{
	  if ((L2_2_n != (L1_i)->dim[1]))
	    {
	      L_Tmp3 = 1;
	    }
	  else
	    {
	      L_Tmp3 = 0;
	    }
	}
      if (L_Tmp3)
	{
	  run_time_error ("matrix and its inverse have different sizes");
	}
      {
	gsl_matrix_complex ga;
	gsl_matrix_complex gi;
	gsl_permutation *p;
	int signum;
	p = gsl_permutation_alloc ((L2_2_n));
	IDX2GSL_MATRIX_COMPLEX ((L1_a), ga, double);
	IDX2GSL_MATRIX_COMPLEX ((L1_i), gi, double);
	gsl_linalg_complex_LU_decomp (&ga, p, &signum);
	(L2_1_ret) = gsl_linalg_complex_LU_invert (&ga, p, &gi);
	gsl_permutation_free (p);
      }
      L_Tmp0 = L2_1_ret;
    }
    TRACE_POP ("C_inverse_lu_complex_inplace");
    return L_Tmp0;
  }
}

/*
 * FUNCTION determinant-lu-inplace
 */
extern_c real
C_determinant_lu_inplace (struct idx * L1_a)
{
  TRACE_PUSH ("C_determinant_lu_inplace");
  {
    real L_Tmp0;
    {
      int L2_1_ret;
      int L2_2_n;
      L2_1_ret = 0;
      L2_2_n = (L1_a)->dim[1];
      if (((L1_a)->dim[0] != (L1_a)->dim[1]))
	{
	  run_time_error ("matrix is not square");
	}
      {
	real L3_3_det;
	L3_3_det = 0;
	{
	  gsl_matrix ga;
	  gsl_permutation *p;
	  int signum;
	  p = gsl_permutation_alloc ((L2_2_n));
	  IDX2GSL_MATRIX ((L1_a), ga, double);
	  gsl_linalg_LU_decomp (&ga, p, &signum);
	  (L3_3_det) = gsl_linalg_LU_det (&ga, signum);
	  gsl_permutation_free (p);
	}
	L_Tmp0 = L3_3_det;
      }
    }
    TRACE_POP ("C_determinant_lu_inplace");
    return L_Tmp0;
  }
}

/*
 * FUNCTION determinant-lu-complex-inplace
 */
extern_c struct idx *
C_determinant_lu_complex_inplace (struct idx *L1_a, struct idx *L2_0_matrix,
				  struct srg *L2_0_srg)
{
  TRACE_PUSH ("C_determinant_lu_complex_inplace");
  {
    struct idx *L_Tmp0;
    {
      struct idx *L2_1_det;
      int L2_2_n;
      (L2_0_matrix)->srg = L2_0_srg;
      Midx_init_dim1 (L2_0_matrix, 2);
      RTERR_DIM (L2_0_matrix->dim[0] <= 0);
      Midx_maclear (L2_0_matrix, real);
      L2_1_det = L2_0_matrix;
      L2_2_n = (L1_a)->dim[1];
      if (((L1_a)->dim[0] != (L1_a)->dim[1]))
	{
	  run_time_error ("matrix is not square");
	}
      {
	gsl_matrix_complex ga;
	gsl_permutation *p;
	gsl_complex det;
	int signum;
	p = gsl_permutation_alloc ((L2_2_n));
	IDX2GSL_MATRIX_COMPLEX ((L1_a), ga, double);
	gsl_linalg_complex_LU_decomp (&ga, p, &signum);
	det = gsl_linalg_complex_LU_det (&ga, signum);
	gsl_permutation_free (p);
	memcpy (IDX_PTR ((L2_1_det), double), &det, sizeof (gsl_complex));
      }
      L_Tmp0 = L2_1_det;
    }
    TRACE_POP ("C_determinant_lu_complex_inplace");
    return L_Tmp0;
  }
}

/*
 * FUNCTION log-determinant-lu-inplace
 */
extern_c real
C_log_determinant_lu_inplace (struct idx * L1_a)
{
  TRACE_PUSH ("C_log_determinant_lu_inplace");
  {
    real L_Tmp0;
    if (((L1_a)->dim[0] != (L1_a)->dim[1]))
      {
	run_time_error ("matrix is not square");
      }
    {
      real L2_1_det;
      int L2_2_n;
      L2_1_det = 0;
      L2_2_n = (L1_a)->dim[1];
      {
	gsl_matrix ga;
	gsl_permutation *p;
	int signum;
	p = gsl_permutation_alloc ((L2_2_n));
	IDX2GSL_MATRIX ((L1_a), ga, double);
	gsl_linalg_LU_decomp (&ga, p, &signum);
	(L2_1_det) = gsl_linalg_LU_lndet (&ga);
	gsl_permutation_free (p);
      }
      L_Tmp0 = L2_1_det;
    }
    TRACE_POP ("C_log_determinant_lu_inplace");
    return L_Tmp0;
  }
}

/*
 * FUNCTION log-determinant-lu-complex-inplace
 */
extern_c real
C_log_determinant_lu_complex_inplace (struct idx * L1_a)
{
  TRACE_PUSH ("C_log_determinant_lu_complex_inplace");
  {
    real L_Tmp0;
    if (((L1_a)->dim[0] != (L1_a)->dim[1]))
      {
	run_time_error ("matrix is not square");
      }
    {
      real L2_1_det;
      int L2_2_n;
      L2_1_det = 0;
      L2_2_n = (L1_a)->dim[1];
      {
	gsl_matrix_complex ga;
	gsl_permutation *p;
	int signum;
	p = gsl_permutation_alloc ((L2_2_n));
	IDX2GSL_MATRIX_COMPLEX ((L1_a), ga, double);
	gsl_linalg_complex_LU_decomp (&ga, p, &signum);
	(L2_1_det) = gsl_linalg_complex_LU_lndet (&ga);
	gsl_permutation_free (p);
      }
      L_Tmp0 = L2_1_det;
    }
    TRACE_POP ("C_log_determinant_lu_complex_inplace");
    return L_Tmp0;
  }
}

/*
 * FUNCTION sign-determinant-lu-inplace
 */
extern_c real
C_sign_determinant_lu_inplace (struct idx * L1_a)
{
  TRACE_PUSH ("C_sign_determinant_lu_inplace");
  {
    real L_Tmp0;
    if (((L1_a)->dim[0] != (L1_a)->dim[1]))
      {
	run_time_error ("matrix is not square");
      }
    {
      real L2_1_det;
      int L2_2_n;
      L2_1_det = 0;
      L2_2_n = (L1_a)->dim[1];
      {
	gsl_matrix ga;
	gsl_permutation *p;
	int signum;
	p = gsl_permutation_alloc ((L2_2_n));
	IDX2GSL_MATRIX ((L1_a), ga, double);
	gsl_linalg_LU_decomp (&ga, p, &signum);
	(L2_1_det) = gsl_linalg_LU_sgndet (&ga, signum);
	gsl_permutation_free (p);
      }
      L_Tmp0 = L2_1_det;
    }
    TRACE_POP ("C_sign_determinant_lu_inplace");
    return L_Tmp0;
  }
}

/*
 * FUNCTION sign-determinant-lu-complex-inplace
 */
extern_c struct idx *
C_sign_determinant_lu_complex_inplace (struct idx *L1_a,
				       struct idx *L2_0_matrix,
				       struct srg *L2_0_srg)
{
  TRACE_PUSH ("C_sign_determinant_lu_complex_inplace");
  {
    struct idx *L_Tmp0;
    if (((L1_a)->dim[0] != (L1_a)->dim[1]))
      {
	run_time_error ("matrix is not square");
      }
    {
      struct idx *L2_1_det;
      int L2_2_n;
      (L2_0_matrix)->srg = L2_0_srg;
      Midx_init_dim1 (L2_0_matrix, 2);
      RTERR_DIM (L2_0_matrix->dim[0] <= 0);
      Midx_maclear (L2_0_matrix, real);
      L2_1_det = L2_0_matrix;
      L2_2_n = (L1_a)->dim[1];
      {
	gsl_matrix_complex ga;
	gsl_permutation *p;
	gsl_complex det;
	int signum;
	p = gsl_permutation_alloc ((L2_2_n));
	IDX2GSL_MATRIX_COMPLEX ((L1_a), ga, double);
	gsl_linalg_complex_LU_decomp (&ga, p, &signum);
	det = gsl_linalg_complex_LU_sgndet (&ga, signum);
	gsl_permutation_free (p);
	memcpy (IDX_PTR ((L2_1_det), double), &det, sizeof (gsl_complex));
      }
      L_Tmp0 = L2_1_det;
    }
    TRACE_POP ("C_sign_determinant_lu_complex_inplace");
    return L_Tmp0;
  }
}

/* ---------------------------------------- */

#ifndef NOLISP

/* Declarations */
extern_c dhdoc_t K_idx_d1sortdown_Rf3df0181;

/*
 * STUB dummy-linalgebra
 */
DH (X_dummy_linalgebra)
{
  dharg ret;
  ret.dh_char = C_dummy_linalgebra ();
  return ret;
}

/*
 * DHDOC dummy-linalgebra
 */
DHDOC (K_dummy_linalgebra_Ra8b05737, X_dummy_linalgebra, "C_dummy_linalgebra",
       0, 0) =
{
DH_FUNC (0), DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB eigen-symm-inplace
 */
DH (X_eigen_symm_inplace)
{
  dharg ret;
  ret.dh_int = C_eigen_symm_inplace (a[1].dh_idx_ptr, a[2].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC eigen-symm-inplace
 */
DHDOC (K_eigen_symm_inplace_Refb18a0c, X_eigen_symm_inplace,
       "C_eigen_symm_inplace", 0, 0) =
{
DH_FUNC (2),
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_REAL,
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ),
    DH_REAL,
    DH_RETURN,
    DH_INT, DH_END_FUNC, DH_REFER (K_idx_d1sortdown_Rf3df0181), DH_NIL};

/*
 * STUB eigen-symmv-inplace
 */
DH (X_eigen_symmv_inplace)
{
  dharg ret;
  ret.dh_int =
    C_eigen_symmv_inplace (a[1].dh_idx_ptr, a[2].dh_idx_ptr, a[3].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC eigen-symmv-inplace
 */
DHDOC (K_eigen_symmv_inplace_R820cd0d5, X_eigen_symmv_inplace,
       "C_eigen_symmv_inplace", 0, 0) =
{
DH_FUNC (3),
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_REAL,
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_REAL,
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ), DH_REAL, DH_RETURN, DH_INT, DH_END_FUNC, DH_NIL};

/*
 * STUB eigen-herm-inplace
 */
DH (X_eigen_herm_inplace)
{
  dharg ret;
  ret.dh_char = C_eigen_herm_inplace (a[1].dh_idx_ptr, a[2].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC eigen-herm-inplace
 */
DHDOC (K_eigen_herm_inplace_R4501aced, X_eigen_herm_inplace,
       "C_eigen_herm_inplace", 0, 0) =
{
DH_FUNC (2),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ),
    DH_REAL,
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ),
    DH_REAL,
    DH_RETURN,
    DH_NIL, DH_END_FUNC, DH_REFER (K_idx_d1sortdown_Rf3df0181), DH_NIL};

/*
 * STUB eigen-hermv-inplace
 */
DH (X_eigen_hermv_inplace)
{
  dharg ret;
  ret.dh_int =
    C_eigen_hermv_inplace (a[1].dh_idx_ptr, a[2].dh_idx_ptr, a[3].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC eigen-hermv-inplace
 */
DHDOC (K_eigen_hermv_inplace_R820cd0d5, X_eigen_hermv_inplace,
       "C_eigen_hermv_inplace", 0, 0) =
{
DH_FUNC (3),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ),
    DH_REAL,
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ),
    DH_REAL,
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ), DH_REAL, DH_RETURN, DH_INT, DH_END_FUNC, DH_NIL};

/*
 * STUB svd-inplace
 */
DH (X_svd_inplace)
{
  dharg ret;
  ret.dh_int =
    C_svd_inplace (a[1].dh_idx_ptr, a[2].dh_idx_ptr, a[3].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC svd-inplace
 */
DHDOC (K_svd_inplace_R820cd0d5, X_svd_inplace, "C_svd_inplace", 0, 0) =
{
DH_FUNC (3),
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_REAL,
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_REAL,
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ), DH_REAL, DH_RETURN, DH_INT, DH_END_FUNC, DH_NIL};

/*
 * STUB lu-decomp-inplace
 */
DH (X_lu_decomp_inplace)
{
  dharg ret;
  ret.dh_int =
    C_lu_decomp_inplace (a[1].dh_idx_ptr, a[2].dh_idx_ptr, a[3].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC lu-decomp-inplace
 */
DHDOC (K_lu_decomp_inplace_Re079079d, X_lu_decomp_inplace,
       "C_lu_decomp_inplace", 0, 0) =
{
DH_FUNC (3),
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_REAL,
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ),
    DH_INT,
    DH_IDX (DHT_READ, 0),
    DH_SRG (DHT_READ), DH_INT, DH_RETURN, DH_INT, DH_END_FUNC, DH_NIL};

/*
 * STUB lu-decomp-complex-inplace
 */
DH (X_lu_decomp_complex_inplace)
{
  dharg ret;
  ret.dh_int =
    C_lu_decomp_complex_inplace (a[1].dh_idx_ptr, a[2].dh_idx_ptr,
				 a[3].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC lu-decomp-complex-inplace
 */
DHDOC (K_lu_decomp_complex_inplace_Re079079d, X_lu_decomp_complex_inplace,
       "C_lu_decomp_complex_inplace", 0, 0) =
{
DH_FUNC (3),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ),
    DH_REAL,
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ),
    DH_INT,
    DH_IDX (DHT_READ, 0),
    DH_SRG (DHT_READ), DH_INT, DH_RETURN, DH_INT, DH_END_FUNC, DH_NIL};

/*
 * STUB cholesky-decomp-inplace
 */
DH (X_cholesky_decomp_inplace)
{
  dharg ret;
  ret.dh_int = C_cholesky_decomp_inplace (a[1].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC cholesky-decomp-inplace
 */
DHDOC (K_cholesky_decomp_inplace_R596f2760, X_cholesky_decomp_inplace,
       "C_cholesky_decomp_inplace", 0, 0) =
{
DH_FUNC (1),
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ), DH_REAL, DH_RETURN, DH_INT, DH_END_FUNC, DH_NIL};

/*
 * STUB solve-sv-inplace
 */
DH (X_solve_sv_inplace)
{
  dharg ret;
  ret.dh_int =
    C_solve_sv_inplace (a[1].dh_idx_ptr, a[2].dh_idx_ptr, a[3].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC solve-sv-inplace
 */
DHDOC (K_solve_sv_inplace_R820cd0d5, X_solve_sv_inplace, "C_solve_sv_inplace",
       0, 0) =
{
DH_FUNC (3),
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_REAL,
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ),
    DH_REAL,
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ), DH_REAL, DH_RETURN, DH_INT, DH_END_FUNC, DH_NIL};

/*
 * STUB solve-hh-inplace
 */
DH (X_solve_hh_inplace)
{
  dharg ret;
  ret.dh_int = C_solve_hh_inplace (a[1].dh_idx_ptr, a[2].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC solve-hh-inplace
 */
DHDOC (K_solve_hh_inplace_Refb18a0c, X_solve_hh_inplace, "C_solve_hh_inplace",
       0, 0) =
{
DH_FUNC (2),
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_REAL,
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ), DH_REAL, DH_RETURN, DH_INT, DH_END_FUNC, DH_NIL};

/*
 * STUB solve-lu-inplace
 */
DH (X_solve_lu_inplace)
{
  dharg ret;
  ret.dh_int = C_solve_lu_inplace (a[1].dh_idx_ptr, a[2].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC solve-lu-inplace
 */
DHDOC (K_solve_lu_inplace_Refb18a0c, X_solve_lu_inplace, "C_solve_lu_inplace",
       0, 0) =
{
DH_FUNC (2),
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_REAL,
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ), DH_REAL, DH_RETURN, DH_INT, DH_END_FUNC, DH_NIL};

/*
 * STUB solve-lu-complex-inplace
 */
DH (X_solve_lu_complex_inplace)
{
  dharg ret;
  ret.dh_int = C_solve_lu_complex_inplace (a[1].dh_idx_ptr, a[2].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC solve-lu-complex-inplace
 */
DHDOC (K_solve_lu_complex_inplace_Refb18a0c, X_solve_lu_complex_inplace,
       "C_solve_lu_complex_inplace", 0, 0) =
{
DH_FUNC (2),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ),
    DH_REAL,
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ), DH_REAL, DH_RETURN, DH_INT, DH_END_FUNC, DH_NIL};

/*
 * STUB inverse-lu-inplace
 */
DH (X_inverse_lu_inplace)
{
  dharg ret;
  ret.dh_int = C_inverse_lu_inplace (a[1].dh_idx_ptr, a[2].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC inverse-lu-inplace
 */
DHDOC (K_inverse_lu_inplace_Refb18a0c, X_inverse_lu_inplace,
       "C_inverse_lu_inplace", 0, 0) =
{
DH_FUNC (2),
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_REAL,
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ), DH_REAL, DH_RETURN, DH_INT, DH_END_FUNC, DH_NIL};

/*
 * STUB inverse-lu-complex-inplace
 */
DH (X_inverse_lu_complex_inplace)
{
  dharg ret;
  ret.dh_int =
    C_inverse_lu_complex_inplace (a[1].dh_idx_ptr, a[2].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC inverse-lu-complex-inplace
 */
DHDOC (K_inverse_lu_complex_inplace_Refb18a0c, X_inverse_lu_complex_inplace,
       "C_inverse_lu_complex_inplace", 0, 0) =
{
DH_FUNC (2),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ),
    DH_REAL,
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ), DH_REAL, DH_RETURN, DH_INT, DH_END_FUNC, DH_NIL};

/*
 * STUB determinant-lu-inplace
 */
DH (X_determinant_lu_inplace)
{
  dharg ret;
  ret.dh_real = C_determinant_lu_inplace (a[1].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC determinant-lu-inplace
 */
DHDOC (K_determinant_lu_inplace_R715725ac, X_determinant_lu_inplace,
       "C_determinant_lu_inplace", 0, 0) =
{
DH_FUNC (1),
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ), DH_REAL, DH_RETURN, DH_REAL, DH_END_FUNC, DH_NIL};

/*
 * STUB determinant-lu-complex-inplace
 */
DH (X_determinant_lu_complex_inplace)
{
  dharg ret;
  ret.dh_idx_ptr =
    C_determinant_lu_complex_inplace (a[1].dh_idx_ptr, a[2].dh_idx_ptr,
				      a[3].dh_srg_ptr);
  return ret;
}

/*
 * DHDOC determinant-lu-complex-inplace
 */
DHDOC (K_determinant_lu_complex_inplace_R24031869,
       X_determinant_lu_complex_inplace, "C_determinant_lu_complex_inplace",
       0, 0) =
{
DH_FUNC (1),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ),
    DH_REAL,
    DH_TEMPS (2),
    DH_IDX (DHT_WRITE, 1), DH_REAL,
    DH_SRG (DHT_WRITE), DH_REAL,
    DH_END_TEMPS,
    DH_RETURN,
    DH_IDX (DHT_READ, 1), DH_SRG (DHT_READ), DH_REAL, DH_END_FUNC, DH_NIL};

/*
 * STUB log-determinant-lu-inplace
 */
DH (X_log_determinant_lu_inplace)
{
  dharg ret;
  ret.dh_real = C_log_determinant_lu_inplace (a[1].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC log-determinant-lu-inplace
 */
DHDOC (K_log_determinant_lu_inplace_R715725ac, X_log_determinant_lu_inplace,
       "C_log_determinant_lu_inplace", 0, 0) =
{
DH_FUNC (1),
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ), DH_REAL, DH_RETURN, DH_REAL, DH_END_FUNC, DH_NIL};

/*
 * STUB log-determinant-lu-complex-inplace
 */
DH (X_log_determinant_lu_complex_inplace)
{
  dharg ret;
  ret.dh_real = C_log_determinant_lu_complex_inplace (a[1].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC log-determinant-lu-complex-inplace
 */
DHDOC (K_log_determinant_lu_complex_inplace_R715725ac,
       X_log_determinant_lu_complex_inplace,
       "C_log_determinant_lu_complex_inplace", 0, 0) =
{
DH_FUNC (1),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ), DH_REAL, DH_RETURN, DH_REAL, DH_END_FUNC, DH_NIL};

/*
 * STUB sign-determinant-lu-inplace
 */
DH (X_sign_determinant_lu_inplace)
{
  dharg ret;
  ret.dh_real = C_sign_determinant_lu_inplace (a[1].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC sign-determinant-lu-inplace
 */
DHDOC (K_sign_determinant_lu_inplace_R715725ac, X_sign_determinant_lu_inplace,
       "C_sign_determinant_lu_inplace", 0, 0) =
{
DH_FUNC (1),
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ), DH_REAL, DH_RETURN, DH_REAL, DH_END_FUNC, DH_NIL};

/*
 * STUB sign-determinant-lu-complex-inplace
 */
DH (X_sign_determinant_lu_complex_inplace)
{
  dharg ret;
  ret.dh_idx_ptr =
    C_sign_determinant_lu_complex_inplace (a[1].dh_idx_ptr, a[2].dh_idx_ptr,
					   a[3].dh_srg_ptr);
  return ret;
}

/*
 * DHDOC sign-determinant-lu-complex-inplace
 */
DHDOC (K_sign_determinant_lu_complex_inplace_R24031869,
       X_sign_determinant_lu_complex_inplace,
       "C_sign_determinant_lu_complex_inplace", 0, 0) =
{
DH_FUNC (1),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ),
    DH_REAL,
    DH_TEMPS (2),
    DH_IDX (DHT_WRITE, 1), DH_REAL,
    DH_SRG (DHT_WRITE), DH_REAL,
    DH_END_TEMPS,
    DH_RETURN,
    DH_IDX (DHT_READ, 1), DH_SRG (DHT_READ), DH_REAL, DH_END_FUNC, DH_NIL};

/*
 * INIT FUNCTION
 */
extern_c void
init_linalgebra (void)
{
  dh_define ("dummy-linalgebra", &K_dummy_linalgebra_Ra8b05737);
  dh_define ("eigen-symm-inplace", &K_eigen_symm_inplace_Refb18a0c);
  dh_define ("eigen-symmv-inplace", &K_eigen_symmv_inplace_R820cd0d5);
  dh_define ("eigen-herm-inplace", &K_eigen_herm_inplace_R4501aced);
  dh_define ("eigen-hermv-inplace", &K_eigen_hermv_inplace_R820cd0d5);
  dh_define ("svd-inplace", &K_svd_inplace_R820cd0d5);
  dh_define ("lu-decomp-inplace", &K_lu_decomp_inplace_Re079079d);
  dh_define ("lu-decomp-complex-inplace",
	     &K_lu_decomp_complex_inplace_Re079079d);
  dh_define ("cholesky-decomp-inplace", &K_cholesky_decomp_inplace_R596f2760);
  dh_define ("solve-sv-inplace", &K_solve_sv_inplace_R820cd0d5);
  dh_define ("solve-hh-inplace", &K_solve_hh_inplace_Refb18a0c);
  dh_define ("solve-lu-inplace", &K_solve_lu_inplace_Refb18a0c);
  dh_define ("solve-lu-complex-inplace",
	     &K_solve_lu_complex_inplace_Refb18a0c);
  dh_define ("inverse-lu-inplace", &K_inverse_lu_inplace_Refb18a0c);
  dh_define ("inverse-lu-complex-inplace",
	     &K_inverse_lu_complex_inplace_Refb18a0c);
  dh_define ("determinant-lu-inplace", &K_determinant_lu_inplace_R715725ac);
  dh_define ("determinant-lu-complex-inplace",
	     &K_determinant_lu_complex_inplace_R24031869);
  dh_define ("log-determinant-lu-inplace",
	     &K_log_determinant_lu_inplace_R715725ac);
  dh_define ("log-determinant-lu-complex-inplace",
	     &K_log_determinant_lu_complex_inplace_R715725ac);
  dh_define ("sign-determinant-lu-inplace",
	     &K_sign_determinant_lu_inplace_R715725ac);
  dh_define ("sign-determinant-lu-complex-inplace",
	     &K_sign_determinant_lu_complex_inplace_R24031869);
}

int majver_linalgebra = 40;
int minver_linalgebra = 10;

#endif
