/* WARNING: Automatically generated code.
 * This code has been generated by the DH compiler.
 */
#ifdef HAVE_CONFIG_H
# include "lushconf.h"
#endif

/*
 * LUSH HEADERS
 */
#include "header.h"
#include "dh.h"
#include "idxmac.h"
#include "idxops.h"
#include "check_func.h"

/*
 * DECLARATIONS
 */
extern_c char C_compute_bilin_transform (struct idx *, struct idx *, flt, flt,
					 flt, flt, flt, flt, flt, flt, flt,
					 flt, flt, flt);

/* ---------------------------------------- */

/*
 * FUNCTION ubimage2flt
 */
extern_c char
C_ubimage2flt (struct idx *L1_in, struct idx *L1_out)
{
  TRACE_PUSH ("C_ubimage2flt");
  {
    {
      RTERR_LOOPDIM ((L1_out)->dim[0] != (L1_in)->dim[0]);
      Midx_begin_bloop2 (L2_in, L1_in, L2_out, L1_out, flt)
      {
	{
	  register unsigned char *ip;
	  register flt *op;
	  register int i, jmax = (&L2_in)->dim[0];
	  register int imat1_m0 = (&L2_in)->mod[0];
	  register int imat2_m0 = (&L2_out)->mod[0];
	  ip = IDX_PTR ((&L2_in), unsigned char);
	  op = IDX_PTR ((&L2_out), flt);
	  for (i = 0; i < jmax; i++)
	    {;
	      *op = ((flt) (*ip)) * 0.00392157;
	      ip += imat1_m0;
	      op += imat2_m0;
	    }
	}
      }
      Midx_end_bloop2 (L2_in, L1_in, L2_out, L1_out, flt);
    }
    TRACE_POP ("C_ubimage2flt");
    return 0;
  }
}

/*
 * FUNCTION flt2ubimage
 */
extern_c char
C_flt2ubimage (struct idx *L1_in, struct idx *L1_out)
{
  TRACE_PUSH ("C_flt2ubimage");
  {
    {
      RTERR_LOOPDIM ((L1_out)->dim[0] != (L1_in)->dim[0]);
      Midx_begin_bloop2 (L2_in, L1_in, L2_out, L1_out, unsigned char)
      {
	{
	  register flt *ip;
	  register unsigned char *op;
	  register int i, jmax = (&L2_in)->dim[0];
	  register int imat1_m0 = (&L2_in)->mod[0];
	  register int imat2_m0 = (&L2_out)->mod[0];
	  ip = IDX_PTR ((&L2_in), flt);
	  op = IDX_PTR ((&L2_out), unsigned char);
	  for (i = 0; i < jmax; i++)
	    {;
	      *op = (unsigned char) ((*ip) * 255);
	      ip += imat1_m0;
	      op += imat2_m0;
	}}
      } Midx_end_bloop2 (L2_in, L1_in, L2_out, L1_out, unsigned char);
    }
    TRACE_POP ("C_flt2ubimage");
    return 0;
  }
}

/*
 * FUNCTION ubimage2fltimage
 */
extern_c char
C_ubimage2fltimage (struct idx *L1_in, struct idx *L1_out, flt L1_bkgd,
		    flt L1_ink)
{
  TRACE_PUSH ("C_ubimage2fltimage");
  {
    if ((L1_bkgd == L1_ink))
      {
	run_time_error ("ubimage2fltimage: background must differ from ink");
      }
    {
      flt L2_0_a;
      L2_0_a = ((L1_ink - L1_bkgd) / (flt) 255);
      {
	RTERR_LOOPDIM ((L1_out)->dim[0] != (L1_in)->dim[0]);
	Midx_begin_bloop2 (L3_in, L1_in, L3_out, L1_out, flt)
	{
	  {
	    register unsigned char *ip;
	    register flt *op;
	    register int i, jmax = (&L3_in)->dim[0];
	    register int imat1_m0 = (&L3_in)->mod[0];
	    register int imat2_m0 = (&L3_out)->mod[0];
	    ip = IDX_PTR ((&L3_in), unsigned char);
	    op = IDX_PTR ((&L3_out), flt);
	    for (i = 0; i < jmax; i++)
	      {;
		*op = (flt) (*ip) * L2_0_a + L1_bkgd;
		ip += imat1_m0;
		op += imat2_m0;
	      }
	  }
	}
	Midx_end_bloop2 (L3_in, L1_in, L3_out, L1_out, flt);
      }
    }
    TRACE_POP ("C_ubimage2fltimage");
    return 0;
  }
}

/*
 * FUNCTION fltimage2ubimage
 */
extern_c char
C_fltimage2ubimage (struct idx *L1_in, struct idx *L1_out, flt L1_bkgd,
		    flt L1_ink)
{
  TRACE_PUSH ("C_fltimage2ubimage");
  {
    if ((L1_bkgd == L1_ink))
      {
	run_time_error ("fltimage2ubimage: background must differ from ink");
      }
    {
      flt L2_0_a;
      flt L2_1_b;
      L2_0_a = (255 / (flt) (L1_ink - L1_bkgd));
      L2_1_b = (L2_0_a * (-L1_bkgd));
      {
	RTERR_LOOPDIM ((L1_out)->dim[0] != (L1_in)->dim[0]);
	Midx_begin_bloop2 (L3_in, L1_in, L3_out, L1_out, unsigned char)
	{
	  {
	    register flt *ip;
	    register unsigned char *op;
	    register int i, jmax = (&L3_in)->dim[0];
	    register int imat1_m0 = (&L3_in)->mod[0];
	    register int imat2_m0 = (&L3_out)->mod[0];
	    ip = IDX_PTR ((&L3_in), flt);
	    op = IDX_PTR ((&L3_out), unsigned char);
	    for (i = 0; i < jmax; i++)
	      {;
		*op = (unsigned char) ((*ip) * L2_0_a + L2_1_b);
		ip += imat1_m0;
		op += imat2_m0;
	  }}
	} Midx_end_bloop2 (L3_in, L1_in, L3_out, L1_out, unsigned char);
      }
    }
    TRACE_POP ("C_fltimage2ubimage");
    return 0;
  }
}

/*
 * FUNCTION ubim-subsample
 */
extern_c struct idx *
C_ubim_subsample (struct idx *L1_in, int L1_nlin, int L1_ncol,
		  struct idx *L2_0_matrix, struct srg *L2_0_srg,
		  struct idx *L2_3_matrix, struct srg *L2_3_srg)
{
  TRACE_PUSH ("C_ubim_subsample");
  {
    struct idx *L_Tmp0;
    char L_Tmp1;
    if ((L1_nlin == 1))
      {
	if ((L1_ncol == 1))
	  {
	    L_Tmp1 = 1;
	  }
	else
	  {
	    L_Tmp1 = 0;
	  }
      }
    else
      {
	L_Tmp1 = 0;
      }
    if (L_Tmp1)
      {
	{
	  (L2_0_matrix)->srg = L2_0_srg;
	  Midx_init_dim2 (L2_0_matrix, (L1_in)->dim[0], (L1_in)->dim[1]);
	  RTERR_DIM (L2_0_matrix->dim[0] <= 0);
	  RTERR_DIM (L2_0_matrix->dim[1] <= 0);
	  check_main_maout_any (L1_in, L2_0_matrix);
	  Midx_macopy (L1_in, L2_0_matrix, unsigned char, unsigned char);
	  L_Tmp0 = L2_0_matrix;
	}
      }
    else
      {
	{
	  real L2_2_h;
	  real L2_3_w;
	  real L2_4_nh;
	  real L2_5_nw;
	  Midx_declare (L3_6_2_clone, 2);
	  struct idx *L2_7_inp;
	  struct idx *L2_8_out;
	  Midx_init (L3_6_2_clone, 2);
	  L2_2_h = (L1_in)->dim[0];
	  L2_3_w = (L1_in)->dim[1];
	  L2_4_nh = (L2_2_h / (real) L1_nlin);
	  L2_4_nh = ((int) floor ((double) L2_4_nh));
	  L2_5_nw = (L2_3_w / (real) L1_ncol);
	  L2_5_nw = ((int) floor ((double) L2_5_nw));
	  {
	    Midx_declare (L4_9_1_clone, 2);
	    struct idx *L3_10___m;
	    struct idx *L_Tmp11;
	    real L_Tmp14;
	    Midx_init (L4_9_1_clone, 2);
	    {
	      struct idx *L4_12___m;
	      real L_Tmp13;
	      Midx_clone2 (L4_9_1_clone, L1_in);
	      L4_12___m = L4_9_1_clone;
	      L_Tmp13 = (L1_nlin * L2_4_nh);
	      RTERR_GEN ((((int) L_Tmp13) < 1
			  || ((int) 0) < 0), "illegal 'size' or 'offset'");
	      RTERR_GEN ((((int) 0) + ((int) L_Tmp13) >
			  (L4_12___m)->dim[((int) 0)]),
			 "specified interval is too large");
	      Midx_narrow (L4_12___m, ((int) 0), ((int) L_Tmp13), ((int) 0),
			   unsigned char);
	      L_Tmp11 = L4_12___m;
	    }
	    Midx_clone2 (L3_6_2_clone, L_Tmp11);
	    L3_10___m = L3_6_2_clone;
	    L_Tmp14 = (L1_ncol * L2_5_nw);
	    RTERR_GEN ((((int) L_Tmp14) < 1
			|| ((int) 0) < 0), "illegal 'size' or 'offset'");
	    RTERR_GEN ((((int) 0) + ((int) L_Tmp14) >
			(L3_10___m)->dim[((int) 1)]),
		       "specified interval is too large");
	    Midx_narrow (L3_10___m, ((int) 1), ((int) L_Tmp14), ((int) 0),
			 unsigned char);
	    L2_7_inp = L3_10___m;
	  }
	  (L2_3_matrix)->srg = L2_3_srg;
	  Midx_init_dim2 (L2_3_matrix, L2_4_nh, L2_5_nw);
	  RTERR_DIM (L2_3_matrix->dim[0] <= 0);
	  RTERR_DIM (L2_3_matrix->dim[1] <= 0);
	  L2_8_out = L2_3_matrix;
	  {
	    unsigned char *_idx2loopc1, *pin;
	    unsigned char *_idx2loopc2, *pout;
	    int i, _imax = ((L2_8_out))->dim[0];
	    int j, _jmax = ((L2_8_out))->dim[1];
	    int _imat1_m0 = ((L2_7_inp))->mod[0];
	    int _imat1_m1 = ((L2_7_inp))->mod[1];
	    int _imat2_m0 = ((L2_8_out))->mod[0];
	    int _imat2_m1 = ((L2_8_out))->mod[1];
	    int pin_incr = (L1_ncol) * _imat1_m1;
	    int norm = (L1_ncol) * (L1_nlin);
	    register int acc0;
	    register int k, l;
	    register unsigned char *pinptr;
	    register int pinptr_incr = _imat1_m0 - (L1_ncol) * _imat1_m1;
	    _idx2loopc1 = IDX_PTR (((L2_7_inp)), unsigned char);
	    _idx2loopc2 = IDX_PTR (((L2_8_out)), unsigned char);
	    for (i = 0; i < _imax; i++)
	      {
		pin = _idx2loopc1;
		pout = _idx2loopc2;
		for (j = 0; j < _jmax; j++)
		  {
		    acc0 = 0;
		    pinptr = pin;
		    for (k = 0; k < (L1_nlin); k++)
		      {
			for (l = 0; l < (L1_ncol); l++)
			  {
			    acc0 += pinptr[0];
			    pinptr += _imat1_m1;
			  }
			pinptr += pinptr_incr;
		      }
		    pout[0] = acc0 / norm;
		    pin += pin_incr;
		    pout += _imat2_m1;
		  }
		_idx2loopc1 += _imat1_m0 * (L1_nlin);
		_idx2loopc2 += _imat2_m0;
	      }
	  }
	  L_Tmp0 = L2_8_out;
	}
      }
    TRACE_POP ("C_ubim_subsample");
    return L_Tmp0;
  }
}

/*
 * FUNCTION ubim-invert
 */
extern_c char
C_ubim_invert (struct idx *L1_im)
{
  TRACE_PUSH ("C_ubim_invert");
  {
    {
      register unsigned char *_idx2loopc, *p;
      register int i, _imax = (L1_im)->dim[0];
      register int j, _jmax = (L1_im)->dim[1];
      register int _imat1_m0 = (L1_im)->mod[0];
      register int _imat1_m1 = (L1_im)->mod[1];
      _idx2loopc = IDX_PTR ((L1_im), unsigned char);
      for (i = 0; i < _imax; i++)
	{;
	  p = _idx2loopc;
	  for (j = 0; j < _jmax; j++)
	    {;
	      *p = 255 - *p;
	      p += _imat1_m1;
	    }
	  _idx2loopc += _imat1_m0;
	}
    }
    TRACE_POP ("C_ubim_invert");
    return 0;
  }
}

/*
 * FUNCTION ubim-zoom
 */
extern_c struct idx *
C_ubim_zoom (struct idx *L1_ubim, int L1_zoomx, int L1_zoomy,
	     struct idx *L2_0_matrix, struct srg *L2_0_srg)
{
  TRACE_PUSH ("C_ubim_zoom");
  {
    struct idx *L_Tmp0;
    {
      struct idx *L2_1_ans;
      Midx_declare (L2_2_1_unfold, 3);
      Midx_declare (L2_3_2_unfold, 4);
      struct idx *L2_4_uans;
      struct idx *L_Tmp5;
      int L_Tmp6;
      int L_Tmp7;
      Midx_init (L2_2_1_unfold, 3);
      Midx_init (L2_3_2_unfold, 4);
      (L2_0_matrix)->srg = L2_0_srg;
      Midx_init_dim2 (L2_0_matrix, (L1_zoomy * (L1_ubim)->dim[0]),
		      (L1_zoomx * (L1_ubim)->dim[1]));
      RTERR_DIM (L2_0_matrix->dim[0] <= 0);
      RTERR_DIM (L2_0_matrix->dim[1] <= 0);
      Midx_maclear (L2_0_matrix, unsigned char);
      L2_1_ans = L2_0_matrix;
      Midx_clone2 (L2_2_1_unfold, L2_1_ans);
      RTERR_GEN ((((int) L1_zoomy) < 1
		  || ((int) L1_zoomy) < 1), "illegal 'size' or 'step'");
      L_Tmp6 =
	1 + ((L2_2_1_unfold)->dim[((int) 0)] -
	     ((int) L1_zoomy)) / ((int) L1_zoomy);
      RTERR_GEN ((L_Tmp6 <= 0
		  || (L2_2_1_unfold)->dim[((int) 0)] !=
		  ((int) L1_zoomy) * (L_Tmp6 - 1) + ((int) L1_zoomy)),
		 "Index dimension does not match size and step");
      Midx_unfold (L2_2_1_unfold, ((int) 0), ((int) L1_zoomy),
		   ((int) L1_zoomy), unsigned char);
      L_Tmp5 = L2_2_1_unfold;
      Midx_clone3 (L2_3_2_unfold, L_Tmp5);
      RTERR_GEN ((((int) L1_zoomx) < 1
		  || ((int) L1_zoomx) < 1), "illegal 'size' or 'step'");
      L_Tmp7 =
	1 + ((L2_3_2_unfold)->dim[((int) 1)] -
	     ((int) L1_zoomx)) / ((int) L1_zoomx);
      RTERR_GEN ((L_Tmp7 <= 0
		  || (L2_3_2_unfold)->dim[((int) 1)] !=
		  ((int) L1_zoomx) * (L_Tmp7 - 1) + ((int) L1_zoomx)),
		 "Index dimension does not match size and step");
      Midx_unfold (L2_3_2_unfold, ((int) 1), ((int) L1_zoomx),
		   ((int) L1_zoomx), unsigned char);
      L2_4_uans = L2_3_2_unfold;
      {
	Midx_begin_eloop1 (L3_uans1, L2_4_uans, unsigned char)
	{
	  {
	    Midx_begin_eloop1 (L4_uans2, &L3_uans1, unsigned char)
	    {
	      check_main_maout (L1_ubim, &L4_uans2);
	      Midx_m2copy (L1_ubim, &L4_uans2, unsigned char, unsigned char);
	    } Midx_end_eloop1 (L4_uans2, &L3_uans1, unsigned char);
	  }
	} Midx_end_eloop1 (L3_uans1, L2_4_uans, unsigned char);
      }
      L_Tmp0 = L2_1_ans;
    }
    TRACE_POP ("C_ubim_zoom");
    return L_Tmp0;
  }
}

/*
 * FUNCTION ubim-interpolate-bilin
 */
extern_c unsigned char
C_ubim_interpolate_bilin (int L1_background, unsigned char *L1_pin,
			  int L1_indimi, int L1_indimj, int L1_inmodi,
			  int L1_inmodj, int L1_ppi, int L1_ppj)
{
  TRACE_PUSH ("C_ubim_interpolate_bilin");
  {
    unsigned char L_Tmp0;
    {
      unsigned char L2_1_out;
      L2_1_out = 0;
      {
	int li0, lj0;
	register int li1, lj1;
	int deltai, ndeltai;
	int deltaj, ndeltaj;
	register unsigned char *pin00;
	register int v00, v01, v10, v11;
	li0 = (L1_ppi) >> 16;
	li1 = li0 + 1;
	deltai = (L1_ppi) & 0x0000ffff;
	ndeltai = 0x00010000 - deltai;
	lj0 = (L1_ppj) >> 16;
	lj1 = lj0 + 1;
	deltaj = (L1_ppj) & 0x0000ffff;
	ndeltaj = 0x00010000 - deltaj;
	pin00 =
	  (unsigned char *) ((L1_pin)) + (L1_inmodi) * li0 +
	  (L1_inmodj) * lj0;

	if ((li1 > 0) && (li1 < (L1_indimi)))
	  {
	    if ((lj1 > 0) && (lj1 < (L1_indimj)))
	      {
		v00 = *(pin00);
		v01 = *(pin00 + (L1_inmodj));
		v11 = *(pin00 + (L1_inmodi) + (L1_inmodj));
		v10 = *(pin00 + (L1_inmodi));
	      }
	    else if (lj1 == 0)
	      {
		v00 = (L1_background);
		v01 = *(pin00 + (L1_inmodj));
		v11 = *(pin00 + (L1_inmodi) + (L1_inmodj));
		v10 = (L1_background);
	      }
	    else if (lj1 == (L1_indimj))
	      {
		v00 = *(pin00);
		v01 = (L1_background);
		v11 = (L1_background);
		v10 = *(pin00 + (L1_inmodi));
	      }
	    else
	      {
		v00 = (L1_background);
		v01 = (L1_background);
		v11 = (L1_background);
		v10 = (L1_background);
	      }

	  }
	else if (li1 == 0)
	  {
	    if ((lj1 > 0) && (lj1 < (L1_indimj)))
	      {
		v00 = (L1_background);
		v01 = (L1_background);
		v11 = *(pin00 + (L1_inmodi) + (L1_inmodj));
		v10 = *(pin00 + (L1_inmodi));
	      }
	    else if (lj1 == 0)
	      {
		v00 = (L1_background);
		v01 = (L1_background);
		v11 = *(pin00 + (L1_inmodi) + (L1_inmodj));
		v10 = (L1_background);
	      }
	    else if (lj1 == (L1_indimj))
	      {
		v00 = (L1_background);
		v01 = (L1_background);
		v11 = (L1_background);
		v10 = *(pin00 + (L1_inmodi));
	      }
	    else
	      {
		v00 = (L1_background);
		v01 = (L1_background);
		v11 = (L1_background);
		v10 = (L1_background);
	      }

	  }
	else if (li1 == (L1_indimi))
	  {
	    if ((lj1 > 0) && (lj1 < (L1_indimj)))
	      {
		v00 = *(pin00);
		v01 = *(pin00 + (L1_inmodj));
		v11 = (L1_background);
		v10 = (L1_background);
	      }
	    else if (lj1 == 0)
	      {
		v00 = (L1_background);
		v01 = *(pin00 + (L1_inmodj));
		v11 = (L1_background);
		v10 = (L1_background);
	      }
	    else if (lj1 == (L1_indimj))
	      {
		v00 = *(pin00);
		v01 = (L1_background);
		v11 = (L1_background);
		v10 = (L1_background);
	      }
	    else
	      {
		v00 = (L1_background);
		v01 = (L1_background);
		v11 = (L1_background);
		v10 = (L1_background);
	      }

	  }
	else
	  {
	    v00 = (L1_background);
	    v01 = (L1_background);
	    v11 = (L1_background);
	    v10 = (L1_background);
	  }
	(L2_1_out) = (ndeltaj * ((v10 * deltai + v00 * ndeltai) >> 16) +
		      deltaj * ((v11 * deltai + v01 * ndeltai) >> 16)) >> 16;
      }
      L_Tmp0 = L2_1_out;
    }
    TRACE_POP ("C_ubim_interpolate_bilin");
    return L_Tmp0;
  }
}

/*
 * FUNCTION ubim-warp
 */
extern_c char
C_ubim_warp (struct idx *L1_in, struct idx *L1_out, int L1_background,
	     struct idx *L1_pi, struct idx *L1_pj)
{
  TRACE_PUSH ("C_ubim_warp");
  {
    {
      real L2_0_ni;
      real L2_1_nj;
      gptr L2_2_pin;
      int L2_3_indimi;
      int L2_4_indimj;
      int L2_5_inmodi;
      int L2_6_inmodj;
      L2_0_ni = (L1_in)->dim[0];
      L2_1_nj = (L1_in)->dim[1];
      L2_2_pin = (gptr) (IDX_PTR (L1_in, unsigned char));
      L2_3_indimi = (L1_in)->dim[0];
      L2_4_indimj = (L1_in)->dim[1];
      L2_5_inmodi = (L1_in)->mod[0];
      L2_6_inmodj = (L1_in)->mod[1];
      {
	RTERR_LOOPDIM ((L1_pj)->dim[0] != (L1_pi)->dim[0]
		       || (L1_pj)->dim[0] != (L1_out)->dim[0]);
	Midx_begin_bloop3 (L3_lout, L1_out, L3_lpi, L1_pi, L3_lpj, L1_pj, int)
	{
	  {
	    RTERR_LOOPDIM ((&L3_lpj)->dim[0] != (&L3_lpi)->dim[0]
			   || (&L3_lpj)->dim[0] != (&L3_lout)->dim[0]);
	    Midx_begin_bloop3 (L4_llout, &L3_lout, L4_llpi, &L3_lpi, L4_llpj,
			       &L3_lpj, int)
	    {
	      {
		int L5_7_ppi;
		int L5_8_ppj;
		unsigned char L_Tmp9;
		L5_7_ppi = *IDX_PTR (&L4_llpi, int);
		L5_8_ppj = *IDX_PTR (&L4_llpj, int);
		L_Tmp9 =
		  (unsigned char) C_ubim_interpolate_bilin (L1_background,
							    (unsigned char
							     *) (L2_2_pin),
							    L2_3_indimi,
							    L2_4_indimj,
							    L2_5_inmodi,
							    L2_6_inmodj,
							    L5_7_ppi,
							    L5_8_ppj);
		*IDX_PTR (&L4_llout, unsigned char) = L_Tmp9;
	      }
	    } Midx_end_bloop3 (L4_llout, &L3_lout, L4_llpi, &L3_lpi, L4_llpj,
			       &L3_lpj, int);
	  }
	} Midx_end_bloop3 (L3_lout, L1_out, L3_lpi, L1_pi, L3_lpj, L1_pj,
			   int);
      }
    }
    TRACE_POP ("C_ubim_warp");
    return 0;
  }
}

/*
 * FUNCTION ubim-warp-fast
 */
extern_c char
C_ubim_warp_fast (struct idx *L1_in, struct idx *L1_out, int L1_background,
		  struct idx *L1_pi, struct idx *L1_pj)
{
  TRACE_PUSH ("C_ubim_warp_fast");
  {
    {
      real L2_0_ni;
      real L2_1_nj;
      gptr L2_2_pin;
      int L2_3_indimi;
      int L2_4_indimj;
      int L2_5_inmodi;
      int L2_6_inmodj;
      L2_0_ni = (L1_in)->dim[0];
      L2_1_nj = (L1_in)->dim[1];
      L2_2_pin = (gptr) (IDX_PTR (L1_in, unsigned char));
      L2_3_indimi = (L1_in)->dim[0];
      L2_4_indimj = (L1_in)->dim[1];
      L2_5_inmodi = (L1_in)->mod[0];
      L2_6_inmodj = (L1_in)->mod[1];
      {
	Midx_begin_bloop3 (L3_lout, L1_out, L3_lpi, L1_pi, L3_lpj, L1_pj, int)
	{
	  {
	    Midx_begin_bloop3 (L4_llout, &L3_lout, L4_llpi, &L3_lpi, L4_llpj,
			       &L3_lpj, int)
	    {
	      {
		int L5_7_ppi;
		int L5_8_ppj;
		L5_7_ppi = *IDX_PTR (&L4_llpi, int);
		L5_8_ppj = *IDX_PTR (&L4_llpj, int);
		{
		  unsigned char L6_9_resu;
		  L6_9_resu = 0;
		  {
		    register int li, lj;
		    li = ((L5_7_ppi) + 0x7f) >> 16;
		    lj = ((L5_8_ppj) + 0x7f) >> 16;
		    if ((li >= 0) && (li < (L2_3_indimi)) && (lj >= 0)
			&& (lj < (L2_4_indimj)))
		      {
			(L6_9_resu) =
			  *((unsigned char *) ((L2_2_pin)) +
			    (L2_5_inmodi) * li + (L2_6_inmodj) * lj);
		      }
		    else
		      {
			(L6_9_resu) = (L1_background);
		      }
		  }
		  *IDX_PTR (&L4_llout, unsigned char) = L6_9_resu;
		}
	      }
	    } Midx_end_bloop3 (L4_llout, &L3_lout, L4_llpi, &L3_lpi, L4_llpj,
			       &L3_lpj, int);
	  }
	} Midx_end_bloop3 (L3_lout, L1_out, L3_lpi, L1_pi, L3_lpj, L1_pj,
			   int);
      }
    }
    TRACE_POP ("C_ubim_warp_fast");
    return 0;
  }
}

/*
 * FUNCTION ubim-warp-quad
 */
extern_c char
C_ubim_warp_quad (struct idx *L1_in, struct idx *L1_out, int L1_background,
		  int L1_mode, flt L1_x1, flt L1_y1, flt L1_x2, flt L1_y2,
		  flt L1_x3, flt L1_y3, flt L1_x4, flt L1_y4, flt L1_p1,
		  flt L1_q1, flt L1_p3, flt L1_q3)
{
  TRACE_PUSH ("C_ubim_warp_quad");
  {
    {
      real L2_0_outi;
      real L2_1_outj;
      Midx_declare (L2_2_0_matrix, 2);
      Msrg_declare (L2_3_0_srg);
      struct idx *L2_4_dispi;
      Midx_declare (L2_5_1_matrix, 2);
      Msrg_declare (L2_6_1_srg);
      struct idx *L2_7_dispj;
      Midx_init (L2_2_0_matrix, 2);
      Msrg_init (L2_3_0_srg, ST_I32);
      Midx_init (L2_5_1_matrix, 2);
      Msrg_init (L2_6_1_srg, ST_I32);
      L2_0_outi = (L1_out)->dim[0];
      L2_1_outj = (L1_out)->dim[1];
      (L2_2_0_matrix)->srg = L2_3_0_srg;
      Midx_init_dim2 (L2_2_0_matrix, L2_0_outi, L2_1_outj);
      RTERR_DIM (L2_2_0_matrix->dim[0] <= 0);
      RTERR_DIM (L2_2_0_matrix->dim[1] <= 0);
      L2_4_dispi = L2_2_0_matrix;
      (L2_5_1_matrix)->srg = L2_6_1_srg;
      Midx_init_dim2 (L2_5_1_matrix, L2_0_outi, L2_1_outj);
      RTERR_DIM (L2_5_1_matrix->dim[0] <= 0);
      RTERR_DIM (L2_5_1_matrix->dim[1] <= 0);
      L2_7_dispj = L2_5_1_matrix;
      C_compute_bilin_transform (L2_4_dispi, L2_7_dispj, L1_x1, L1_y1, L1_x2,
				 L1_y2, L1_x3, L1_y3, L1_x4, L1_y4, L1_p1,
				 L1_q1, L1_p3, L1_q3);
      if ((0 == L1_mode))
	{
	  C_ubim_warp_fast (L1_in, L1_out, L1_background, L2_4_dispi,
			    L2_7_dispj);
	}
      else
	{
	  C_ubim_warp (L1_in, L1_out, L1_background, L2_4_dispi, L2_7_dispj);
	}
      Msrg_free (L2_3_0_srg);
      Msrg_free (L2_6_1_srg);
    }
    TRACE_POP ("C_ubim_warp_quad");
    return 0;
  }
}

/*
 * FUNCTION ubim-resize
 */
extern_c struct idx *
C_ubim_resize (struct idx *L1_im, real L1_w, real L1_h, real L1_mode,
	       struct idx *L3_4_matrix, struct srg *L3_4_srg)
{
  TRACE_PUSH ("C_ubim_resize");
  {
    struct idx *L_Tmp0;
    Midx_declare (L2_1_0_ubim_subsample, 2);
    Msrg_declare (L2_2_1_ubim_subsample);
    Midx_declare (L2_3_2_ubim_subsample, 2);
    Msrg_declare (L2_4_3_ubim_subsample);
    Midx_init (L2_1_0_ubim_subsample, 2);
    Msrg_init (L2_2_1_ubim_subsample, ST_U8);
    Midx_init (L2_3_2_ubim_subsample, 2);
    Msrg_init (L2_4_3_ubim_subsample, ST_U8);
    {
      real L2_5_imw;
      real L2_6_imh;
      int L2_7_rw;
      int L2_8_rh;
      char L_Tmp9;
      char L_Tmp29;
      L2_5_imw = (L1_im)->dim[1];
      L2_6_imh = (L1_im)->dim[0];
      L2_7_rw = 0;
      L2_8_rh = 0;
      if ((0 == L1_w))
	{
	  L_Tmp9 = 1;
	}
      else
	{
	  if ((0 == L1_h))
	    {
	      L_Tmp9 = 1;
	    }
	  else
	    {
	      L_Tmp9 = 0;
	    }
	}
      if (L_Tmp9)
	{
	  if ((0 == L1_w))
	    {
	      if ((0 == L1_h))
		{
		  run_time_error
		    ("desired width and height cannot be both zero");
		}
	      else
		{
		  {
		    real L3_10_a;
		    real L3_11_b;
		    L3_10_a = 1;
		    L3_11_b = (L2_5_imw * (L1_h / (real) L2_6_imh));
		    L3_11_b = ((int) floor ((double) L3_11_b));
		    if ((L3_10_a > L3_11_b))
		      {
			L1_w = L3_10_a;
		      }
		    else
		      {
			L1_w = L3_11_b;
		      }
		  }
		}
	    }
	  else
	    {
	      {
		real L3_12_a;
		real L3_13_b;
		L3_12_a = 1;
		L3_13_b = (L2_6_imh * (L1_w / (real) L2_5_imw));
		L3_13_b = ((int) floor ((double) L3_13_b));
		if ((L3_12_a > L3_13_b))
		  {
		    L1_h = L3_12_a;
		  }
		else
		  {
		    L1_h = L3_13_b;
		  }
	      }
	    }
	}
      else
	{
	  if ((L1_mode == 0))
	    {
	      {
		real L3_14_r;
		{
		  real L4_15_a;
		  real L4_16_b;
		  L4_15_a = (L1_w / (real) L2_5_imw);
		  L4_16_b = (L1_h / (real) L2_6_imh);
		  if ((L4_15_a < L4_16_b))
		    {
		      L3_14_r = L4_15_a;
		    }
		  else
		    {
		      L3_14_r = L4_16_b;
		    }
		}
		{
		  real L4_17_a;
		  real L4_18_b;
		  L4_17_a = 1;
		  L4_18_b = (L3_14_r * L2_5_imw);
		  L4_18_b = ((int) floor ((double) L4_18_b));
		  if ((L4_17_a > L4_18_b))
		    {
		      L1_w = L4_17_a;
		    }
		  else
		    {
		      L1_w = L4_18_b;
		    }
		}
		{
		  real L4_19_a;
		  real L4_20_b;
		  L4_19_a = 1;
		  L4_20_b = (L3_14_r * L2_6_imh);
		  L4_20_b = ((int) floor ((double) L4_20_b));
		  if ((L4_19_a > L4_20_b))
		    {
		      L1_h = L4_19_a;
		    }
		  else
		    {
		      L1_h = L4_20_b;
		    }
		}
	      }
	    }
	  else
	    {
	      if ((L1_mode == 1))
		{
		  {
		    real L3_21_a;
		    real L3_22_b;
		    L3_21_a = 1;
		    L3_22_b = L1_w;
		    L3_22_b = ((int) floor ((double) L3_22_b));
		    if ((L3_21_a > L3_22_b))
		      {
			L1_w = L3_21_a;
		      }
		    else
		      {
			L1_w = L3_22_b;
		      }
		  }
		  {
		    real L3_23_a;
		    real L3_24_b;
		    L3_23_a = 1;
		    L3_24_b = L1_h;
		    L3_24_b = ((int) floor ((double) L3_24_b));
		    if ((L3_23_a > L3_24_b))
		      {
			L1_h = L3_23_a;
		      }
		    else
		      {
			L1_h = L3_24_b;
		      }
		  }
		}
	      else
		{
		  if ((L1_mode == 2))
		    {
		      {
			real L3_25_a;
			real L3_26_b;
			L3_25_a = 1;
			L3_26_b = (L1_w * L2_5_imw);
			L3_26_b = ((int) floor ((double) L3_26_b));
			if ((L3_25_a > L3_26_b))
			  {
			    L1_w = L3_25_a;
			  }
			else
			  {
			    L1_w = L3_26_b;
			  }
		      }
		      {
			real L3_27_a;
			real L3_28_b;
			L3_27_a = 1;
			L3_28_b = (L1_h * L2_6_imh);
			L3_28_b = ((int) floor ((double) L3_28_b));
			if ((L3_27_a > L3_28_b))
			  {
			    L1_h = L3_27_a;
			  }
			else
			  {
			    L1_h = L3_28_b;
			  }
		      }
		    }
		  else
		    {
		      if (1)
			{
			  run_time_error
			    ("illegal mode or desired dimensions");
			}
		      else
			{
			}
		    }
		}
	    }
	}
      L2_7_rw = (((int) L2_5_imw) / ((int) L1_w));
      L2_8_rh = (((int) L2_6_imh) / ((int) L1_h));
      if ((0 != L2_8_rh))
	{
	  L_Tmp29 = 1;
	}
      else
	{
	  if ((0 != L2_7_rw))
	    {
	      L_Tmp29 = 1;
	    }
	  else
	    {
	      L_Tmp29 = 0;
	    }
	}
      if (L_Tmp29)
	{
	  L1_im =
	    (struct idx *) C_ubim_subsample (L1_im, L2_8_rh, L2_7_rw,
					     L2_1_0_ubim_subsample,
					     L2_2_1_ubim_subsample,
					     L2_3_2_ubim_subsample,
					     L2_4_3_ubim_subsample);
	  L2_5_imw = (L1_im)->dim[1];
	  L2_6_imh = (L1_im)->dim[0];
	}
      {
	struct idx *L3_30_rez;
	int L3_31_bg;
	flt L3_32_x1;
	flt L3_33_y1;
	flt L3_34_x3;
	flt L3_35_y3;
	flt L3_36_p1;
	flt L3_37_q1;
	flt L3_38_p3;
	flt L3_39_q3;
	(L3_4_matrix)->srg = L3_4_srg;
	Midx_init_dim2 (L3_4_matrix, L1_h, L1_w);
	RTERR_DIM (L3_4_matrix->dim[0] <= 0);
	RTERR_DIM (L3_4_matrix->dim[1] <= 0);
	Midx_maclear (L3_4_matrix, unsigned char);
	L3_30_rez = L3_4_matrix;
	L3_31_bg = 0;
	L3_32_x1 = -0.5;
	L3_33_y1 = -0.5;
	L3_34_x3 = (L2_5_imw - 0.5);
	L3_35_y3 = (L2_6_imh - 0.5);
	L3_36_p1 = -0.5;
	L3_37_q1 = -0.5;
	L3_38_p3 = (L1_w - 0.5);
	L3_39_q3 = (L1_h - 0.5);
	C_ubim_warp_quad (L1_im, L3_30_rez, L3_31_bg, 1, L3_32_x1, L3_33_y1,
			  L3_34_x3, L3_33_y1, L3_34_x3, L3_35_y3, L3_32_x1,
			  L3_35_y3, L3_36_p1, L3_37_q1, L3_38_p3, L3_39_q3);
	L_Tmp0 = L3_30_rez;
      }
    }
    Msrg_free (L2_2_1_ubim_subsample);
    Msrg_free (L2_4_3_ubim_subsample);
    TRACE_POP ("C_ubim_resize");
    return L_Tmp0;
  }
}

/* ---------------------------------------- */

#ifndef NOLISP

/* Declarations */
extern_c dhdoc_t K_compute_bilin_transform_Ra317d0cb;

/*
 * STUB ubimage2flt
 */
DH (X_ubimage2flt)
{
  dharg ret;
  ret.dh_char = C_ubimage2flt (a[1].dh_idx_ptr, a[2].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC ubimage2flt
 */
DHDOC (K_ubimage2flt_R6449a333, X_ubimage2flt, "C_ubimage2flt", 0, 0) =
{
DH_FUNC (2),
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ), DH_FLT, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB flt2ubimage
 */
DH (X_flt2ubimage)
{
  dharg ret;
  ret.dh_char = C_flt2ubimage (a[1].dh_idx_ptr, a[2].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC flt2ubimage
 */
DHDOC (K_flt2ubimage_R56cbf2a0, X_flt2ubimage, "C_flt2ubimage", 0, 0) =
{
DH_FUNC (2),
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_FLT,
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ), DH_UBYTE, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB ubimage2fltimage
 */
DH (X_ubimage2fltimage)
{
  dharg ret;
  ret.dh_char =
    C_ubimage2fltimage (a[1].dh_idx_ptr, a[2].dh_idx_ptr, a[3].dh_flt,
			a[4].dh_flt);
  return ret;
}

/*
 * DHDOC ubimage2fltimage
 */
DHDOC (K_ubimage2fltimage_R446cb9d6, X_ubimage2fltimage, "C_ubimage2fltimage",
       0, 0) =
{
DH_FUNC (4),
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_FLT, DH_FLT, DH_FLT, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB fltimage2ubimage
 */
DH (X_fltimage2ubimage)
{
  dharg ret;
  ret.dh_char =
    C_fltimage2ubimage (a[1].dh_idx_ptr, a[2].dh_idx_ptr, a[3].dh_flt,
			a[4].dh_flt);
  return ret;
}

/*
 * DHDOC fltimage2ubimage
 */
DHDOC (K_fltimage2ubimage_R8e65ff9a, X_fltimage2ubimage, "C_fltimage2ubimage",
       0, 0) =
{
DH_FUNC (4),
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_FLT,
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_UBYTE, DH_FLT, DH_FLT, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB ubim-subsample
 */
DH (X_ubim_subsample)
{
  dharg ret;
  ret.dh_idx_ptr =
    C_ubim_subsample (a[1].dh_idx_ptr, a[2].dh_int, a[3].dh_int,
		      a[4].dh_idx_ptr, a[5].dh_srg_ptr, a[6].dh_idx_ptr,
		      a[7].dh_srg_ptr);
  return ret;
}

/*
 * DHDOC ubim-subsample
 */
DHDOC (K_ubim_subsample_R937b2d86, X_ubim_subsample, "C_ubim_subsample", 0,
       0) =
{
DH_FUNC (3),
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_INT,
    DH_INT,
    DH_TEMPS (4),
    DH_IDX (DHT_WRITE, 2), DH_UBYTE,
    DH_SRG (DHT_WRITE), DH_UBYTE,
    DH_IDX (DHT_WRITE, 2), DH_UBYTE,
    DH_SRG (DHT_WRITE), DH_UBYTE,
    DH_END_TEMPS,
    DH_RETURN,
    DH_IDX (DHT_READ, 2), DH_SRG (DHT_WRITE), DH_UBYTE, DH_END_FUNC, DH_NIL};

/*
 * STUB ubim-invert
 */
DH (X_ubim_invert)
{
  dharg ret;
  ret.dh_char = C_ubim_invert (a[1].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC ubim-invert
 */
DHDOC (K_ubim_invert_Re39841e4, X_ubim_invert, "C_ubim_invert", 0, 0) =
{
DH_FUNC (1),
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ), DH_UBYTE, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB ubim-zoom
 */
DH (X_ubim_zoom)
{
  dharg ret;
  ret.dh_idx_ptr =
    C_ubim_zoom (a[1].dh_idx_ptr, a[2].dh_int, a[3].dh_int, a[4].dh_idx_ptr,
		 a[5].dh_srg_ptr);
  return ret;
}

/*
 * DHDOC ubim-zoom
 */
DHDOC (K_ubim_zoom_R5ef1e386, X_ubim_zoom, "C_ubim_zoom", 0, 0) =
{
DH_FUNC (3),
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_INT,
    DH_INT,
    DH_TEMPS (2),
    DH_IDX (DHT_WRITE, 2), DH_UBYTE,
    DH_SRG (DHT_WRITE), DH_UBYTE,
    DH_END_TEMPS,
    DH_RETURN,
    DH_IDX (DHT_READ, 2), DH_SRG (DHT_READ), DH_UBYTE, DH_END_FUNC, DH_NIL};

/*
 * STUB ubim-interpolate-bilin
 */
DH (X_ubim_interpolate_bilin)
{
  dharg ret;
  ret.dh_uchar =
    C_ubim_interpolate_bilin (a[1].dh_int, (unsigned char *) a[2].dh_gptr,
			      a[3].dh_int, a[4].dh_int, a[5].dh_int,
			      a[6].dh_int, a[7].dh_int, a[8].dh_int);
  return ret;
}

/*
 * DHDOC ubim-interpolate-bilin
 */
DHDOC (K_ubim_interpolate_bilin_R35341536, X_ubim_interpolate_bilin,
       "C_ubim_interpolate_bilin", 0, 0) =
{
DH_FUNC (8),
    DH_INT,
    DH_GPTR ("unsigned char *"),
    DH_INT,
    DH_INT,
    DH_INT, DH_INT, DH_INT, DH_INT, DH_RETURN, DH_UBYTE, DH_END_FUNC, DH_NIL};

/*
 * STUB ubim-warp
 */
DH (X_ubim_warp)
{
  dharg ret;
  ret.dh_char =
    C_ubim_warp (a[1].dh_idx_ptr, a[2].dh_idx_ptr, a[3].dh_int,
		 a[4].dh_idx_ptr, a[5].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC ubim-warp
 */
DHDOC (K_ubim_warp_Rb11176b2, X_ubim_warp, "C_ubim_warp", 0, 0) =
{
DH_FUNC (5),
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_INT,
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_INT,
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ), DH_INT, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB ubim-warp-fast
 */
DH (X_ubim_warp_fast)
{
  dharg ret;
  ret.dh_char =
    C_ubim_warp_fast (a[1].dh_idx_ptr, a[2].dh_idx_ptr, a[3].dh_int,
		      a[4].dh_idx_ptr, a[5].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC ubim-warp-fast
 */
DHDOC (K_ubim_warp_fast_Rb11176b2, X_ubim_warp_fast, "C_ubim_warp_fast", 0,
       0) =
{
DH_FUNC (5),
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_INT,
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_INT,
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ), DH_INT, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB ubim-warp-quad
 */
DH (X_ubim_warp_quad)
{
  dharg ret;
  ret.dh_char =
    C_ubim_warp_quad (a[1].dh_idx_ptr, a[2].dh_idx_ptr, a[3].dh_int,
		      a[4].dh_int, a[5].dh_flt, a[6].dh_flt, a[7].dh_flt,
		      a[8].dh_flt, a[9].dh_flt, a[10].dh_flt, a[11].dh_flt,
		      a[12].dh_flt, a[13].dh_flt, a[14].dh_flt, a[15].dh_flt,
		      a[16].dh_flt);
  return ret;
}

/*
 * DHDOC ubim-warp-quad
 */
DHDOC (K_ubim_warp_quad_R5aeca172, X_ubim_warp_quad, "C_ubim_warp_quad", 0,
       0) =
{
DH_FUNC (16),
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_INT,
    DH_INT,
    DH_FLT,
    DH_FLT,
    DH_FLT,
    DH_FLT,
    DH_FLT,
    DH_FLT,
    DH_FLT,
    DH_FLT,
    DH_FLT,
    DH_FLT,
    DH_FLT,
    DH_FLT,
    DH_RETURN,
    DH_NIL,
    DH_END_FUNC, DH_REFER (K_compute_bilin_transform_Ra317d0cb), DH_NIL};

/*
 * STUB ubim-resize
 */
DH (X_ubim_resize)
{
  dharg ret;
  ret.dh_idx_ptr =
    C_ubim_resize (a[1].dh_idx_ptr, a[2].dh_real, a[3].dh_real, a[4].dh_real,
		   a[5].dh_idx_ptr, a[6].dh_srg_ptr);
  return ret;
}

/*
 * DHDOC ubim-resize
 */
DHDOC (K_ubim_resize_R93f5bbce, X_ubim_resize, "C_ubim_resize", 0, 0) =
{
DH_FUNC (4),
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_WRITE),
    DH_UBYTE,
    DH_REAL,
    DH_REAL,
    DH_REAL,
    DH_TEMPS (2),
    DH_IDX (DHT_WRITE, 2), DH_UBYTE,
    DH_SRG (DHT_WRITE), DH_UBYTE,
    DH_END_TEMPS,
    DH_RETURN,
    DH_IDX (DHT_READ, 2), DH_SRG (DHT_READ), DH_UBYTE, DH_END_FUNC, DH_NIL};

/*
 * INIT FUNCTION
 */
extern_c void
init_ubimage (void)
{
  dh_define ("ubimage2flt", &K_ubimage2flt_R6449a333);
  dh_define ("flt2ubimage", &K_flt2ubimage_R56cbf2a0);
  dh_define ("ubimage2fltimage", &K_ubimage2fltimage_R446cb9d6);
  dh_define ("fltimage2ubimage", &K_fltimage2ubimage_R8e65ff9a);
  dh_define ("ubim-subsample", &K_ubim_subsample_R937b2d86);
  dh_define ("ubim-invert", &K_ubim_invert_Re39841e4);
  dh_define ("ubim-zoom", &K_ubim_zoom_R5ef1e386);
  dh_define ("ubim-interpolate-bilin", &K_ubim_interpolate_bilin_R35341536);
  dh_define ("ubim-warp", &K_ubim_warp_Rb11176b2);
  dh_define ("ubim-warp-fast", &K_ubim_warp_fast_Rb11176b2);
  dh_define ("ubim-warp-quad", &K_ubim_warp_quad_R5aeca172);
  dh_define ("ubim-resize", &K_ubim_resize_R93f5bbce);
}

int majver_ubimage = 40;
int minver_ubimage = 10;

#endif
