/* WARNING: Automatically generated code.
 * This code has been generated by the DH compiler.
 */
#ifdef HAVE_CONFIG_H
# include "lushconf.h"
#endif

/*
 * LUSH HEADERS
 */
#include "header.h"
#include "dh.h"
#include "idxmac.h"
#include "idxops.h"
#include "check_func.h"

/* ---------------------------------------- */

/*
 * FUNCTION error-notcontiguous
 */
extern_c char
C_error_notcontiguous ()
{
  TRACE_PUSH ("C_error_notcontiguous");
  {
    run_time_error ("input or output not contiguous");
    TRACE_POP ("C_error_notcontiguous");
    return 0;
  }
}

/*
 * FUNCTION idx-m1fastconvol-check
 */
extern_c char
C_idx_m1fastconvol_check (int L1_kernel0, int L1_input0, int L1_output0,
			  int L1_size)
{
  TRACE_PUSH ("C_idx_m1fastconvol_check");
  {
    if ((L1_size != L1_kernel0))
      {
	run_time_error ("kernel has wrong size");
      }
    if (((L1_input0 - L1_output0) != ((L1_size) - 1)))
      {
	run_time_error ("inconsistant sizes for convolution");
      }
    TRACE_POP ("C_idx_m1fastconvol_check");
    return 0;
  }
}

/*
 * FUNCTION idx-f1fastconvol2acc
 */
extern_c char
C_idx_f1fastconvol2acc (struct idx *L1_input, struct idx *L1_kernel,
			struct idx *L1_output)
{
  TRACE_PUSH ("C_idx_f1fastconvol2acc");
  {
    char L_Tmp0;
    char L_Tmp1_contigue;
    char L_Tmp2_contigue;
    Midx_contiguep1 (L1_input, L_Tmp1_contigue);
    if (!(L_Tmp1_contigue))
      {
	L_Tmp0 = 1;
      }
    else
      {
	Midx_contiguep1 (L1_output, L_Tmp2_contigue);
	if (!(L_Tmp2_contigue))
	  {
	    L_Tmp0 = 1;
	  }
	else
	  {
	    L_Tmp0 = 0;
	  }
      }
    if (L_Tmp0)
      {
	C_error_notcontiguous ();
      }
    C_idx_m1fastconvol_check ((L1_kernel)->dim[0], (L1_input)->dim[0],
			      (L1_output)->dim[0], 2);
    {
      float *r, *p, *ker;
      register float w0, x0;
      register float w1, x1;
      register int i;
      int kmod, outdim, n, nmodk;
      kmod = (L1_kernel)->mod[0];
      outdim = (L1_output)->dim[0];
      n = outdim / 2;
      nmodk = outdim % 2;
      ker = IDX_PTR ((L1_kernel), float);
      p = IDX_PTR ((L1_input), float);
      r = IDX_PTR ((L1_output), float);
      w0 = *ker;
      ker += kmod;
      w1 = *ker;
      ker += kmod;
      x0 = *p++;
      for (i = 0; i < n; i++)
	{;
	  x1 = *p++;
	  *r++ += w0 * x0 + w1 * x1;
	  x0 = *p++;
	  *r++ += w0 * x1 + w1 * x0;
	}
      if (nmodk-- == 0)
	goto end;
      x1 = *p++;
      *r++ += w0 * x0 + w1 * x1;
    }
  end:;
    TRACE_POP ("C_idx_f1fastconvol2acc");
    return 0;
  }
}

/*
 * FUNCTION idx-d1fastconvol2acc
 */
extern_c char
C_idx_d1fastconvol2acc (struct idx *L1_input, struct idx *L1_kernel,
			struct idx *L1_output)
{
  TRACE_PUSH ("C_idx_d1fastconvol2acc");
  {
    char L_Tmp0;
    char L_Tmp1_contigue;
    char L_Tmp2_contigue;
    Midx_contiguep1 (L1_input, L_Tmp1_contigue);
    if (!(L_Tmp1_contigue))
      {
	L_Tmp0 = 1;
      }
    else
      {
	Midx_contiguep1 (L1_output, L_Tmp2_contigue);
	if (!(L_Tmp2_contigue))
	  {
	    L_Tmp0 = 1;
	  }
	else
	  {
	    L_Tmp0 = 0;
	  }
      }
    if (L_Tmp0)
      {
	C_error_notcontiguous ();
      }
    C_idx_m1fastconvol_check ((L1_kernel)->dim[0], (L1_input)->dim[0],
			      (L1_output)->dim[0], 2);
    {
      double *r, *p, *ker;
      register double w0, x0;
      register double w1, x1;
      register int i;
      int kmod, outdim, n, nmodk;
      kmod = (L1_kernel)->mod[0];
      outdim = (L1_output)->dim[0];
      n = outdim / 2;
      nmodk = outdim % 2;
      ker = IDX_PTR ((L1_kernel), double);
      p = IDX_PTR ((L1_input), double);
      r = IDX_PTR ((L1_output), double);
      w0 = *ker;
      ker += kmod;
      w1 = *ker;
      ker += kmod;
      x0 = *p++;
      for (i = 0; i < n; i++)
	{;
	  x1 = *p++;
	  *r++ += w0 * x0 + w1 * x1;
	  x0 = *p++;
	  *r++ += w0 * x1 + w1 * x0;
	}
      if (nmodk-- == 0)
	goto end;
      x1 = *p++;
      *r++ += w0 * x0 + w1 * x1;
    }
  end:;
    TRACE_POP ("C_idx_d1fastconvol2acc");
    return 0;
  }
}

/*
 * FUNCTION idx-u1fastconvol2acc
 */
extern_c char
C_idx_u1fastconvol2acc (struct idx *L1_input, struct idx *L1_kernel,
			struct idx *L1_output)
{
  TRACE_PUSH ("C_idx_u1fastconvol2acc");
  {
    char L_Tmp0;
    char L_Tmp1_contigue;
    char L_Tmp2_contigue;
    Midx_contiguep1 (L1_input, L_Tmp1_contigue);
    if (!(L_Tmp1_contigue))
      {
	L_Tmp0 = 1;
      }
    else
      {
	Midx_contiguep1 (L1_output, L_Tmp2_contigue);
	if (!(L_Tmp2_contigue))
	  {
	    L_Tmp0 = 1;
	  }
	else
	  {
	    L_Tmp0 = 0;
	  }
      }
    if (L_Tmp0)
      {
	C_error_notcontiguous ();
      }
    C_idx_m1fastconvol_check ((L1_kernel)->dim[0], (L1_input)->dim[0],
			      (L1_output)->dim[0], 2);
    {
      char *r, *p, *ker;
      register char w0, x0;
      register char w1, x1;
      register int i;
      int kmod, outdim, n, nmodk;
      kmod = (L1_kernel)->mod[0];
      outdim = (L1_output)->dim[0];
      n = outdim / 2;
      nmodk = outdim % 2;
      ker = IDX_PTR ((L1_kernel), char);
      p = IDX_PTR ((L1_input), char);
      r = IDX_PTR ((L1_output), char);
      w0 = *ker;
      ker += kmod;
      w1 = *ker;
      ker += kmod;
      x0 = *p++;
      for (i = 0; i < n; i++)
	{;
	  x1 = *p++;
	  *r++ += w0 * x0 + w1 * x1;
	  x0 = *p++;
	  *r++ += w0 * x1 + w1 * x0;
	}
      if (nmodk-- == 0)
	goto end;
      x1 = *p++;
      *r++ += w0 * x0 + w1 * x1;
    }
  end:;
    TRACE_POP ("C_idx_u1fastconvol2acc");
    return 0;
  }
}

/*
 * FUNCTION idx-f1fastconvol3acc
 */
extern_c char
C_idx_f1fastconvol3acc (struct idx *L1_input, struct idx *L1_kernel,
			struct idx *L1_output)
{
  TRACE_PUSH ("C_idx_f1fastconvol3acc");
  {
    char L_Tmp0;
    char L_Tmp1_contigue;
    char L_Tmp2_contigue;
    Midx_contiguep1 (L1_input, L_Tmp1_contigue);
    if (!(L_Tmp1_contigue))
      {
	L_Tmp0 = 1;
      }
    else
      {
	Midx_contiguep1 (L1_output, L_Tmp2_contigue);
	if (!(L_Tmp2_contigue))
	  {
	    L_Tmp0 = 1;
	  }
	else
	  {
	    L_Tmp0 = 0;
	  }
      }
    if (L_Tmp0)
      {
	C_error_notcontiguous ();
      }
    C_idx_m1fastconvol_check ((L1_kernel)->dim[0], (L1_input)->dim[0],
			      (L1_output)->dim[0], 3);
    {
      float *r, *p, *ker;
      register float w0, x0;
      register float w1, x1;
      register float w2, x2;
      register int i;
      int kmod, outdim, n, nmodk;
      kmod = (L1_kernel)->mod[0];
      outdim = (L1_output)->dim[0];
      n = outdim / 3;
      nmodk = outdim % 3;
      ker = IDX_PTR ((L1_kernel), float);
      p = IDX_PTR ((L1_input), float);
      r = IDX_PTR ((L1_output), float);
      w0 = *ker;
      ker += kmod;
      w1 = *ker;
      ker += kmod;
      w2 = *ker;
      ker += kmod;
      x0 = *p++;
      x1 = *p++;
      for (i = 0; i < n; i++)
	{;
	  x2 = *p++;
	  *r++ += w0 * x0 + w1 * x1 + w2 * x2;
	  x0 = *p++;
	  *r++ += w0 * x1 + w1 * x2 + w2 * x0;
	  x1 = *p++;
	  *r++ += w0 * x2 + w1 * x0 + w2 * x1;
	}
      if (nmodk-- == 0)
	goto end;
      x2 = *p++;
      *r++ += w0 * x0 + w1 * x1 + w2 * x2;
      if (nmodk-- == 0)
	goto end;
      x0 = *p++;
      *r++ += w0 * x1 + w1 * x2 + w2 * x0;
    }
  end:;
    TRACE_POP ("C_idx_f1fastconvol3acc");
    return 0;
  }
}

/*
 * FUNCTION idx-d1fastconvol3acc
 */
extern_c char
C_idx_d1fastconvol3acc (struct idx *L1_input, struct idx *L1_kernel,
			struct idx *L1_output)
{
  TRACE_PUSH ("C_idx_d1fastconvol3acc");
  {
    char L_Tmp0;
    char L_Tmp1_contigue;
    char L_Tmp2_contigue;
    Midx_contiguep1 (L1_input, L_Tmp1_contigue);
    if (!(L_Tmp1_contigue))
      {
	L_Tmp0 = 1;
      }
    else
      {
	Midx_contiguep1 (L1_output, L_Tmp2_contigue);
	if (!(L_Tmp2_contigue))
	  {
	    L_Tmp0 = 1;
	  }
	else
	  {
	    L_Tmp0 = 0;
	  }
      }
    if (L_Tmp0)
      {
	C_error_notcontiguous ();
      }
    C_idx_m1fastconvol_check ((L1_kernel)->dim[0], (L1_input)->dim[0],
			      (L1_output)->dim[0], 3);
    {
      double *r, *p, *ker;
      register double w0, x0;
      register double w1, x1;
      register double w2, x2;
      register int i;
      int kmod, outdim, n, nmodk;
      kmod = (L1_kernel)->mod[0];
      outdim = (L1_output)->dim[0];
      n = outdim / 3;
      nmodk = outdim % 3;
      ker = IDX_PTR ((L1_kernel), double);
      p = IDX_PTR ((L1_input), double);
      r = IDX_PTR ((L1_output), double);
      w0 = *ker;
      ker += kmod;
      w1 = *ker;
      ker += kmod;
      w2 = *ker;
      ker += kmod;
      x0 = *p++;
      x1 = *p++;
      for (i = 0; i < n; i++)
	{;
	  x2 = *p++;
	  *r++ += w0 * x0 + w1 * x1 + w2 * x2;
	  x0 = *p++;
	  *r++ += w0 * x1 + w1 * x2 + w2 * x0;
	  x1 = *p++;
	  *r++ += w0 * x2 + w1 * x0 + w2 * x1;
	}
      if (nmodk-- == 0)
	goto end;
      x2 = *p++;
      *r++ += w0 * x0 + w1 * x1 + w2 * x2;
      if (nmodk-- == 0)
	goto end;
      x0 = *p++;
      *r++ += w0 * x1 + w1 * x2 + w2 * x0;
    }
  end:;
    TRACE_POP ("C_idx_d1fastconvol3acc");
    return 0;
  }
}

/*
 * FUNCTION idx-u1fastconvol3acc
 */
extern_c char
C_idx_u1fastconvol3acc (struct idx *L1_input, struct idx *L1_kernel,
			struct idx *L1_output)
{
  TRACE_PUSH ("C_idx_u1fastconvol3acc");
  {
    char L_Tmp0;
    char L_Tmp1_contigue;
    char L_Tmp2_contigue;
    Midx_contiguep1 (L1_input, L_Tmp1_contigue);
    if (!(L_Tmp1_contigue))
      {
	L_Tmp0 = 1;
      }
    else
      {
	Midx_contiguep1 (L1_output, L_Tmp2_contigue);
	if (!(L_Tmp2_contigue))
	  {
	    L_Tmp0 = 1;
	  }
	else
	  {
	    L_Tmp0 = 0;
	  }
      }
    if (L_Tmp0)
      {
	C_error_notcontiguous ();
      }
    C_idx_m1fastconvol_check ((L1_kernel)->dim[0], (L1_input)->dim[0],
			      (L1_output)->dim[0], 3);
    {
      char *r, *p, *ker;
      register char w0, x0;
      register char w1, x1;
      register char w2, x2;
      register int i;
      int kmod, outdim, n, nmodk;
      kmod = (L1_kernel)->mod[0];
      outdim = (L1_output)->dim[0];
      n = outdim / 3;
      nmodk = outdim % 3;
      ker = IDX_PTR ((L1_kernel), char);
      p = IDX_PTR ((L1_input), char);
      r = IDX_PTR ((L1_output), char);
      w0 = *ker;
      ker += kmod;
      w1 = *ker;
      ker += kmod;
      w2 = *ker;
      ker += kmod;
      x0 = *p++;
      x1 = *p++;
      for (i = 0; i < n; i++)
	{;
	  x2 = *p++;
	  *r++ += w0 * x0 + w1 * x1 + w2 * x2;
	  x0 = *p++;
	  *r++ += w0 * x1 + w1 * x2 + w2 * x0;
	  x1 = *p++;
	  *r++ += w0 * x2 + w1 * x0 + w2 * x1;
	}
      if (nmodk-- == 0)
	goto end;
      x2 = *p++;
      *r++ += w0 * x0 + w1 * x1 + w2 * x2;
      if (nmodk-- == 0)
	goto end;
      x0 = *p++;
      *r++ += w0 * x1 + w1 * x2 + w2 * x0;
    }
  end:;
    TRACE_POP ("C_idx_u1fastconvol3acc");
    return 0;
  }
}

/*
 * FUNCTION idx-f1fastconvol4acc
 */
extern_c char
C_idx_f1fastconvol4acc (struct idx *L1_input, struct idx *L1_kernel,
			struct idx *L1_output)
{
  TRACE_PUSH ("C_idx_f1fastconvol4acc");
  {
    char L_Tmp0;
    char L_Tmp1_contigue;
    char L_Tmp2_contigue;
    Midx_contiguep1 (L1_input, L_Tmp1_contigue);
    if (!(L_Tmp1_contigue))
      {
	L_Tmp0 = 1;
      }
    else
      {
	Midx_contiguep1 (L1_output, L_Tmp2_contigue);
	if (!(L_Tmp2_contigue))
	  {
	    L_Tmp0 = 1;
	  }
	else
	  {
	    L_Tmp0 = 0;
	  }
      }
    if (L_Tmp0)
      {
	C_error_notcontiguous ();
      }
    C_idx_m1fastconvol_check ((L1_kernel)->dim[0], (L1_input)->dim[0],
			      (L1_output)->dim[0], 4);
    {
      float *r, *p, *ker;
      register float w0, x0;
      register float w1, x1;
      register float w2, x2;
      register float w3, x3;
      register int i;
      int kmod, outdim, n, nmodk;
      kmod = (L1_kernel)->mod[0];
      outdim = (L1_output)->dim[0];
      n = outdim / 4;
      nmodk = outdim % 4;
      ker = IDX_PTR ((L1_kernel), float);
      p = IDX_PTR ((L1_input), float);
      r = IDX_PTR ((L1_output), float);
      w0 = *ker;
      ker += kmod;
      w1 = *ker;
      ker += kmod;
      w2 = *ker;
      ker += kmod;
      w3 = *ker;
      ker += kmod;
      x0 = *p++;
      x1 = *p++;
      x2 = *p++;
      for (i = 0; i < n; i++)
	{;
	  x3 = *p++;
	  *r++ += w0 * x0 + w1 * x1 + w2 * x2 + w3 * x3;
	  x0 = *p++;
	  *r++ += w0 * x1 + w1 * x2 + w2 * x3 + w3 * x0;
	  x1 = *p++;
	  *r++ += w0 * x2 + w1 * x3 + w2 * x0 + w3 * x1;
	  x2 = *p++;
	  *r++ += w0 * x3 + w1 * x0 + w2 * x1 + w3 * x2;
	}
      if (nmodk-- == 0)
	goto end;
      x3 = *p++;
      *r++ += w0 * x0 + w1 * x1 + w2 * x2 + w3 * x3;
      if (nmodk-- == 0)
	goto end;
      x0 = *p++;
      *r++ += w0 * x1 + w1 * x2 + w2 * x3 + w3 * x0;
      if (nmodk-- == 0)
	goto end;
      x1 = *p++;
      *r++ += w0 * x2 + w1 * x3 + w2 * x0 + w3 * x1;
    }
  end:;
    TRACE_POP ("C_idx_f1fastconvol4acc");
    return 0;
  }
}

/*
 * FUNCTION idx-d1fastconvol4acc
 */
extern_c char
C_idx_d1fastconvol4acc (struct idx *L1_input, struct idx *L1_kernel,
			struct idx *L1_output)
{
  TRACE_PUSH ("C_idx_d1fastconvol4acc");
  {
    char L_Tmp0;
    char L_Tmp1_contigue;
    char L_Tmp2_contigue;
    Midx_contiguep1 (L1_input, L_Tmp1_contigue);
    if (!(L_Tmp1_contigue))
      {
	L_Tmp0 = 1;
      }
    else
      {
	Midx_contiguep1 (L1_output, L_Tmp2_contigue);
	if (!(L_Tmp2_contigue))
	  {
	    L_Tmp0 = 1;
	  }
	else
	  {
	    L_Tmp0 = 0;
	  }
      }
    if (L_Tmp0)
      {
	C_error_notcontiguous ();
      }
    C_idx_m1fastconvol_check ((L1_kernel)->dim[0], (L1_input)->dim[0],
			      (L1_output)->dim[0], 4);
    {
      double *r, *p, *ker;
      register double w0, x0;
      register double w1, x1;
      register double w2, x2;
      register double w3, x3;
      register int i;
      int kmod, outdim, n, nmodk;
      kmod = (L1_kernel)->mod[0];
      outdim = (L1_output)->dim[0];
      n = outdim / 4;
      nmodk = outdim % 4;
      ker = IDX_PTR ((L1_kernel), double);
      p = IDX_PTR ((L1_input), double);
      r = IDX_PTR ((L1_output), double);
      w0 = *ker;
      ker += kmod;
      w1 = *ker;
      ker += kmod;
      w2 = *ker;
      ker += kmod;
      w3 = *ker;
      ker += kmod;
      x0 = *p++;
      x1 = *p++;
      x2 = *p++;
      for (i = 0; i < n; i++)
	{;
	  x3 = *p++;
	  *r++ += w0 * x0 + w1 * x1 + w2 * x2 + w3 * x3;
	  x0 = *p++;
	  *r++ += w0 * x1 + w1 * x2 + w2 * x3 + w3 * x0;
	  x1 = *p++;
	  *r++ += w0 * x2 + w1 * x3 + w2 * x0 + w3 * x1;
	  x2 = *p++;
	  *r++ += w0 * x3 + w1 * x0 + w2 * x1 + w3 * x2;
	}
      if (nmodk-- == 0)
	goto end;
      x3 = *p++;
      *r++ += w0 * x0 + w1 * x1 + w2 * x2 + w3 * x3;
      if (nmodk-- == 0)
	goto end;
      x0 = *p++;
      *r++ += w0 * x1 + w1 * x2 + w2 * x3 + w3 * x0;
      if (nmodk-- == 0)
	goto end;
      x1 = *p++;
      *r++ += w0 * x2 + w1 * x3 + w2 * x0 + w3 * x1;
    }
  end:;
    TRACE_POP ("C_idx_d1fastconvol4acc");
    return 0;
  }
}

/*
 * FUNCTION idx-u1fastconvol4acc
 */
extern_c char
C_idx_u1fastconvol4acc (struct idx *L1_input, struct idx *L1_kernel,
			struct idx *L1_output)
{
  TRACE_PUSH ("C_idx_u1fastconvol4acc");
  {
    char L_Tmp0;
    char L_Tmp1_contigue;
    char L_Tmp2_contigue;
    Midx_contiguep1 (L1_input, L_Tmp1_contigue);
    if (!(L_Tmp1_contigue))
      {
	L_Tmp0 = 1;
      }
    else
      {
	Midx_contiguep1 (L1_output, L_Tmp2_contigue);
	if (!(L_Tmp2_contigue))
	  {
	    L_Tmp0 = 1;
	  }
	else
	  {
	    L_Tmp0 = 0;
	  }
      }
    if (L_Tmp0)
      {
	C_error_notcontiguous ();
      }
    C_idx_m1fastconvol_check ((L1_kernel)->dim[0], (L1_input)->dim[0],
			      (L1_output)->dim[0], 4);
    {
      char *r, *p, *ker;
      register char w0, x0;
      register char w1, x1;
      register char w2, x2;
      register char w3, x3;
      register int i;
      int kmod, outdim, n, nmodk;
      kmod = (L1_kernel)->mod[0];
      outdim = (L1_output)->dim[0];
      n = outdim / 4;
      nmodk = outdim % 4;
      ker = IDX_PTR ((L1_kernel), char);
      p = IDX_PTR ((L1_input), char);
      r = IDX_PTR ((L1_output), char);
      w0 = *ker;
      ker += kmod;
      w1 = *ker;
      ker += kmod;
      w2 = *ker;
      ker += kmod;
      w3 = *ker;
      ker += kmod;
      x0 = *p++;
      x1 = *p++;
      x2 = *p++;
      for (i = 0; i < n; i++)
	{;
	  x3 = *p++;
	  *r++ += w0 * x0 + w1 * x1 + w2 * x2 + w3 * x3;
	  x0 = *p++;
	  *r++ += w0 * x1 + w1 * x2 + w2 * x3 + w3 * x0;
	  x1 = *p++;
	  *r++ += w0 * x2 + w1 * x3 + w2 * x0 + w3 * x1;
	  x2 = *p++;
	  *r++ += w0 * x3 + w1 * x0 + w2 * x1 + w3 * x2;
	}
      if (nmodk-- == 0)
	goto end;
      x3 = *p++;
      *r++ += w0 * x0 + w1 * x1 + w2 * x2 + w3 * x3;
      if (nmodk-- == 0)
	goto end;
      x0 = *p++;
      *r++ += w0 * x1 + w1 * x2 + w2 * x3 + w3 * x0;
      if (nmodk-- == 0)
	goto end;
      x1 = *p++;
      *r++ += w0 * x2 + w1 * x3 + w2 * x0 + w3 * x1;
    }
  end:;
    TRACE_POP ("C_idx_u1fastconvol4acc");
    return 0;
  }
}

/*
 * FUNCTION idx-f1fastconvol5acc
 */
extern_c char
C_idx_f1fastconvol5acc (struct idx *L1_input, struct idx *L1_kernel,
			struct idx *L1_output)
{
  TRACE_PUSH ("C_idx_f1fastconvol5acc");
  {
    char L_Tmp0;
    char L_Tmp1_contigue;
    char L_Tmp2_contigue;
    Midx_contiguep1 (L1_input, L_Tmp1_contigue);
    if (!(L_Tmp1_contigue))
      {
	L_Tmp0 = 1;
      }
    else
      {
	Midx_contiguep1 (L1_output, L_Tmp2_contigue);
	if (!(L_Tmp2_contigue))
	  {
	    L_Tmp0 = 1;
	  }
	else
	  {
	    L_Tmp0 = 0;
	  }
      }
    if (L_Tmp0)
      {
	C_error_notcontiguous ();
      }
    C_idx_m1fastconvol_check ((L1_kernel)->dim[0], (L1_input)->dim[0],
			      (L1_output)->dim[0], 5);
    {
      float *r, *p, *ker;
      register float w0, x0;
      register float w1, x1;
      register float w2, x2;
      register float w3, x3;
      register float w4, x4;
      register int i;
      int kmod, outdim, n, nmodk;
      kmod = (L1_kernel)->mod[0];
      outdim = (L1_output)->dim[0];
      n = outdim / 5;
      nmodk = outdim % 5;
      ker = IDX_PTR ((L1_kernel), float);
      p = IDX_PTR ((L1_input), float);
      r = IDX_PTR ((L1_output), float);
      w0 = *ker;
      ker += kmod;
      w1 = *ker;
      ker += kmod;
      w2 = *ker;
      ker += kmod;
      w3 = *ker;
      ker += kmod;
      w4 = *ker;
      ker += kmod;
      x0 = *p++;
      x1 = *p++;
      x2 = *p++;
      x3 = *p++;
      for (i = 0; i < n; i++)
	{;
	  x4 = *p++;
	  *r++ += w0 * x0 + w1 * x1 + w2 * x2 + w3 * x3 + w4 * x4;
	  x0 = *p++;
	  *r++ += w0 * x1 + w1 * x2 + w2 * x3 + w3 * x4 + w4 * x0;
	  x1 = *p++;
	  *r++ += w0 * x2 + w1 * x3 + w2 * x4 + w3 * x0 + w4 * x1;
	  x2 = *p++;
	  *r++ += w0 * x3 + w1 * x4 + w2 * x0 + w3 * x1 + w4 * x2;
	  x3 = *p++;
	  *r++ += w0 * x4 + w1 * x0 + w2 * x1 + w3 * x2 + w4 * x3;
	}
      if (nmodk-- == 0)
	goto end;
      x4 = *p++;
      *r++ += w0 * x0 + w1 * x1 + w2 * x2 + w3 * x3 + w4 * x4;
      if (nmodk-- == 0)
	goto end;
      x0 = *p++;
      *r++ += w0 * x1 + w1 * x2 + w2 * x3 + w3 * x4 + w4 * x0;
      if (nmodk-- == 0)
	goto end;
      x1 = *p++;
      *r++ += w0 * x2 + w1 * x3 + w2 * x4 + w3 * x0 + w4 * x1;
      if (nmodk-- == 0)
	goto end;
      x2 = *p++;
      *r++ += w0 * x3 + w1 * x4 + w2 * x0 + w3 * x1 + w4 * x2;
    }
  end:;
    TRACE_POP ("C_idx_f1fastconvol5acc");
    return 0;
  }
}

/*
 * FUNCTION idx-d1fastconvol5acc
 */
extern_c char
C_idx_d1fastconvol5acc (struct idx *L1_input, struct idx *L1_kernel,
			struct idx *L1_output)
{
  TRACE_PUSH ("C_idx_d1fastconvol5acc");
  {
    char L_Tmp0;
    char L_Tmp1_contigue;
    char L_Tmp2_contigue;
    Midx_contiguep1 (L1_input, L_Tmp1_contigue);
    if (!(L_Tmp1_contigue))
      {
	L_Tmp0 = 1;
      }
    else
      {
	Midx_contiguep1 (L1_output, L_Tmp2_contigue);
	if (!(L_Tmp2_contigue))
	  {
	    L_Tmp0 = 1;
	  }
	else
	  {
	    L_Tmp0 = 0;
	  }
      }
    if (L_Tmp0)
      {
	C_error_notcontiguous ();
      }
    C_idx_m1fastconvol_check ((L1_kernel)->dim[0], (L1_input)->dim[0],
			      (L1_output)->dim[0], 5);
    {
      double *r, *p, *ker;
      register double w0, x0;
      register double w1, x1;
      register double w2, x2;
      register double w3, x3;
      register double w4, x4;
      register int i;
      int kmod, outdim, n, nmodk;
      kmod = (L1_kernel)->mod[0];
      outdim = (L1_output)->dim[0];
      n = outdim / 5;
      nmodk = outdim % 5;
      ker = IDX_PTR ((L1_kernel), double);
      p = IDX_PTR ((L1_input), double);
      r = IDX_PTR ((L1_output), double);
      w0 = *ker;
      ker += kmod;
      w1 = *ker;
      ker += kmod;
      w2 = *ker;
      ker += kmod;
      w3 = *ker;
      ker += kmod;
      w4 = *ker;
      ker += kmod;
      x0 = *p++;
      x1 = *p++;
      x2 = *p++;
      x3 = *p++;
      for (i = 0; i < n; i++)
	{;
	  x4 = *p++;
	  *r++ += w0 * x0 + w1 * x1 + w2 * x2 + w3 * x3 + w4 * x4;
	  x0 = *p++;
	  *r++ += w0 * x1 + w1 * x2 + w2 * x3 + w3 * x4 + w4 * x0;
	  x1 = *p++;
	  *r++ += w0 * x2 + w1 * x3 + w2 * x4 + w3 * x0 + w4 * x1;
	  x2 = *p++;
	  *r++ += w0 * x3 + w1 * x4 + w2 * x0 + w3 * x1 + w4 * x2;
	  x3 = *p++;
	  *r++ += w0 * x4 + w1 * x0 + w2 * x1 + w3 * x2 + w4 * x3;
	}
      if (nmodk-- == 0)
	goto end;
      x4 = *p++;
      *r++ += w0 * x0 + w1 * x1 + w2 * x2 + w3 * x3 + w4 * x4;
      if (nmodk-- == 0)
	goto end;
      x0 = *p++;
      *r++ += w0 * x1 + w1 * x2 + w2 * x3 + w3 * x4 + w4 * x0;
      if (nmodk-- == 0)
	goto end;
      x1 = *p++;
      *r++ += w0 * x2 + w1 * x3 + w2 * x4 + w3 * x0 + w4 * x1;
      if (nmodk-- == 0)
	goto end;
      x2 = *p++;
      *r++ += w0 * x3 + w1 * x4 + w2 * x0 + w3 * x1 + w4 * x2;
    }
  end:;
    TRACE_POP ("C_idx_d1fastconvol5acc");
    return 0;
  }
}

/*
 * FUNCTION idx-u1fastconvol5acc
 */
extern_c char
C_idx_u1fastconvol5acc (struct idx *L1_input, struct idx *L1_kernel,
			struct idx *L1_output)
{
  TRACE_PUSH ("C_idx_u1fastconvol5acc");
  {
    char L_Tmp0;
    char L_Tmp1_contigue;
    char L_Tmp2_contigue;
    Midx_contiguep1 (L1_input, L_Tmp1_contigue);
    if (!(L_Tmp1_contigue))
      {
	L_Tmp0 = 1;
      }
    else
      {
	Midx_contiguep1 (L1_output, L_Tmp2_contigue);
	if (!(L_Tmp2_contigue))
	  {
	    L_Tmp0 = 1;
	  }
	else
	  {
	    L_Tmp0 = 0;
	  }
      }
    if (L_Tmp0)
      {
	C_error_notcontiguous ();
      }
    C_idx_m1fastconvol_check ((L1_kernel)->dim[0], (L1_input)->dim[0],
			      (L1_output)->dim[0], 5);
    {
      char *r, *p, *ker;
      register char w0, x0;
      register char w1, x1;
      register char w2, x2;
      register char w3, x3;
      register char w4, x4;
      register int i;
      int kmod, outdim, n, nmodk;
      kmod = (L1_kernel)->mod[0];
      outdim = (L1_output)->dim[0];
      n = outdim / 5;
      nmodk = outdim % 5;
      ker = IDX_PTR ((L1_kernel), char);
      p = IDX_PTR ((L1_input), char);
      r = IDX_PTR ((L1_output), char);
      w0 = *ker;
      ker += kmod;
      w1 = *ker;
      ker += kmod;
      w2 = *ker;
      ker += kmod;
      w3 = *ker;
      ker += kmod;
      w4 = *ker;
      ker += kmod;
      x0 = *p++;
      x1 = *p++;
      x2 = *p++;
      x3 = *p++;
      for (i = 0; i < n; i++)
	{;
	  x4 = *p++;
	  *r++ += w0 * x0 + w1 * x1 + w2 * x2 + w3 * x3 + w4 * x4;
	  x0 = *p++;
	  *r++ += w0 * x1 + w1 * x2 + w2 * x3 + w3 * x4 + w4 * x0;
	  x1 = *p++;
	  *r++ += w0 * x2 + w1 * x3 + w2 * x4 + w3 * x0 + w4 * x1;
	  x2 = *p++;
	  *r++ += w0 * x3 + w1 * x4 + w2 * x0 + w3 * x1 + w4 * x2;
	  x3 = *p++;
	  *r++ += w0 * x4 + w1 * x0 + w2 * x1 + w3 * x2 + w4 * x3;
	}
      if (nmodk-- == 0)
	goto end;
      x4 = *p++;
      *r++ += w0 * x0 + w1 * x1 + w2 * x2 + w3 * x3 + w4 * x4;
      if (nmodk-- == 0)
	goto end;
      x0 = *p++;
      *r++ += w0 * x1 + w1 * x2 + w2 * x3 + w3 * x4 + w4 * x0;
      if (nmodk-- == 0)
	goto end;
      x1 = *p++;
      *r++ += w0 * x2 + w1 * x3 + w2 * x4 + w3 * x0 + w4 * x1;
      if (nmodk-- == 0)
	goto end;
      x2 = *p++;
      *r++ += w0 * x3 + w1 * x4 + w2 * x0 + w3 * x1 + w4 * x2;
    }
  end:;
    TRACE_POP ("C_idx_u1fastconvol5acc");
    return 0;
  }
}

/*
 * FUNCTION idx-f1convol
 */
extern_c struct idx *
C_idx_f1convol (struct idx *L1_in, struct idx *L1_kernel, struct idx *L1_out)
{
  TRACE_PUSH ("C_idx_f1convol");
  {
    struct idx *L_Tmp0;
    {
      Midx_declare (L2_1_0_unfold, 2);
      struct idx *L2_2_uin;
      int L_Tmp3;
      int L_Tmp4;
      Midx_init (L2_1_0_unfold, 2);
      L_Tmp3 = (L1_kernel)->dim[0];
      Midx_clone1 (L2_1_0_unfold, L1_in);
      RTERR_GEN ((((int) L_Tmp3) < 1
		  || ((int) 1) < 1), "illegal 'size' or 'step'");
      L_Tmp4 =
	1 + ((L2_1_0_unfold)->dim[((int) 0)] - ((int) L_Tmp3)) / ((int) 1);
      RTERR_GEN ((L_Tmp4 <= 0
		  || (L2_1_0_unfold)->dim[((int) 0)] !=
		  ((int) 1) * (L_Tmp4 - 1) + ((int) L_Tmp3)),
		 "Index dimension does not match size and step");
      Midx_unfold (L2_1_0_unfold, ((int) 0), ((int) L_Tmp3), ((int) 1), flt);
      L2_2_uin = L2_1_0_unfold;
      check_main_main_maout_dot21 (L2_2_uin, L1_kernel, L1_out);
      Midx_m2dotm1 (L2_2_uin, L1_kernel, L1_out, flt, flt, flt);
      L_Tmp0 = L1_out;
    }
    TRACE_POP ("C_idx_f1convol");
    return L_Tmp0;
  }
}

/*
 * FUNCTION idx-d1convol
 */
extern_c struct idx *
C_idx_d1convol (struct idx *L1_in, struct idx *L1_kernel, struct idx *L1_out)
{
  TRACE_PUSH ("C_idx_d1convol");
  {
    struct idx *L_Tmp0;
    {
      Midx_declare (L2_1_0_unfold, 2);
      struct idx *L2_2_uin;
      int L_Tmp3;
      int L_Tmp4;
      Midx_init (L2_1_0_unfold, 2);
      L_Tmp3 = (L1_kernel)->dim[0];
      Midx_clone1 (L2_1_0_unfold, L1_in);
      RTERR_GEN ((((int) L_Tmp3) < 1
		  || ((int) 1) < 1), "illegal 'size' or 'step'");
      L_Tmp4 =
	1 + ((L2_1_0_unfold)->dim[((int) 0)] - ((int) L_Tmp3)) / ((int) 1);
      RTERR_GEN ((L_Tmp4 <= 0
		  || (L2_1_0_unfold)->dim[((int) 0)] !=
		  ((int) 1) * (L_Tmp4 - 1) + ((int) L_Tmp3)),
		 "Index dimension does not match size and step");
      Midx_unfold (L2_1_0_unfold, ((int) 0), ((int) L_Tmp3), ((int) 1), real);
      L2_2_uin = L2_1_0_unfold;
      check_main_main_maout_dot21 (L2_2_uin, L1_kernel, L1_out);
      Midx_m2dotm1 (L2_2_uin, L1_kernel, L1_out, real, real, real);
      L_Tmp0 = L1_out;
    }
    TRACE_POP ("C_idx_d1convol");
    return L_Tmp0;
  }
}

/*
 * FUNCTION idx-u1convol
 */
extern_c struct idx *
C_idx_u1convol (struct idx *L1_in, struct idx *L1_kernel, struct idx *L1_out)
{
  TRACE_PUSH ("C_idx_u1convol");
  {
    struct idx *L_Tmp0;
    {
      Midx_declare (L2_1_0_unfold, 2);
      struct idx *L2_2_uin;
      int L_Tmp3;
      int L_Tmp4;
      Midx_init (L2_1_0_unfold, 2);
      L_Tmp3 = (L1_kernel)->dim[0];
      Midx_clone1 (L2_1_0_unfold, L1_in);
      RTERR_GEN ((((int) L_Tmp3) < 1
		  || ((int) 1) < 1), "illegal 'size' or 'step'");
      L_Tmp4 =
	1 + ((L2_1_0_unfold)->dim[((int) 0)] - ((int) L_Tmp3)) / ((int) 1);
      RTERR_GEN ((L_Tmp4 <= 0
		  || (L2_1_0_unfold)->dim[((int) 0)] !=
		  ((int) 1) * (L_Tmp4 - 1) + ((int) L_Tmp3)),
		 "Index dimension does not match size and step");
      Midx_unfold (L2_1_0_unfold, ((int) 0), ((int) L_Tmp3), ((int) 1),
		   unsigned char);
      L2_2_uin = L2_1_0_unfold;
      check_main_main_maout_dot21 (L2_2_uin, L1_kernel, L1_out);
      Midx_m2dotm1 (L2_2_uin, L1_kernel, L1_out, unsigned char, unsigned char,
		    unsigned char);
      L_Tmp0 = L1_out;
    }
    TRACE_POP ("C_idx_u1convol");
    return L_Tmp0;
  }
}

/*
 * FUNCTION idx-f1backconvol
 */
extern_c struct idx *
C_idx_f1backconvol (struct idx *L1_out, struct idx *L1_kernel,
		    struct idx *L1_in, struct idx *L2_0_unfold)
{
  TRACE_PUSH ("C_idx_f1backconvol");
  {
    struct idx *L_Tmp0;
    Midx_m1clear (L1_in, flt);
    {
      struct idx *L2_1_uin;
      int L_Tmp2;
      int L_Tmp3;
      L_Tmp2 = (L1_kernel)->dim[0];
      Midx_clone1 (L2_0_unfold, L1_in);
      RTERR_GEN ((((int) L_Tmp2) < 1
		  || ((int) 1) < 1), "illegal 'size' or 'step'");
      L_Tmp3 =
	1 + ((L2_0_unfold)->dim[((int) 0)] - ((int) L_Tmp2)) / ((int) 1);
      RTERR_GEN ((L_Tmp3 <= 0
		  || (L2_0_unfold)->dim[((int) 0)] !=
		  ((int) 1) * (L_Tmp3 - 1) + ((int) L_Tmp2)),
		 "Index dimension does not match size and step");
      Midx_unfold (L2_0_unfold, ((int) 0), ((int) L_Tmp2), ((int) 1), flt);
      L2_1_uin = L2_0_unfold;
      check_m1in_m1in_m2out (L1_out, L1_kernel, L2_1_uin);
      Midx_m1extm1acc (L1_out, L1_kernel, L2_1_uin, flt, flt, flt);
      L_Tmp0 = L2_1_uin;
    }
    TRACE_POP ("C_idx_f1backconvol");
    return L_Tmp0;
  }
}

/*
 * FUNCTION idx-d1backconvol
 */
extern_c struct idx *
C_idx_d1backconvol (struct idx *L1_out, struct idx *L1_kernel,
		    struct idx *L1_in, struct idx *L2_0_unfold)
{
  TRACE_PUSH ("C_idx_d1backconvol");
  {
    struct idx *L_Tmp0;
    Midx_m1clear (L1_in, real);
    {
      struct idx *L2_1_uin;
      int L_Tmp2;
      int L_Tmp3;
      L_Tmp2 = (L1_kernel)->dim[0];
      Midx_clone1 (L2_0_unfold, L1_in);
      RTERR_GEN ((((int) L_Tmp2) < 1
		  || ((int) 1) < 1), "illegal 'size' or 'step'");
      L_Tmp3 =
	1 + ((L2_0_unfold)->dim[((int) 0)] - ((int) L_Tmp2)) / ((int) 1);
      RTERR_GEN ((L_Tmp3 <= 0
		  || (L2_0_unfold)->dim[((int) 0)] !=
		  ((int) 1) * (L_Tmp3 - 1) + ((int) L_Tmp2)),
		 "Index dimension does not match size and step");
      Midx_unfold (L2_0_unfold, ((int) 0), ((int) L_Tmp2), ((int) 1), real);
      L2_1_uin = L2_0_unfold;
      check_m1in_m1in_m2out (L1_out, L1_kernel, L2_1_uin);
      Midx_m1extm1acc (L1_out, L1_kernel, L2_1_uin, real, real, real);
      L_Tmp0 = L2_1_uin;
    }
    TRACE_POP ("C_idx_d1backconvol");
    return L_Tmp0;
  }
}

/*
 * FUNCTION idx-u1backconvol
 */
extern_c struct idx *
C_idx_u1backconvol (struct idx *L1_out, struct idx *L1_kernel,
		    struct idx *L1_in, struct idx *L2_0_unfold)
{
  TRACE_PUSH ("C_idx_u1backconvol");
  {
    struct idx *L_Tmp0;
    Midx_m1clear (L1_in, unsigned char);
    {
      struct idx *L2_1_uin;
      int L_Tmp2;
      int L_Tmp3;
      L_Tmp2 = (L1_kernel)->dim[0];
      Midx_clone1 (L2_0_unfold, L1_in);
      RTERR_GEN ((((int) L_Tmp2) < 1
		  || ((int) 1) < 1), "illegal 'size' or 'step'");
      L_Tmp3 =
	1 + ((L2_0_unfold)->dim[((int) 0)] - ((int) L_Tmp2)) / ((int) 1);
      RTERR_GEN ((L_Tmp3 <= 0
		  || (L2_0_unfold)->dim[((int) 0)] !=
		  ((int) 1) * (L_Tmp3 - 1) + ((int) L_Tmp2)),
		 "Index dimension does not match size and step");
      Midx_unfold (L2_0_unfold, ((int) 0), ((int) L_Tmp2), ((int) 1),
		   unsigned char);
      L2_1_uin = L2_0_unfold;
      check_m1in_m1in_m2out (L1_out, L1_kernel, L2_1_uin);
      Midx_m1extm1acc (L1_out, L1_kernel, L2_1_uin, unsigned char,
		       unsigned char, unsigned char);
      L_Tmp0 = L2_1_uin;
    }
    TRACE_POP ("C_idx_u1backconvol");
    return L_Tmp0;
  }
}

/*
 * FUNCTION idx-f2convol
 */
extern_c struct idx *
C_idx_f2convol (struct idx *L1_in, struct idx *L1_kernel, struct idx *L1_out)
{
  TRACE_PUSH ("C_idx_f2convol");
  {
    struct idx *L_Tmp0;
    {
      Midx_declare (L2_1_0_unfold, 3);
      struct idx *L2_2_uin;
      Midx_declare (L2_3_1_unfold, 4);
      struct idx *L2_4_uuin;
      int L_Tmp5;
      int L_Tmp6;
      int L_Tmp7;
      int L_Tmp8;
      Midx_init (L2_1_0_unfold, 3);
      Midx_init (L2_3_1_unfold, 4);
      L_Tmp5 = (L1_kernel)->dim[0];
      Midx_clone2 (L2_1_0_unfold, L1_in);
      RTERR_GEN ((((int) L_Tmp5) < 1
		  || ((int) 1) < 1), "illegal 'size' or 'step'");
      L_Tmp6 =
	1 + ((L2_1_0_unfold)->dim[((int) 0)] - ((int) L_Tmp5)) / ((int) 1);
      RTERR_GEN ((L_Tmp6 <= 0
		  || (L2_1_0_unfold)->dim[((int) 0)] !=
		  ((int) 1) * (L_Tmp6 - 1) + ((int) L_Tmp5)),
		 "Index dimension does not match size and step");
      Midx_unfold (L2_1_0_unfold, ((int) 0), ((int) L_Tmp5), ((int) 1), flt);
      L2_2_uin = L2_1_0_unfold;
      L_Tmp7 = (L1_kernel)->dim[1];
      Midx_clone3 (L2_3_1_unfold, L2_2_uin);
      RTERR_GEN ((((int) L_Tmp7) < 1
		  || ((int) 1) < 1), "illegal 'size' or 'step'");
      L_Tmp8 =
	1 + ((L2_3_1_unfold)->dim[((int) 1)] - ((int) L_Tmp7)) / ((int) 1);
      RTERR_GEN ((L_Tmp8 <= 0
		  || (L2_3_1_unfold)->dim[((int) 1)] !=
		  ((int) 1) * (L_Tmp8 - 1) + ((int) L_Tmp7)),
		 "Index dimension does not match size and step");
      Midx_unfold (L2_3_1_unfold, ((int) 1), ((int) L_Tmp7), ((int) 1), flt);
      L2_4_uuin = L2_3_1_unfold;
      check_main_main_maout_dot42 (L2_4_uuin, L1_kernel, L1_out);
      Midx_m4dotm2 (L2_4_uuin, L1_kernel, L1_out, flt, flt, flt);
      L_Tmp0 = L1_out;
    }
    TRACE_POP ("C_idx_f2convol");
    return L_Tmp0;
  }
}

/*
 * FUNCTION idx-d2convol
 */
extern_c struct idx *
C_idx_d2convol (struct idx *L1_in, struct idx *L1_kernel, struct idx *L1_out)
{
  TRACE_PUSH ("C_idx_d2convol");
  {
    struct idx *L_Tmp0;
    {
      Midx_declare (L2_1_0_unfold, 3);
      struct idx *L2_2_uin;
      Midx_declare (L2_3_1_unfold, 4);
      struct idx *L2_4_uuin;
      int L_Tmp5;
      int L_Tmp6;
      int L_Tmp7;
      int L_Tmp8;
      Midx_init (L2_1_0_unfold, 3);
      Midx_init (L2_3_1_unfold, 4);
      L_Tmp5 = (L1_kernel)->dim[0];
      Midx_clone2 (L2_1_0_unfold, L1_in);
      RTERR_GEN ((((int) L_Tmp5) < 1
		  || ((int) 1) < 1), "illegal 'size' or 'step'");
      L_Tmp6 =
	1 + ((L2_1_0_unfold)->dim[((int) 0)] - ((int) L_Tmp5)) / ((int) 1);
      RTERR_GEN ((L_Tmp6 <= 0
		  || (L2_1_0_unfold)->dim[((int) 0)] !=
		  ((int) 1) * (L_Tmp6 - 1) + ((int) L_Tmp5)),
		 "Index dimension does not match size and step");
      Midx_unfold (L2_1_0_unfold, ((int) 0), ((int) L_Tmp5), ((int) 1), real);
      L2_2_uin = L2_1_0_unfold;
      L_Tmp7 = (L1_kernel)->dim[1];
      Midx_clone3 (L2_3_1_unfold, L2_2_uin);
      RTERR_GEN ((((int) L_Tmp7) < 1
		  || ((int) 1) < 1), "illegal 'size' or 'step'");
      L_Tmp8 =
	1 + ((L2_3_1_unfold)->dim[((int) 1)] - ((int) L_Tmp7)) / ((int) 1);
      RTERR_GEN ((L_Tmp8 <= 0
		  || (L2_3_1_unfold)->dim[((int) 1)] !=
		  ((int) 1) * (L_Tmp8 - 1) + ((int) L_Tmp7)),
		 "Index dimension does not match size and step");
      Midx_unfold (L2_3_1_unfold, ((int) 1), ((int) L_Tmp7), ((int) 1), real);
      L2_4_uuin = L2_3_1_unfold;
      check_main_main_maout_dot42 (L2_4_uuin, L1_kernel, L1_out);
      Midx_m4dotm2 (L2_4_uuin, L1_kernel, L1_out, real, real, real);
      L_Tmp0 = L1_out;
    }
    TRACE_POP ("C_idx_d2convol");
    return L_Tmp0;
  }
}

/*
 * FUNCTION idx-u2convol
 */
extern_c struct idx *
C_idx_u2convol (struct idx *L1_in, struct idx *L1_kernel, struct idx *L1_out)
{
  TRACE_PUSH ("C_idx_u2convol");
  {
    struct idx *L_Tmp0;
    {
      Midx_declare (L2_1_0_unfold, 3);
      struct idx *L2_2_uin;
      Midx_declare (L2_3_1_unfold, 4);
      struct idx *L2_4_uuin;
      int L_Tmp5;
      int L_Tmp6;
      int L_Tmp7;
      int L_Tmp8;
      Midx_init (L2_1_0_unfold, 3);
      Midx_init (L2_3_1_unfold, 4);
      L_Tmp5 = (L1_kernel)->dim[0];
      Midx_clone2 (L2_1_0_unfold, L1_in);
      RTERR_GEN ((((int) L_Tmp5) < 1
		  || ((int) 1) < 1), "illegal 'size' or 'step'");
      L_Tmp6 =
	1 + ((L2_1_0_unfold)->dim[((int) 0)] - ((int) L_Tmp5)) / ((int) 1);
      RTERR_GEN ((L_Tmp6 <= 0
		  || (L2_1_0_unfold)->dim[((int) 0)] !=
		  ((int) 1) * (L_Tmp6 - 1) + ((int) L_Tmp5)),
		 "Index dimension does not match size and step");
      Midx_unfold (L2_1_0_unfold, ((int) 0), ((int) L_Tmp5), ((int) 1),
		   unsigned char);
      L2_2_uin = L2_1_0_unfold;
      L_Tmp7 = (L1_kernel)->dim[1];
      Midx_clone3 (L2_3_1_unfold, L2_2_uin);
      RTERR_GEN ((((int) L_Tmp7) < 1
		  || ((int) 1) < 1), "illegal 'size' or 'step'");
      L_Tmp8 =
	1 + ((L2_3_1_unfold)->dim[((int) 1)] - ((int) L_Tmp7)) / ((int) 1);
      RTERR_GEN ((L_Tmp8 <= 0
		  || (L2_3_1_unfold)->dim[((int) 1)] !=
		  ((int) 1) * (L_Tmp8 - 1) + ((int) L_Tmp7)),
		 "Index dimension does not match size and step");
      Midx_unfold (L2_3_1_unfold, ((int) 1), ((int) L_Tmp7), ((int) 1),
		   unsigned char);
      L2_4_uuin = L2_3_1_unfold;
      check_main_main_maout_dot42 (L2_4_uuin, L1_kernel, L1_out);
      Midx_m4dotm2 (L2_4_uuin, L1_kernel, L1_out, unsigned char,
		    unsigned char, unsigned char);
      L_Tmp0 = L1_out;
    }
    TRACE_POP ("C_idx_u2convol");
    return L_Tmp0;
  }
}

/*
 * FUNCTION idx-f2convolacc
 */
extern_c struct idx *
C_idx_f2convolacc (struct idx *L1_in, struct idx *L1_kernel,
		   struct idx *L1_out)
{
  TRACE_PUSH ("C_idx_f2convolacc");
  {
    struct idx *L_Tmp0;
    {
      Midx_declare (L2_1_0_unfold, 3);
      struct idx *L2_2_uin;
      Midx_declare (L2_3_1_unfold, 4);
      struct idx *L2_4_uuin;
      int L_Tmp5;
      int L_Tmp6;
      int L_Tmp7;
      int L_Tmp8;
      Midx_init (L2_1_0_unfold, 3);
      Midx_init (L2_3_1_unfold, 4);
      L_Tmp5 = (L1_kernel)->dim[0];
      Midx_clone2 (L2_1_0_unfold, L1_in);
      RTERR_GEN ((((int) L_Tmp5) < 1
		  || ((int) 1) < 1), "illegal 'size' or 'step'");
      L_Tmp6 =
	1 + ((L2_1_0_unfold)->dim[((int) 0)] - ((int) L_Tmp5)) / ((int) 1);
      RTERR_GEN ((L_Tmp6 <= 0
		  || (L2_1_0_unfold)->dim[((int) 0)] !=
		  ((int) 1) * (L_Tmp6 - 1) + ((int) L_Tmp5)),
		 "Index dimension does not match size and step");
      Midx_unfold (L2_1_0_unfold, ((int) 0), ((int) L_Tmp5), ((int) 1), flt);
      L2_2_uin = L2_1_0_unfold;
      L_Tmp7 = (L1_kernel)->dim[1];
      Midx_clone3 (L2_3_1_unfold, L2_2_uin);
      RTERR_GEN ((((int) L_Tmp7) < 1
		  || ((int) 1) < 1), "illegal 'size' or 'step'");
      L_Tmp8 =
	1 + ((L2_3_1_unfold)->dim[((int) 1)] - ((int) L_Tmp7)) / ((int) 1);
      RTERR_GEN ((L_Tmp8 <= 0
		  || (L2_3_1_unfold)->dim[((int) 1)] !=
		  ((int) 1) * (L_Tmp8 - 1) + ((int) L_Tmp7)),
		 "Index dimension does not match size and step");
      Midx_unfold (L2_3_1_unfold, ((int) 1), ((int) L_Tmp7), ((int) 1), flt);
      L2_4_uuin = L2_3_1_unfold;
      check_main_main_maout_dot42 (L2_4_uuin, L1_kernel, L1_out);
      Midx_m4dotm2acc (L2_4_uuin, L1_kernel, L1_out, flt, flt, flt);
      L_Tmp0 = L1_out;
    }
    TRACE_POP ("C_idx_f2convolacc");
    return L_Tmp0;
  }
}

/*
 * FUNCTION idx-d2convolacc
 */
extern_c struct idx *
C_idx_d2convolacc (struct idx *L1_in, struct idx *L1_kernel,
		   struct idx *L1_out)
{
  TRACE_PUSH ("C_idx_d2convolacc");
  {
    struct idx *L_Tmp0;
    {
      Midx_declare (L2_1_0_unfold, 3);
      struct idx *L2_2_uin;
      Midx_declare (L2_3_1_unfold, 4);
      struct idx *L2_4_uuin;
      int L_Tmp5;
      int L_Tmp6;
      int L_Tmp7;
      int L_Tmp8;
      Midx_init (L2_1_0_unfold, 3);
      Midx_init (L2_3_1_unfold, 4);
      L_Tmp5 = (L1_kernel)->dim[0];
      Midx_clone2 (L2_1_0_unfold, L1_in);
      RTERR_GEN ((((int) L_Tmp5) < 1
		  || ((int) 1) < 1), "illegal 'size' or 'step'");
      L_Tmp6 =
	1 + ((L2_1_0_unfold)->dim[((int) 0)] - ((int) L_Tmp5)) / ((int) 1);
      RTERR_GEN ((L_Tmp6 <= 0
		  || (L2_1_0_unfold)->dim[((int) 0)] !=
		  ((int) 1) * (L_Tmp6 - 1) + ((int) L_Tmp5)),
		 "Index dimension does not match size and step");
      Midx_unfold (L2_1_0_unfold, ((int) 0), ((int) L_Tmp5), ((int) 1), real);
      L2_2_uin = L2_1_0_unfold;
      L_Tmp7 = (L1_kernel)->dim[1];
      Midx_clone3 (L2_3_1_unfold, L2_2_uin);
      RTERR_GEN ((((int) L_Tmp7) < 1
		  || ((int) 1) < 1), "illegal 'size' or 'step'");
      L_Tmp8 =
	1 + ((L2_3_1_unfold)->dim[((int) 1)] - ((int) L_Tmp7)) / ((int) 1);
      RTERR_GEN ((L_Tmp8 <= 0
		  || (L2_3_1_unfold)->dim[((int) 1)] !=
		  ((int) 1) * (L_Tmp8 - 1) + ((int) L_Tmp7)),
		 "Index dimension does not match size and step");
      Midx_unfold (L2_3_1_unfold, ((int) 1), ((int) L_Tmp7), ((int) 1), real);
      L2_4_uuin = L2_3_1_unfold;
      check_main_main_maout_dot42 (L2_4_uuin, L1_kernel, L1_out);
      Midx_m4dotm2acc (L2_4_uuin, L1_kernel, L1_out, real, real, real);
      L_Tmp0 = L1_out;
    }
    TRACE_POP ("C_idx_d2convolacc");
    return L_Tmp0;
  }
}

/*
 * FUNCTION idx-u2convolacc
 */
extern_c struct idx *
C_idx_u2convolacc (struct idx *L1_in, struct idx *L1_kernel,
		   struct idx *L1_out)
{
  TRACE_PUSH ("C_idx_u2convolacc");
  {
    struct idx *L_Tmp0;
    {
      Midx_declare (L2_1_0_unfold, 3);
      struct idx *L2_2_uin;
      Midx_declare (L2_3_1_unfold, 4);
      struct idx *L2_4_uuin;
      int L_Tmp5;
      int L_Tmp6;
      int L_Tmp7;
      int L_Tmp8;
      Midx_init (L2_1_0_unfold, 3);
      Midx_init (L2_3_1_unfold, 4);
      L_Tmp5 = (L1_kernel)->dim[0];
      Midx_clone2 (L2_1_0_unfold, L1_in);
      RTERR_GEN ((((int) L_Tmp5) < 1
		  || ((int) 1) < 1), "illegal 'size' or 'step'");
      L_Tmp6 =
	1 + ((L2_1_0_unfold)->dim[((int) 0)] - ((int) L_Tmp5)) / ((int) 1);
      RTERR_GEN ((L_Tmp6 <= 0
		  || (L2_1_0_unfold)->dim[((int) 0)] !=
		  ((int) 1) * (L_Tmp6 - 1) + ((int) L_Tmp5)),
		 "Index dimension does not match size and step");
      Midx_unfold (L2_1_0_unfold, ((int) 0), ((int) L_Tmp5), ((int) 1),
		   unsigned char);
      L2_2_uin = L2_1_0_unfold;
      L_Tmp7 = (L1_kernel)->dim[1];
      Midx_clone3 (L2_3_1_unfold, L2_2_uin);
      RTERR_GEN ((((int) L_Tmp7) < 1
		  || ((int) 1) < 1), "illegal 'size' or 'step'");
      L_Tmp8 =
	1 + ((L2_3_1_unfold)->dim[((int) 1)] - ((int) L_Tmp7)) / ((int) 1);
      RTERR_GEN ((L_Tmp8 <= 0
		  || (L2_3_1_unfold)->dim[((int) 1)] !=
		  ((int) 1) * (L_Tmp8 - 1) + ((int) L_Tmp7)),
		 "Index dimension does not match size and step");
      Midx_unfold (L2_3_1_unfold, ((int) 1), ((int) L_Tmp7), ((int) 1),
		   unsigned char);
      L2_4_uuin = L2_3_1_unfold;
      check_main_main_maout_dot42 (L2_4_uuin, L1_kernel, L1_out);
      Midx_m4dotm2acc (L2_4_uuin, L1_kernel, L1_out, unsigned char,
		       unsigned char, unsigned char);
      L_Tmp0 = L1_out;
    }
    TRACE_POP ("C_idx_u2convolacc");
    return L_Tmp0;
  }
}

/*
 * FUNCTION idx-f2backconvol
 */
extern_c struct idx *
C_idx_f2backconvol (struct idx *L1_out, struct idx *L1_kernel,
		    struct idx *L1_in, struct idx *L2_1_unfold)
{
  TRACE_PUSH ("C_idx_f2backconvol");
  {
    struct idx *L_Tmp0;
    Midx_m2clear (L1_in, flt);
    {
      Midx_declare (L2_1_0_unfold, 3);
      struct idx *L2_2_uin;
      struct idx *L2_3_uuin;
      int L_Tmp4;
      int L_Tmp5;
      int L_Tmp6;
      int L_Tmp7;
      Midx_init (L2_1_0_unfold, 3);
      L_Tmp4 = (L1_kernel)->dim[0];
      Midx_clone2 (L2_1_0_unfold, L1_in);
      RTERR_GEN ((((int) L_Tmp4) < 1
		  || ((int) 1) < 1), "illegal 'size' or 'step'");
      L_Tmp5 =
	1 + ((L2_1_0_unfold)->dim[((int) 0)] - ((int) L_Tmp4)) / ((int) 1);
      RTERR_GEN ((L_Tmp5 <= 0
		  || (L2_1_0_unfold)->dim[((int) 0)] !=
		  ((int) 1) * (L_Tmp5 - 1) + ((int) L_Tmp4)),
		 "Index dimension does not match size and step");
      Midx_unfold (L2_1_0_unfold, ((int) 0), ((int) L_Tmp4), ((int) 1), flt);
      L2_2_uin = L2_1_0_unfold;
      L_Tmp6 = (L1_kernel)->dim[1];
      Midx_clone3 (L2_1_unfold, L2_2_uin);
      RTERR_GEN ((((int) L_Tmp6) < 1
		  || ((int) 1) < 1), "illegal 'size' or 'step'");
      L_Tmp7 =
	1 + ((L2_1_unfold)->dim[((int) 1)] - ((int) L_Tmp6)) / ((int) 1);
      RTERR_GEN ((L_Tmp7 <= 0
		  || (L2_1_unfold)->dim[((int) 1)] !=
		  ((int) 1) * (L_Tmp7 - 1) + ((int) L_Tmp6)),
		 "Index dimension does not match size and step");
      Midx_unfold (L2_1_unfold, ((int) 1), ((int) L_Tmp6), ((int) 1), flt);
      L2_3_uuin = L2_1_unfold;
      check_m2in_m2in_m4out (L1_out, L1_kernel, L2_3_uuin);
      Midx_m2extm2acc (L1_out, L1_kernel, L2_3_uuin, flt, flt, flt);
      L_Tmp0 = L2_3_uuin;
    }
    TRACE_POP ("C_idx_f2backconvol");
    return L_Tmp0;
  }
}

/*
 * FUNCTION idx-d2backconvol
 */
extern_c struct idx *
C_idx_d2backconvol (struct idx *L1_out, struct idx *L1_kernel,
		    struct idx *L1_in, struct idx *L2_1_unfold)
{
  TRACE_PUSH ("C_idx_d2backconvol");
  {
    struct idx *L_Tmp0;
    Midx_m2clear (L1_in, real);
    {
      Midx_declare (L2_1_0_unfold, 3);
      struct idx *L2_2_uin;
      struct idx *L2_3_uuin;
      int L_Tmp4;
      int L_Tmp5;
      int L_Tmp6;
      int L_Tmp7;
      Midx_init (L2_1_0_unfold, 3);
      L_Tmp4 = (L1_kernel)->dim[0];
      Midx_clone2 (L2_1_0_unfold, L1_in);
      RTERR_GEN ((((int) L_Tmp4) < 1
		  || ((int) 1) < 1), "illegal 'size' or 'step'");
      L_Tmp5 =
	1 + ((L2_1_0_unfold)->dim[((int) 0)] - ((int) L_Tmp4)) / ((int) 1);
      RTERR_GEN ((L_Tmp5 <= 0
		  || (L2_1_0_unfold)->dim[((int) 0)] !=
		  ((int) 1) * (L_Tmp5 - 1) + ((int) L_Tmp4)),
		 "Index dimension does not match size and step");
      Midx_unfold (L2_1_0_unfold, ((int) 0), ((int) L_Tmp4), ((int) 1), real);
      L2_2_uin = L2_1_0_unfold;
      L_Tmp6 = (L1_kernel)->dim[1];
      Midx_clone3 (L2_1_unfold, L2_2_uin);
      RTERR_GEN ((((int) L_Tmp6) < 1
		  || ((int) 1) < 1), "illegal 'size' or 'step'");
      L_Tmp7 =
	1 + ((L2_1_unfold)->dim[((int) 1)] - ((int) L_Tmp6)) / ((int) 1);
      RTERR_GEN ((L_Tmp7 <= 0
		  || (L2_1_unfold)->dim[((int) 1)] !=
		  ((int) 1) * (L_Tmp7 - 1) + ((int) L_Tmp6)),
		 "Index dimension does not match size and step");
      Midx_unfold (L2_1_unfold, ((int) 1), ((int) L_Tmp6), ((int) 1), real);
      L2_3_uuin = L2_1_unfold;
      check_m2in_m2in_m4out (L1_out, L1_kernel, L2_3_uuin);
      Midx_m2extm2acc (L1_out, L1_kernel, L2_3_uuin, real, real, real);
      L_Tmp0 = L2_3_uuin;
    }
    TRACE_POP ("C_idx_d2backconvol");
    return L_Tmp0;
  }
}

/*
 * FUNCTION idx-u2backconvol
 */
extern_c struct idx *
C_idx_u2backconvol (struct idx *L1_out, struct idx *L1_kernel,
		    struct idx *L1_in, struct idx *L2_1_unfold)
{
  TRACE_PUSH ("C_idx_u2backconvol");
  {
    struct idx *L_Tmp0;
    Midx_m2clear (L1_in, unsigned char);
    {
      Midx_declare (L2_1_0_unfold, 3);
      struct idx *L2_2_uin;
      struct idx *L2_3_uuin;
      int L_Tmp4;
      int L_Tmp5;
      int L_Tmp6;
      int L_Tmp7;
      Midx_init (L2_1_0_unfold, 3);
      L_Tmp4 = (L1_kernel)->dim[0];
      Midx_clone2 (L2_1_0_unfold, L1_in);
      RTERR_GEN ((((int) L_Tmp4) < 1
		  || ((int) 1) < 1), "illegal 'size' or 'step'");
      L_Tmp5 =
	1 + ((L2_1_0_unfold)->dim[((int) 0)] - ((int) L_Tmp4)) / ((int) 1);
      RTERR_GEN ((L_Tmp5 <= 0
		  || (L2_1_0_unfold)->dim[((int) 0)] !=
		  ((int) 1) * (L_Tmp5 - 1) + ((int) L_Tmp4)),
		 "Index dimension does not match size and step");
      Midx_unfold (L2_1_0_unfold, ((int) 0), ((int) L_Tmp4), ((int) 1),
		   unsigned char);
      L2_2_uin = L2_1_0_unfold;
      L_Tmp6 = (L1_kernel)->dim[1];
      Midx_clone3 (L2_1_unfold, L2_2_uin);
      RTERR_GEN ((((int) L_Tmp6) < 1
		  || ((int) 1) < 1), "illegal 'size' or 'step'");
      L_Tmp7 =
	1 + ((L2_1_unfold)->dim[((int) 1)] - ((int) L_Tmp6)) / ((int) 1);
      RTERR_GEN ((L_Tmp7 <= 0
		  || (L2_1_unfold)->dim[((int) 1)] !=
		  ((int) 1) * (L_Tmp7 - 1) + ((int) L_Tmp6)),
		 "Index dimension does not match size and step");
      Midx_unfold (L2_1_unfold, ((int) 1), ((int) L_Tmp6), ((int) 1),
		   unsigned char);
      L2_3_uuin = L2_1_unfold;
      check_m2in_m2in_m4out (L1_out, L1_kernel, L2_3_uuin);
      Midx_m2extm2acc (L1_out, L1_kernel, L2_3_uuin, unsigned char,
		       unsigned char, unsigned char);
      L_Tmp0 = L2_3_uuin;
    }
    TRACE_POP ("C_idx_u2backconvol");
    return L_Tmp0;
  }
}

/*
 * FUNCTION idx-f2backconvolacc
 */
extern_c struct idx *
C_idx_f2backconvolacc (struct idx *L1_out, struct idx *L1_kernel,
		       struct idx *L1_in, struct idx *L2_1_unfold)
{
  TRACE_PUSH ("C_idx_f2backconvolacc");
  {
    struct idx *L_Tmp0;
    {
      Midx_declare (L2_1_0_unfold, 3);
      struct idx *L2_2_uin;
      struct idx *L2_3_uuin;
      int L_Tmp4;
      int L_Tmp5;
      int L_Tmp6;
      int L_Tmp7;
      Midx_init (L2_1_0_unfold, 3);
      L_Tmp4 = (L1_kernel)->dim[0];
      Midx_clone2 (L2_1_0_unfold, L1_in);
      RTERR_GEN ((((int) L_Tmp4) < 1
		  || ((int) 1) < 1), "illegal 'size' or 'step'");
      L_Tmp5 =
	1 + ((L2_1_0_unfold)->dim[((int) 0)] - ((int) L_Tmp4)) / ((int) 1);
      RTERR_GEN ((L_Tmp5 <= 0
		  || (L2_1_0_unfold)->dim[((int) 0)] !=
		  ((int) 1) * (L_Tmp5 - 1) + ((int) L_Tmp4)),
		 "Index dimension does not match size and step");
      Midx_unfold (L2_1_0_unfold, ((int) 0), ((int) L_Tmp4), ((int) 1), flt);
      L2_2_uin = L2_1_0_unfold;
      L_Tmp6 = (L1_kernel)->dim[1];
      Midx_clone3 (L2_1_unfold, L2_2_uin);
      RTERR_GEN ((((int) L_Tmp6) < 1
		  || ((int) 1) < 1), "illegal 'size' or 'step'");
      L_Tmp7 =
	1 + ((L2_1_unfold)->dim[((int) 1)] - ((int) L_Tmp6)) / ((int) 1);
      RTERR_GEN ((L_Tmp7 <= 0
		  || (L2_1_unfold)->dim[((int) 1)] !=
		  ((int) 1) * (L_Tmp7 - 1) + ((int) L_Tmp6)),
		 "Index dimension does not match size and step");
      Midx_unfold (L2_1_unfold, ((int) 1), ((int) L_Tmp6), ((int) 1), flt);
      L2_3_uuin = L2_1_unfold;
      check_m2in_m2in_m4out (L1_out, L1_kernel, L2_3_uuin);
      Midx_m2extm2acc (L1_out, L1_kernel, L2_3_uuin, flt, flt, flt);
      L_Tmp0 = L2_3_uuin;
    }
    TRACE_POP ("C_idx_f2backconvolacc");
    return L_Tmp0;
  }
}

/*
 * FUNCTION idx-d2backconvolacc
 */
extern_c struct idx *
C_idx_d2backconvolacc (struct idx *L1_out, struct idx *L1_kernel,
		       struct idx *L1_in, struct idx *L2_1_unfold)
{
  TRACE_PUSH ("C_idx_d2backconvolacc");
  {
    struct idx *L_Tmp0;
    {
      Midx_declare (L2_1_0_unfold, 3);
      struct idx *L2_2_uin;
      struct idx *L2_3_uuin;
      int L_Tmp4;
      int L_Tmp5;
      int L_Tmp6;
      int L_Tmp7;
      Midx_init (L2_1_0_unfold, 3);
      L_Tmp4 = (L1_kernel)->dim[0];
      Midx_clone2 (L2_1_0_unfold, L1_in);
      RTERR_GEN ((((int) L_Tmp4) < 1
		  || ((int) 1) < 1), "illegal 'size' or 'step'");
      L_Tmp5 =
	1 + ((L2_1_0_unfold)->dim[((int) 0)] - ((int) L_Tmp4)) / ((int) 1);
      RTERR_GEN ((L_Tmp5 <= 0
		  || (L2_1_0_unfold)->dim[((int) 0)] !=
		  ((int) 1) * (L_Tmp5 - 1) + ((int) L_Tmp4)),
		 "Index dimension does not match size and step");
      Midx_unfold (L2_1_0_unfold, ((int) 0), ((int) L_Tmp4), ((int) 1), real);
      L2_2_uin = L2_1_0_unfold;
      L_Tmp6 = (L1_kernel)->dim[1];
      Midx_clone3 (L2_1_unfold, L2_2_uin);
      RTERR_GEN ((((int) L_Tmp6) < 1
		  || ((int) 1) < 1), "illegal 'size' or 'step'");
      L_Tmp7 =
	1 + ((L2_1_unfold)->dim[((int) 1)] - ((int) L_Tmp6)) / ((int) 1);
      RTERR_GEN ((L_Tmp7 <= 0
		  || (L2_1_unfold)->dim[((int) 1)] !=
		  ((int) 1) * (L_Tmp7 - 1) + ((int) L_Tmp6)),
		 "Index dimension does not match size and step");
      Midx_unfold (L2_1_unfold, ((int) 1), ((int) L_Tmp6), ((int) 1), real);
      L2_3_uuin = L2_1_unfold;
      check_m2in_m2in_m4out (L1_out, L1_kernel, L2_3_uuin);
      Midx_m2extm2acc (L1_out, L1_kernel, L2_3_uuin, real, real, real);
      L_Tmp0 = L2_3_uuin;
    }
    TRACE_POP ("C_idx_d2backconvolacc");
    return L_Tmp0;
  }
}

/*
 * FUNCTION idx-u2backconvolacc
 */
extern_c struct idx *
C_idx_u2backconvolacc (struct idx *L1_out, struct idx *L1_kernel,
		       struct idx *L1_in, struct idx *L2_1_unfold)
{
  TRACE_PUSH ("C_idx_u2backconvolacc");
  {
    struct idx *L_Tmp0;
    {
      Midx_declare (L2_1_0_unfold, 3);
      struct idx *L2_2_uin;
      struct idx *L2_3_uuin;
      int L_Tmp4;
      int L_Tmp5;
      int L_Tmp6;
      int L_Tmp7;
      Midx_init (L2_1_0_unfold, 3);
      L_Tmp4 = (L1_kernel)->dim[0];
      Midx_clone2 (L2_1_0_unfold, L1_in);
      RTERR_GEN ((((int) L_Tmp4) < 1
		  || ((int) 1) < 1), "illegal 'size' or 'step'");
      L_Tmp5 =
	1 + ((L2_1_0_unfold)->dim[((int) 0)] - ((int) L_Tmp4)) / ((int) 1);
      RTERR_GEN ((L_Tmp5 <= 0
		  || (L2_1_0_unfold)->dim[((int) 0)] !=
		  ((int) 1) * (L_Tmp5 - 1) + ((int) L_Tmp4)),
		 "Index dimension does not match size and step");
      Midx_unfold (L2_1_0_unfold, ((int) 0), ((int) L_Tmp4), ((int) 1),
		   unsigned char);
      L2_2_uin = L2_1_0_unfold;
      L_Tmp6 = (L1_kernel)->dim[1];
      Midx_clone3 (L2_1_unfold, L2_2_uin);
      RTERR_GEN ((((int) L_Tmp6) < 1
		  || ((int) 1) < 1), "illegal 'size' or 'step'");
      L_Tmp7 =
	1 + ((L2_1_unfold)->dim[((int) 1)] - ((int) L_Tmp6)) / ((int) 1);
      RTERR_GEN ((L_Tmp7 <= 0
		  || (L2_1_unfold)->dim[((int) 1)] !=
		  ((int) 1) * (L_Tmp7 - 1) + ((int) L_Tmp6)),
		 "Index dimension does not match size and step");
      Midx_unfold (L2_1_unfold, ((int) 1), ((int) L_Tmp6), ((int) 1),
		   unsigned char);
      L2_3_uuin = L2_1_unfold;
      check_m2in_m2in_m4out (L1_out, L1_kernel, L2_3_uuin);
      Midx_m2extm2acc (L1_out, L1_kernel, L2_3_uuin, unsigned char,
		       unsigned char, unsigned char);
      L_Tmp0 = L2_3_uuin;
    }
    TRACE_POP ("C_idx_u2backconvolacc");
    return L_Tmp0;
  }
}

/*
 * FUNCTION idx-f1subsample
 */
extern_c struct idx *
C_idx_f1subsample (struct idx *L1_in, int L1_n, struct idx *L1_out,
		   struct idx *L2_0_unfold)
{
  TRACE_PUSH ("C_idx_f1subsample");
  {
    struct idx *L_Tmp0;
    {
      struct idx *L2_1_uin;
      int L_Tmp2;
      Midx_clone1 (L2_0_unfold, L1_in);
      RTERR_GEN ((((int) L1_n) < 1
		  || ((int) L1_n) < 1), "illegal 'size' or 'step'");
      L_Tmp2 =
	1 + ((L2_0_unfold)->dim[((int) 0)] - ((int) L1_n)) / ((int) L1_n);
      RTERR_GEN ((L_Tmp2 <= 0
		  || (L2_0_unfold)->dim[((int) 0)] !=
		  ((int) L1_n) * (L_Tmp2 - 1) + ((int) L1_n)),
		 "Index dimension does not match size and step");
      Midx_unfold (L2_0_unfold, ((int) 0), ((int) L1_n), ((int) L1_n), flt);
      L2_1_uin = L2_0_unfold;
      Midx_m1clear (L1_out, flt);
      {
	Midx_begin_eloop1 (L3_z, L2_1_uin, flt)
	{
	  check_main_main_maout (&L3_z, L1_out, L1_out);
	  Midx_m1add (&L3_z, L1_out, L1_out, flt, flt, flt);
	} Midx_end_eloop1 (L3_z, L2_1_uin, flt);
	L_Tmp0 = L2_1_uin;
      }
    }
    TRACE_POP ("C_idx_f1subsample");
    return L_Tmp0;
  }
}

/*
 * FUNCTION idx-d1subsample
 */
extern_c struct idx *
C_idx_d1subsample (struct idx *L1_in, int L1_n, struct idx *L1_out,
		   struct idx *L2_0_unfold)
{
  TRACE_PUSH ("C_idx_d1subsample");
  {
    struct idx *L_Tmp0;
    {
      struct idx *L2_1_uin;
      int L_Tmp2;
      Midx_clone1 (L2_0_unfold, L1_in);
      RTERR_GEN ((((int) L1_n) < 1
		  || ((int) L1_n) < 1), "illegal 'size' or 'step'");
      L_Tmp2 =
	1 + ((L2_0_unfold)->dim[((int) 0)] - ((int) L1_n)) / ((int) L1_n);
      RTERR_GEN ((L_Tmp2 <= 0
		  || (L2_0_unfold)->dim[((int) 0)] !=
		  ((int) L1_n) * (L_Tmp2 - 1) + ((int) L1_n)),
		 "Index dimension does not match size and step");
      Midx_unfold (L2_0_unfold, ((int) 0), ((int) L1_n), ((int) L1_n), real);
      L2_1_uin = L2_0_unfold;
      Midx_m1clear (L1_out, real);
      {
	Midx_begin_eloop1 (L3_z, L2_1_uin, real)
	{
	  check_main_main_maout (&L3_z, L1_out, L1_out);
	  Midx_m1add (&L3_z, L1_out, L1_out, real, real, real);
	} Midx_end_eloop1 (L3_z, L2_1_uin, real);
	L_Tmp0 = L2_1_uin;
      }
    }
    TRACE_POP ("C_idx_d1subsample");
    return L_Tmp0;
  }
}

/*
 * FUNCTION idx-u1subsample
 */
extern_c struct idx *
C_idx_u1subsample (struct idx *L1_in, int L1_n, struct idx *L1_out,
		   struct idx *L2_0_unfold)
{
  TRACE_PUSH ("C_idx_u1subsample");
  {
    struct idx *L_Tmp0;
    {
      struct idx *L2_1_uin;
      int L_Tmp2;
      Midx_clone1 (L2_0_unfold, L1_in);
      RTERR_GEN ((((int) L1_n) < 1
		  || ((int) L1_n) < 1), "illegal 'size' or 'step'");
      L_Tmp2 =
	1 + ((L2_0_unfold)->dim[((int) 0)] - ((int) L1_n)) / ((int) L1_n);
      RTERR_GEN ((L_Tmp2 <= 0
		  || (L2_0_unfold)->dim[((int) 0)] !=
		  ((int) L1_n) * (L_Tmp2 - 1) + ((int) L1_n)),
		 "Index dimension does not match size and step");
      Midx_unfold (L2_0_unfold, ((int) 0), ((int) L1_n), ((int) L1_n),
		   unsigned char);
      L2_1_uin = L2_0_unfold;
      Midx_m1clear (L1_out, unsigned char);
      {
	Midx_begin_eloop1 (L3_z, L2_1_uin, unsigned char)
	{
	  check_main_main_maout (&L3_z, L1_out, L1_out);
	  Midx_m1add (&L3_z, L1_out, L1_out, unsigned char, unsigned char,
		      unsigned char);
	} Midx_end_eloop1 (L3_z, L2_1_uin, unsigned char);
	L_Tmp0 = L2_1_uin;
      }
    }
    TRACE_POP ("C_idx_u1subsample");
    return L_Tmp0;
  }
}

/*
 * FUNCTION idx-f1oversample
 */
extern_c char
C_idx_f1oversample (struct idx *L1_out, int L1_n, struct idx *L1_in)
{
  TRACE_PUSH ("C_idx_f1oversample");
  {
    char L_Tmp0;
    {
      Midx_declare (L2_1_0_unfold, 2);
      struct idx *L2_2_uin;
      int L_Tmp3;
      Midx_init (L2_1_0_unfold, 2);
      Midx_clone1 (L2_1_0_unfold, L1_in);
      RTERR_GEN ((((int) L1_n) < 1
		  || ((int) L1_n) < 1), "illegal 'size' or 'step'");
      L_Tmp3 =
	1 + ((L2_1_0_unfold)->dim[((int) 0)] - ((int) L1_n)) / ((int) L1_n);
      RTERR_GEN ((L_Tmp3 <= 0
		  || (L2_1_0_unfold)->dim[((int) 0)] !=
		  ((int) L1_n) * (L_Tmp3 - 1) + ((int) L1_n)),
		 "Index dimension does not match size and step");
      Midx_unfold (L2_1_0_unfold, ((int) 0), ((int) L1_n), ((int) L1_n), flt);
      L2_2_uin = L2_1_0_unfold;
      {
	Midx_begin_eloop1 (L3_z, L2_2_uin, flt)
	{
	  check_main_maout (L1_out, &L3_z);
	  Midx_m1copy (L1_out, &L3_z, flt, flt);
	} Midx_end_eloop1 (L3_z, L2_2_uin, flt);
      }
      L_Tmp0 = 0;
    }
    TRACE_POP ("C_idx_f1oversample");
    return 0;
  }
}

/*
 * FUNCTION idx-d1oversample
 */
extern_c char
C_idx_d1oversample (struct idx *L1_out, int L1_n, struct idx *L1_in)
{
  TRACE_PUSH ("C_idx_d1oversample");
  {
    char L_Tmp0;
    {
      Midx_declare (L2_1_0_unfold, 2);
      struct idx *L2_2_uin;
      int L_Tmp3;
      Midx_init (L2_1_0_unfold, 2);
      Midx_clone1 (L2_1_0_unfold, L1_in);
      RTERR_GEN ((((int) L1_n) < 1
		  || ((int) L1_n) < 1), "illegal 'size' or 'step'");
      L_Tmp3 =
	1 + ((L2_1_0_unfold)->dim[((int) 0)] - ((int) L1_n)) / ((int) L1_n);
      RTERR_GEN ((L_Tmp3 <= 0
		  || (L2_1_0_unfold)->dim[((int) 0)] !=
		  ((int) L1_n) * (L_Tmp3 - 1) + ((int) L1_n)),
		 "Index dimension does not match size and step");
      Midx_unfold (L2_1_0_unfold, ((int) 0), ((int) L1_n), ((int) L1_n),
		   real);
      L2_2_uin = L2_1_0_unfold;
      {
	Midx_begin_eloop1 (L3_z, L2_2_uin, real)
	{
	  check_main_maout (L1_out, &L3_z);
	  Midx_m1copy (L1_out, &L3_z, real, real);
	} Midx_end_eloop1 (L3_z, L2_2_uin, real);
      }
      L_Tmp0 = 0;
    }
    TRACE_POP ("C_idx_d1oversample");
    return 0;
  }
}

/*
 * FUNCTION idx-u1oversample
 */
extern_c char
C_idx_u1oversample (struct idx *L1_out, int L1_n, struct idx *L1_in)
{
  TRACE_PUSH ("C_idx_u1oversample");
  {
    char L_Tmp0;
    {
      Midx_declare (L2_1_0_unfold, 2);
      struct idx *L2_2_uin;
      int L_Tmp3;
      Midx_init (L2_1_0_unfold, 2);
      Midx_clone1 (L2_1_0_unfold, L1_in);
      RTERR_GEN ((((int) L1_n) < 1
		  || ((int) L1_n) < 1), "illegal 'size' or 'step'");
      L_Tmp3 =
	1 + ((L2_1_0_unfold)->dim[((int) 0)] - ((int) L1_n)) / ((int) L1_n);
      RTERR_GEN ((L_Tmp3 <= 0
		  || (L2_1_0_unfold)->dim[((int) 0)] !=
		  ((int) L1_n) * (L_Tmp3 - 1) + ((int) L1_n)),
		 "Index dimension does not match size and step");
      Midx_unfold (L2_1_0_unfold, ((int) 0), ((int) L1_n), ((int) L1_n),
		   unsigned char);
      L2_2_uin = L2_1_0_unfold;
      {
	Midx_begin_eloop1 (L3_z, L2_2_uin, unsigned char)
	{
	  check_main_maout (L1_out, &L3_z);
	  Midx_m1copy (L1_out, &L3_z, unsigned char, unsigned char);
	} Midx_end_eloop1 (L3_z, L2_2_uin, unsigned char);
      }
      L_Tmp0 = 0;
    }
    TRACE_POP ("C_idx_u1oversample");
    return 0;
  }
}

/*
 * FUNCTION idx-f2subsample
 */
extern_c char
C_idx_f2subsample (struct idx *L1_in, int L1_nlin, int L1_ncol,
		   struct idx *L1_out)
{
  TRACE_PUSH ("C_idx_f2subsample");
  {
    char L_Tmp0;
    {
      Midx_declare (L2_1_0_unfold, 3);
      struct idx *L2_2_uin;
      Midx_declare (L2_3_1_unfold, 4);
      struct idx *L2_4_uuin;
      int L_Tmp5;
      int L_Tmp6;
      Midx_init (L2_1_0_unfold, 3);
      Midx_init (L2_3_1_unfold, 4);
      Midx_clone2 (L2_1_0_unfold, L1_in);
      RTERR_GEN ((((int) L1_nlin) < 1
		  || ((int) L1_nlin) < 1), "illegal 'size' or 'step'");
      L_Tmp5 =
	1 + ((L2_1_0_unfold)->dim[((int) 0)] -
	     ((int) L1_nlin)) / ((int) L1_nlin);
      RTERR_GEN ((L_Tmp5 <= 0
		  || (L2_1_0_unfold)->dim[((int) 0)] !=
		  ((int) L1_nlin) * (L_Tmp5 - 1) + ((int) L1_nlin)),
		 "Index dimension does not match size and step");
      Midx_unfold (L2_1_0_unfold, ((int) 0), ((int) L1_nlin), ((int) L1_nlin),
		   flt);
      L2_2_uin = L2_1_0_unfold;
      Midx_clone3 (L2_3_1_unfold, L2_2_uin);
      RTERR_GEN ((((int) L1_ncol) < 1
		  || ((int) L1_ncol) < 1), "illegal 'size' or 'step'");
      L_Tmp6 =
	1 + ((L2_3_1_unfold)->dim[((int) 1)] -
	     ((int) L1_ncol)) / ((int) L1_ncol);
      RTERR_GEN ((L_Tmp6 <= 0
		  || (L2_3_1_unfold)->dim[((int) 1)] !=
		  ((int) L1_ncol) * (L_Tmp6 - 1) + ((int) L1_ncol)),
		 "Index dimension does not match size and step");
      Midx_unfold (L2_3_1_unfold, ((int) 1), ((int) L1_ncol), ((int) L1_ncol),
		   flt);
      L2_4_uuin = L2_3_1_unfold;
      Midx_m2clear (L1_out, flt);
      {
	Midx_begin_eloop1 (L3_z1, L2_4_uuin, flt)
	{
	  {
	    Midx_begin_eloop1 (L4_z2, &L3_z1, flt)
	    {
	      check_main_main_maout (&L4_z2, L1_out, L1_out);
	      Midx_m2add (&L4_z2, L1_out, L1_out, flt, flt, flt);
	    } Midx_end_eloop1 (L4_z2, &L3_z1, flt);
	  }
	} Midx_end_eloop1 (L3_z1, L2_4_uuin, flt);
      }
      L_Tmp0 = 0;
    }
    TRACE_POP ("C_idx_f2subsample");
    return 0;
  }
}

/*
 * FUNCTION idx-d2subsample
 */
extern_c char
C_idx_d2subsample (struct idx *L1_in, int L1_nlin, int L1_ncol,
		   struct idx *L1_out)
{
  TRACE_PUSH ("C_idx_d2subsample");
  {
    char L_Tmp0;
    {
      Midx_declare (L2_1_0_unfold, 3);
      struct idx *L2_2_uin;
      Midx_declare (L2_3_1_unfold, 4);
      struct idx *L2_4_uuin;
      int L_Tmp5;
      int L_Tmp6;
      Midx_init (L2_1_0_unfold, 3);
      Midx_init (L2_3_1_unfold, 4);
      Midx_clone2 (L2_1_0_unfold, L1_in);
      RTERR_GEN ((((int) L1_nlin) < 1
		  || ((int) L1_nlin) < 1), "illegal 'size' or 'step'");
      L_Tmp5 =
	1 + ((L2_1_0_unfold)->dim[((int) 0)] -
	     ((int) L1_nlin)) / ((int) L1_nlin);
      RTERR_GEN ((L_Tmp5 <= 0
		  || (L2_1_0_unfold)->dim[((int) 0)] !=
		  ((int) L1_nlin) * (L_Tmp5 - 1) + ((int) L1_nlin)),
		 "Index dimension does not match size and step");
      Midx_unfold (L2_1_0_unfold, ((int) 0), ((int) L1_nlin), ((int) L1_nlin),
		   real);
      L2_2_uin = L2_1_0_unfold;
      Midx_clone3 (L2_3_1_unfold, L2_2_uin);
      RTERR_GEN ((((int) L1_ncol) < 1
		  || ((int) L1_ncol) < 1), "illegal 'size' or 'step'");
      L_Tmp6 =
	1 + ((L2_3_1_unfold)->dim[((int) 1)] -
	     ((int) L1_ncol)) / ((int) L1_ncol);
      RTERR_GEN ((L_Tmp6 <= 0
		  || (L2_3_1_unfold)->dim[((int) 1)] !=
		  ((int) L1_ncol) * (L_Tmp6 - 1) + ((int) L1_ncol)),
		 "Index dimension does not match size and step");
      Midx_unfold (L2_3_1_unfold, ((int) 1), ((int) L1_ncol), ((int) L1_ncol),
		   real);
      L2_4_uuin = L2_3_1_unfold;
      Midx_m2clear (L1_out, real);
      {
	Midx_begin_eloop1 (L3_z1, L2_4_uuin, real)
	{
	  {
	    Midx_begin_eloop1 (L4_z2, &L3_z1, real)
	    {
	      check_main_main_maout (&L4_z2, L1_out, L1_out);
	      Midx_m2add (&L4_z2, L1_out, L1_out, real, real, real);
	    } Midx_end_eloop1 (L4_z2, &L3_z1, real);
	  }
	} Midx_end_eloop1 (L3_z1, L2_4_uuin, real);
      }
      L_Tmp0 = 0;
    }
    TRACE_POP ("C_idx_d2subsample");
    return 0;
  }
}

/*
 * FUNCTION idx-u2subsample
 */
extern_c char
C_idx_u2subsample (struct idx *L1_in, int L1_nlin, int L1_ncol,
		   struct idx *L1_out)
{
  TRACE_PUSH ("C_idx_u2subsample");
  {
    char L_Tmp0;
    {
      Midx_declare (L2_1_0_unfold, 3);
      struct idx *L2_2_uin;
      Midx_declare (L2_3_1_unfold, 4);
      struct idx *L2_4_uuin;
      int L_Tmp5;
      int L_Tmp6;
      Midx_init (L2_1_0_unfold, 3);
      Midx_init (L2_3_1_unfold, 4);
      Midx_clone2 (L2_1_0_unfold, L1_in);
      RTERR_GEN ((((int) L1_nlin) < 1
		  || ((int) L1_nlin) < 1), "illegal 'size' or 'step'");
      L_Tmp5 =
	1 + ((L2_1_0_unfold)->dim[((int) 0)] -
	     ((int) L1_nlin)) / ((int) L1_nlin);
      RTERR_GEN ((L_Tmp5 <= 0
		  || (L2_1_0_unfold)->dim[((int) 0)] !=
		  ((int) L1_nlin) * (L_Tmp5 - 1) + ((int) L1_nlin)),
		 "Index dimension does not match size and step");
      Midx_unfold (L2_1_0_unfold, ((int) 0), ((int) L1_nlin), ((int) L1_nlin),
		   unsigned char);
      L2_2_uin = L2_1_0_unfold;
      Midx_clone3 (L2_3_1_unfold, L2_2_uin);
      RTERR_GEN ((((int) L1_ncol) < 1
		  || ((int) L1_ncol) < 1), "illegal 'size' or 'step'");
      L_Tmp6 =
	1 + ((L2_3_1_unfold)->dim[((int) 1)] -
	     ((int) L1_ncol)) / ((int) L1_ncol);
      RTERR_GEN ((L_Tmp6 <= 0
		  || (L2_3_1_unfold)->dim[((int) 1)] !=
		  ((int) L1_ncol) * (L_Tmp6 - 1) + ((int) L1_ncol)),
		 "Index dimension does not match size and step");
      Midx_unfold (L2_3_1_unfold, ((int) 1), ((int) L1_ncol), ((int) L1_ncol),
		   unsigned char);
      L2_4_uuin = L2_3_1_unfold;
      Midx_m2clear (L1_out, unsigned char);
      {
	Midx_begin_eloop1 (L3_z1, L2_4_uuin, unsigned char)
	{
	  {
	    Midx_begin_eloop1 (L4_z2, &L3_z1, unsigned char)
	    {
	      check_main_main_maout (&L4_z2, L1_out, L1_out);
	      Midx_m2add (&L4_z2, L1_out, L1_out, unsigned char,
			  unsigned char, unsigned char);
	    } Midx_end_eloop1 (L4_z2, &L3_z1, unsigned char);
	  }
	} Midx_end_eloop1 (L3_z1, L2_4_uuin, unsigned char);
      }
      L_Tmp0 = 0;
    }
    TRACE_POP ("C_idx_u2subsample");
    return 0;
  }
}

/*
 * FUNCTION idx-f2oversample
 */
extern_c char
C_idx_f2oversample (struct idx *L1_out, int L1_nlin, int L1_ncol,
		    struct idx *L1_in)
{
  TRACE_PUSH ("C_idx_f2oversample");
  {
    char L_Tmp0;
    {
      Midx_declare (L2_1_0_unfold, 3);
      struct idx *L2_2_uin;
      Midx_declare (L2_3_1_unfold, 4);
      struct idx *L2_4_uuin;
      int L_Tmp5;
      int L_Tmp6;
      Midx_init (L2_1_0_unfold, 3);
      Midx_init (L2_3_1_unfold, 4);
      Midx_clone2 (L2_1_0_unfold, L1_in);
      RTERR_GEN ((((int) L1_nlin) < 1
		  || ((int) L1_nlin) < 1), "illegal 'size' or 'step'");
      L_Tmp5 =
	1 + ((L2_1_0_unfold)->dim[((int) 0)] -
	     ((int) L1_nlin)) / ((int) L1_nlin);
      RTERR_GEN ((L_Tmp5 <= 0
		  || (L2_1_0_unfold)->dim[((int) 0)] !=
		  ((int) L1_nlin) * (L_Tmp5 - 1) + ((int) L1_nlin)),
		 "Index dimension does not match size and step");
      Midx_unfold (L2_1_0_unfold, ((int) 0), ((int) L1_nlin), ((int) L1_nlin),
		   flt);
      L2_2_uin = L2_1_0_unfold;
      Midx_clone3 (L2_3_1_unfold, L2_2_uin);
      RTERR_GEN ((((int) L1_ncol) < 1
		  || ((int) L1_ncol) < 1), "illegal 'size' or 'step'");
      L_Tmp6 =
	1 + ((L2_3_1_unfold)->dim[((int) 1)] -
	     ((int) L1_ncol)) / ((int) L1_ncol);
      RTERR_GEN ((L_Tmp6 <= 0
		  || (L2_3_1_unfold)->dim[((int) 1)] !=
		  ((int) L1_ncol) * (L_Tmp6 - 1) + ((int) L1_ncol)),
		 "Index dimension does not match size and step");
      Midx_unfold (L2_3_1_unfold, ((int) 1), ((int) L1_ncol), ((int) L1_ncol),
		   flt);
      L2_4_uuin = L2_3_1_unfold;
      {
	Midx_begin_eloop1 (L3_z1, L2_4_uuin, flt)
	{
	  {
	    Midx_begin_eloop1 (L4_z2, &L3_z1, flt)
	    {
	      check_main_maout (L1_out, &L4_z2);
	      Midx_m2copy (L1_out, &L4_z2, flt, flt);
	    } Midx_end_eloop1 (L4_z2, &L3_z1, flt);
	  }
	} Midx_end_eloop1 (L3_z1, L2_4_uuin, flt);
      }
      L_Tmp0 = 0;
    }
    TRACE_POP ("C_idx_f2oversample");
    return 0;
  }
}

/*
 * FUNCTION idx-d2oversample
 */
extern_c char
C_idx_d2oversample (struct idx *L1_out, int L1_nlin, int L1_ncol,
		    struct idx *L1_in)
{
  TRACE_PUSH ("C_idx_d2oversample");
  {
    char L_Tmp0;
    {
      Midx_declare (L2_1_0_unfold, 3);
      struct idx *L2_2_uin;
      Midx_declare (L2_3_1_unfold, 4);
      struct idx *L2_4_uuin;
      int L_Tmp5;
      int L_Tmp6;
      Midx_init (L2_1_0_unfold, 3);
      Midx_init (L2_3_1_unfold, 4);
      Midx_clone2 (L2_1_0_unfold, L1_in);
      RTERR_GEN ((((int) L1_nlin) < 1
		  || ((int) L1_nlin) < 1), "illegal 'size' or 'step'");
      L_Tmp5 =
	1 + ((L2_1_0_unfold)->dim[((int) 0)] -
	     ((int) L1_nlin)) / ((int) L1_nlin);
      RTERR_GEN ((L_Tmp5 <= 0
		  || (L2_1_0_unfold)->dim[((int) 0)] !=
		  ((int) L1_nlin) * (L_Tmp5 - 1) + ((int) L1_nlin)),
		 "Index dimension does not match size and step");
      Midx_unfold (L2_1_0_unfold, ((int) 0), ((int) L1_nlin), ((int) L1_nlin),
		   real);
      L2_2_uin = L2_1_0_unfold;
      Midx_clone3 (L2_3_1_unfold, L2_2_uin);
      RTERR_GEN ((((int) L1_ncol) < 1
		  || ((int) L1_ncol) < 1), "illegal 'size' or 'step'");
      L_Tmp6 =
	1 + ((L2_3_1_unfold)->dim[((int) 1)] -
	     ((int) L1_ncol)) / ((int) L1_ncol);
      RTERR_GEN ((L_Tmp6 <= 0
		  || (L2_3_1_unfold)->dim[((int) 1)] !=
		  ((int) L1_ncol) * (L_Tmp6 - 1) + ((int) L1_ncol)),
		 "Index dimension does not match size and step");
      Midx_unfold (L2_3_1_unfold, ((int) 1), ((int) L1_ncol), ((int) L1_ncol),
		   real);
      L2_4_uuin = L2_3_1_unfold;
      {
	Midx_begin_eloop1 (L3_z1, L2_4_uuin, real)
	{
	  {
	    Midx_begin_eloop1 (L4_z2, &L3_z1, real)
	    {
	      check_main_maout (L1_out, &L4_z2);
	      Midx_m2copy (L1_out, &L4_z2, real, real);
	    } Midx_end_eloop1 (L4_z2, &L3_z1, real);
	  }
	} Midx_end_eloop1 (L3_z1, L2_4_uuin, real);
      }
      L_Tmp0 = 0;
    }
    TRACE_POP ("C_idx_d2oversample");
    return 0;
  }
}

/*
 * FUNCTION idx-u2oversample
 */
extern_c char
C_idx_u2oversample (struct idx *L1_out, int L1_nlin, int L1_ncol,
		    struct idx *L1_in)
{
  TRACE_PUSH ("C_idx_u2oversample");
  {
    char L_Tmp0;
    {
      Midx_declare (L2_1_0_unfold, 3);
      struct idx *L2_2_uin;
      Midx_declare (L2_3_1_unfold, 4);
      struct idx *L2_4_uuin;
      int L_Tmp5;
      int L_Tmp6;
      Midx_init (L2_1_0_unfold, 3);
      Midx_init (L2_3_1_unfold, 4);
      Midx_clone2 (L2_1_0_unfold, L1_in);
      RTERR_GEN ((((int) L1_nlin) < 1
		  || ((int) L1_nlin) < 1), "illegal 'size' or 'step'");
      L_Tmp5 =
	1 + ((L2_1_0_unfold)->dim[((int) 0)] -
	     ((int) L1_nlin)) / ((int) L1_nlin);
      RTERR_GEN ((L_Tmp5 <= 0
		  || (L2_1_0_unfold)->dim[((int) 0)] !=
		  ((int) L1_nlin) * (L_Tmp5 - 1) + ((int) L1_nlin)),
		 "Index dimension does not match size and step");
      Midx_unfold (L2_1_0_unfold, ((int) 0), ((int) L1_nlin), ((int) L1_nlin),
		   unsigned char);
      L2_2_uin = L2_1_0_unfold;
      Midx_clone3 (L2_3_1_unfold, L2_2_uin);
      RTERR_GEN ((((int) L1_ncol) < 1
		  || ((int) L1_ncol) < 1), "illegal 'size' or 'step'");
      L_Tmp6 =
	1 + ((L2_3_1_unfold)->dim[((int) 1)] -
	     ((int) L1_ncol)) / ((int) L1_ncol);
      RTERR_GEN ((L_Tmp6 <= 0
		  || (L2_3_1_unfold)->dim[((int) 1)] !=
		  ((int) L1_ncol) * (L_Tmp6 - 1) + ((int) L1_ncol)),
		 "Index dimension does not match size and step");
      Midx_unfold (L2_3_1_unfold, ((int) 1), ((int) L1_ncol), ((int) L1_ncol),
		   unsigned char);
      L2_4_uuin = L2_3_1_unfold;
      {
	Midx_begin_eloop1 (L3_z1, L2_4_uuin, unsigned char)
	{
	  {
	    Midx_begin_eloop1 (L4_z2, &L3_z1, unsigned char)
	    {
	      check_main_maout (L1_out, &L4_z2);
	      Midx_m2copy (L1_out, &L4_z2, unsigned char, unsigned char);
	    } Midx_end_eloop1 (L4_z2, &L3_z1, unsigned char);
	  }
	} Midx_end_eloop1 (L3_z1, L2_4_uuin, unsigned char);
      }
      L_Tmp0 = 0;
    }
    TRACE_POP ("C_idx_u2oversample");
    return 0;
  }
}

/* ---------------------------------------- */

#ifndef NOLISP

/*
 * STUB error-notcontiguous
 */
DH (X_error_notcontiguous)
{
  dharg ret;
  ret.dh_char = C_error_notcontiguous ();
  return ret;
}

/*
 * DHDOC error-notcontiguous
 */
DHDOC (K_error_notcontiguous_Ra8b05737, X_error_notcontiguous,
       "C_error_notcontiguous", 0, 0) =
{
DH_FUNC (0), DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB idx-m1fastconvol-check
 */
DH (X_idx_m1fastconvol_check)
{
  dharg ret;
  ret.dh_char =
    C_idx_m1fastconvol_check (a[1].dh_int, a[2].dh_int, a[3].dh_int,
			      a[4].dh_int);
  return ret;
}

/*
 * DHDOC idx-m1fastconvol-check
 */
DHDOC (K_idx_m1fastconvol_check_Rcfe6720e, X_idx_m1fastconvol_check,
       "C_idx_m1fastconvol_check", 0, 0) =
{
DH_FUNC (4),
    DH_INT, DH_INT, DH_INT, DH_INT, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB idx-f1fastconvol2acc
 */
DH (X_idx_f1fastconvol2acc)
{
  dharg ret;
  ret.dh_char =
    C_idx_f1fastconvol2acc (a[1].dh_idx_ptr, a[2].dh_idx_ptr,
			    a[3].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC idx-f1fastconvol2acc
 */
DHDOC (K_idx_f1fastconvol2acc_R2ded5b58, X_idx_f1fastconvol2acc,
       "C_idx_f1fastconvol2acc", 0, 0) =
{
DH_FUNC (3),
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ),
    DH_FLT,
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ),
    DH_FLT,
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ), DH_FLT, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB idx-d1fastconvol2acc
 */
DH (X_idx_d1fastconvol2acc)
{
  dharg ret;
  ret.dh_char =
    C_idx_d1fastconvol2acc (a[1].dh_idx_ptr, a[2].dh_idx_ptr,
			    a[3].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC idx-d1fastconvol2acc
 */
DHDOC (K_idx_d1fastconvol2acc_R28bcf634, X_idx_d1fastconvol2acc,
       "C_idx_d1fastconvol2acc", 0, 0) =
{
DH_FUNC (3),
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ),
    DH_REAL,
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ),
    DH_REAL,
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ), DH_REAL, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB idx-u1fastconvol2acc
 */
DH (X_idx_u1fastconvol2acc)
{
  dharg ret;
  ret.dh_char =
    C_idx_u1fastconvol2acc (a[1].dh_idx_ptr, a[2].dh_idx_ptr,
			    a[3].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC idx-u1fastconvol2acc
 */
DHDOC (K_idx_u1fastconvol2acc_R5968370f, X_idx_u1fastconvol2acc,
       "C_idx_u1fastconvol2acc", 0, 0) =
{
DH_FUNC (3),
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ), DH_UBYTE, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB idx-f1fastconvol3acc
 */
DH (X_idx_f1fastconvol3acc)
{
  dharg ret;
  ret.dh_char =
    C_idx_f1fastconvol3acc (a[1].dh_idx_ptr, a[2].dh_idx_ptr,
			    a[3].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC idx-f1fastconvol3acc
 */
DHDOC (K_idx_f1fastconvol3acc_R2ded5b58, X_idx_f1fastconvol3acc,
       "C_idx_f1fastconvol3acc", 0, 0) =
{
DH_FUNC (3),
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ),
    DH_FLT,
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ),
    DH_FLT,
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ), DH_FLT, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB idx-d1fastconvol3acc
 */
DH (X_idx_d1fastconvol3acc)
{
  dharg ret;
  ret.dh_char =
    C_idx_d1fastconvol3acc (a[1].dh_idx_ptr, a[2].dh_idx_ptr,
			    a[3].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC idx-d1fastconvol3acc
 */
DHDOC (K_idx_d1fastconvol3acc_R28bcf634, X_idx_d1fastconvol3acc,
       "C_idx_d1fastconvol3acc", 0, 0) =
{
DH_FUNC (3),
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ),
    DH_REAL,
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ),
    DH_REAL,
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ), DH_REAL, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB idx-u1fastconvol3acc
 */
DH (X_idx_u1fastconvol3acc)
{
  dharg ret;
  ret.dh_char =
    C_idx_u1fastconvol3acc (a[1].dh_idx_ptr, a[2].dh_idx_ptr,
			    a[3].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC idx-u1fastconvol3acc
 */
DHDOC (K_idx_u1fastconvol3acc_R5968370f, X_idx_u1fastconvol3acc,
       "C_idx_u1fastconvol3acc", 0, 0) =
{
DH_FUNC (3),
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ), DH_UBYTE, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB idx-f1fastconvol4acc
 */
DH (X_idx_f1fastconvol4acc)
{
  dharg ret;
  ret.dh_char =
    C_idx_f1fastconvol4acc (a[1].dh_idx_ptr, a[2].dh_idx_ptr,
			    a[3].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC idx-f1fastconvol4acc
 */
DHDOC (K_idx_f1fastconvol4acc_R2ded5b58, X_idx_f1fastconvol4acc,
       "C_idx_f1fastconvol4acc", 0, 0) =
{
DH_FUNC (3),
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ),
    DH_FLT,
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ),
    DH_FLT,
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ), DH_FLT, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB idx-d1fastconvol4acc
 */
DH (X_idx_d1fastconvol4acc)
{
  dharg ret;
  ret.dh_char =
    C_idx_d1fastconvol4acc (a[1].dh_idx_ptr, a[2].dh_idx_ptr,
			    a[3].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC idx-d1fastconvol4acc
 */
DHDOC (K_idx_d1fastconvol4acc_R28bcf634, X_idx_d1fastconvol4acc,
       "C_idx_d1fastconvol4acc", 0, 0) =
{
DH_FUNC (3),
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ),
    DH_REAL,
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ),
    DH_REAL,
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ), DH_REAL, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB idx-u1fastconvol4acc
 */
DH (X_idx_u1fastconvol4acc)
{
  dharg ret;
  ret.dh_char =
    C_idx_u1fastconvol4acc (a[1].dh_idx_ptr, a[2].dh_idx_ptr,
			    a[3].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC idx-u1fastconvol4acc
 */
DHDOC (K_idx_u1fastconvol4acc_R5968370f, X_idx_u1fastconvol4acc,
       "C_idx_u1fastconvol4acc", 0, 0) =
{
DH_FUNC (3),
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ), DH_UBYTE, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB idx-f1fastconvol5acc
 */
DH (X_idx_f1fastconvol5acc)
{
  dharg ret;
  ret.dh_char =
    C_idx_f1fastconvol5acc (a[1].dh_idx_ptr, a[2].dh_idx_ptr,
			    a[3].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC idx-f1fastconvol5acc
 */
DHDOC (K_idx_f1fastconvol5acc_R2ded5b58, X_idx_f1fastconvol5acc,
       "C_idx_f1fastconvol5acc", 0, 0) =
{
DH_FUNC (3),
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ),
    DH_FLT,
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ),
    DH_FLT,
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ), DH_FLT, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB idx-d1fastconvol5acc
 */
DH (X_idx_d1fastconvol5acc)
{
  dharg ret;
  ret.dh_char =
    C_idx_d1fastconvol5acc (a[1].dh_idx_ptr, a[2].dh_idx_ptr,
			    a[3].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC idx-d1fastconvol5acc
 */
DHDOC (K_idx_d1fastconvol5acc_R28bcf634, X_idx_d1fastconvol5acc,
       "C_idx_d1fastconvol5acc", 0, 0) =
{
DH_FUNC (3),
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ),
    DH_REAL,
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ),
    DH_REAL,
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ), DH_REAL, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB idx-u1fastconvol5acc
 */
DH (X_idx_u1fastconvol5acc)
{
  dharg ret;
  ret.dh_char =
    C_idx_u1fastconvol5acc (a[1].dh_idx_ptr, a[2].dh_idx_ptr,
			    a[3].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC idx-u1fastconvol5acc
 */
DHDOC (K_idx_u1fastconvol5acc_R5968370f, X_idx_u1fastconvol5acc,
       "C_idx_u1fastconvol5acc", 0, 0) =
{
DH_FUNC (3),
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ), DH_UBYTE, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB idx-f1convol
 */
DH (X_idx_f1convol)
{
  dharg ret;
  ret.dh_idx_ptr =
    C_idx_f1convol (a[1].dh_idx_ptr, a[2].dh_idx_ptr, a[3].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC idx-f1convol
 */
DHDOC (K_idx_f1convol_R07e56038, X_idx_f1convol, "C_idx_f1convol", 0, 0) =
{
DH_FUNC (3),
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ),
    DH_FLT,
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ),
    DH_FLT,
    DH_IDX (DHT_WRITE, 1),
    DH_SRG (DHT_WRITE),
    DH_FLT,
    DH_RETURN,
    DH_IDX (DHT_WRITE, 1), DH_SRG (DHT_WRITE), DH_FLT, DH_END_FUNC, DH_NIL};

/*
 * STUB idx-d1convol
 */
DH (X_idx_d1convol)
{
  dharg ret;
  ret.dh_idx_ptr =
    C_idx_d1convol (a[1].dh_idx_ptr, a[2].dh_idx_ptr, a[3].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC idx-d1convol
 */
DHDOC (K_idx_d1convol_R828c1cb6, X_idx_d1convol, "C_idx_d1convol", 0, 0) =
{
DH_FUNC (3),
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ),
    DH_REAL,
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ),
    DH_REAL,
    DH_IDX (DHT_WRITE, 1),
    DH_SRG (DHT_WRITE),
    DH_REAL,
    DH_RETURN,
    DH_IDX (DHT_WRITE, 1), DH_SRG (DHT_WRITE), DH_REAL, DH_END_FUNC, DH_NIL};

/*
 * STUB idx-u1convol
 */
DH (X_idx_u1convol)
{
  dharg ret;
  ret.dh_idx_ptr =
    C_idx_u1convol (a[1].dh_idx_ptr, a[2].dh_idx_ptr, a[3].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC idx-u1convol
 */
DHDOC (K_idx_u1convol_R51503581, X_idx_u1convol, "C_idx_u1convol", 0, 0) =
{
DH_FUNC (3),
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_IDX (DHT_WRITE, 1),
    DH_SRG (DHT_WRITE),
    DH_UBYTE,
    DH_RETURN,
    DH_IDX (DHT_WRITE, 1), DH_SRG (DHT_WRITE), DH_UBYTE, DH_END_FUNC, DH_NIL};

/*
 * STUB idx-f1backconvol
 */
DH (X_idx_f1backconvol)
{
  dharg ret;
  ret.dh_idx_ptr =
    C_idx_f1backconvol (a[1].dh_idx_ptr, a[2].dh_idx_ptr, a[3].dh_idx_ptr,
			a[4].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC idx-f1backconvol
 */
DHDOC (K_idx_f1backconvol_R1898a557, X_idx_f1backconvol, "C_idx_f1backconvol",
       0, 0) =
{
DH_FUNC (3),
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ),
    DH_FLT,
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ),
    DH_FLT,
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_WRITE),
    DH_FLT,
    DH_TEMPS (1),
    DH_IDX (DHT_WRITE, 2), DH_FLT,
    DH_END_TEMPS,
    DH_RETURN,
    DH_IDX (DHT_WRITE, 2), DH_SRG (DHT_WRITE), DH_FLT, DH_END_FUNC, DH_NIL};

/*
 * STUB idx-d1backconvol
 */
DH (X_idx_d1backconvol)
{
  dharg ret;
  ret.dh_idx_ptr =
    C_idx_d1backconvol (a[1].dh_idx_ptr, a[2].dh_idx_ptr, a[3].dh_idx_ptr,
			a[4].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC idx-d1backconvol
 */
DHDOC (K_idx_d1backconvol_R07b07373, X_idx_d1backconvol, "C_idx_d1backconvol",
       0, 0) =
{
DH_FUNC (3),
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ),
    DH_REAL,
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ),
    DH_REAL,
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_WRITE),
    DH_REAL,
    DH_TEMPS (1),
    DH_IDX (DHT_WRITE, 2), DH_REAL,
    DH_END_TEMPS,
    DH_RETURN,
    DH_IDX (DHT_WRITE, 2), DH_SRG (DHT_WRITE), DH_REAL, DH_END_FUNC, DH_NIL};

/*
 * STUB idx-u1backconvol
 */
DH (X_idx_u1backconvol)
{
  dharg ret;
  ret.dh_idx_ptr =
    C_idx_u1backconvol (a[1].dh_idx_ptr, a[2].dh_idx_ptr, a[3].dh_idx_ptr,
			a[4].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC idx-u1backconvol
 */
DHDOC (K_idx_u1backconvol_Rf64c7d7a, X_idx_u1backconvol, "C_idx_u1backconvol",
       0, 0) =
{
DH_FUNC (3),
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_WRITE),
    DH_UBYTE,
    DH_TEMPS (1),
    DH_IDX (DHT_WRITE, 2), DH_UBYTE,
    DH_END_TEMPS,
    DH_RETURN,
    DH_IDX (DHT_WRITE, 2), DH_SRG (DHT_WRITE), DH_UBYTE, DH_END_FUNC, DH_NIL};

/*
 * STUB idx-f2convol
 */
DH (X_idx_f2convol)
{
  dharg ret;
  ret.dh_idx_ptr =
    C_idx_f2convol (a[1].dh_idx_ptr, a[2].dh_idx_ptr, a[3].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC idx-f2convol
 */
DHDOC (K_idx_f2convol_R07e56038, X_idx_f2convol, "C_idx_f2convol", 0, 0) =
{
DH_FUNC (3),
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_FLT,
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_FLT,
    DH_IDX (DHT_WRITE, 2),
    DH_SRG (DHT_WRITE),
    DH_FLT,
    DH_RETURN,
    DH_IDX (DHT_WRITE, 2), DH_SRG (DHT_WRITE), DH_FLT, DH_END_FUNC, DH_NIL};

/*
 * STUB idx-d2convol
 */
DH (X_idx_d2convol)
{
  dharg ret;
  ret.dh_idx_ptr =
    C_idx_d2convol (a[1].dh_idx_ptr, a[2].dh_idx_ptr, a[3].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC idx-d2convol
 */
DHDOC (K_idx_d2convol_R828c1cb6, X_idx_d2convol, "C_idx_d2convol", 0, 0) =
{
DH_FUNC (3),
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_REAL,
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_REAL,
    DH_IDX (DHT_WRITE, 2),
    DH_SRG (DHT_WRITE),
    DH_REAL,
    DH_RETURN,
    DH_IDX (DHT_WRITE, 2), DH_SRG (DHT_WRITE), DH_REAL, DH_END_FUNC, DH_NIL};

/*
 * STUB idx-u2convol
 */
DH (X_idx_u2convol)
{
  dharg ret;
  ret.dh_idx_ptr =
    C_idx_u2convol (a[1].dh_idx_ptr, a[2].dh_idx_ptr, a[3].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC idx-u2convol
 */
DHDOC (K_idx_u2convol_R51503581, X_idx_u2convol, "C_idx_u2convol", 0, 0) =
{
DH_FUNC (3),
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_IDX (DHT_WRITE, 2),
    DH_SRG (DHT_WRITE),
    DH_UBYTE,
    DH_RETURN,
    DH_IDX (DHT_WRITE, 2), DH_SRG (DHT_WRITE), DH_UBYTE, DH_END_FUNC, DH_NIL};

/*
 * STUB idx-f2convolacc
 */
DH (X_idx_f2convolacc)
{
  dharg ret;
  ret.dh_idx_ptr =
    C_idx_f2convolacc (a[1].dh_idx_ptr, a[2].dh_idx_ptr, a[3].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC idx-f2convolacc
 */
DHDOC (K_idx_f2convolacc_R07e56038, X_idx_f2convolacc, "C_idx_f2convolacc", 0,
       0) =
{
DH_FUNC (3),
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_FLT,
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_FLT,
    DH_IDX (DHT_WRITE, 2),
    DH_SRG (DHT_WRITE),
    DH_FLT,
    DH_RETURN,
    DH_IDX (DHT_WRITE, 2), DH_SRG (DHT_WRITE), DH_FLT, DH_END_FUNC, DH_NIL};

/*
 * STUB idx-d2convolacc
 */
DH (X_idx_d2convolacc)
{
  dharg ret;
  ret.dh_idx_ptr =
    C_idx_d2convolacc (a[1].dh_idx_ptr, a[2].dh_idx_ptr, a[3].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC idx-d2convolacc
 */
DHDOC (K_idx_d2convolacc_R828c1cb6, X_idx_d2convolacc, "C_idx_d2convolacc", 0,
       0) =
{
DH_FUNC (3),
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_REAL,
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_REAL,
    DH_IDX (DHT_WRITE, 2),
    DH_SRG (DHT_WRITE),
    DH_REAL,
    DH_RETURN,
    DH_IDX (DHT_WRITE, 2), DH_SRG (DHT_WRITE), DH_REAL, DH_END_FUNC, DH_NIL};

/*
 * STUB idx-u2convolacc
 */
DH (X_idx_u2convolacc)
{
  dharg ret;
  ret.dh_idx_ptr =
    C_idx_u2convolacc (a[1].dh_idx_ptr, a[2].dh_idx_ptr, a[3].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC idx-u2convolacc
 */
DHDOC (K_idx_u2convolacc_R51503581, X_idx_u2convolacc, "C_idx_u2convolacc", 0,
       0) =
{
DH_FUNC (3),
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_IDX (DHT_WRITE, 2),
    DH_SRG (DHT_WRITE),
    DH_UBYTE,
    DH_RETURN,
    DH_IDX (DHT_WRITE, 2), DH_SRG (DHT_WRITE), DH_UBYTE, DH_END_FUNC, DH_NIL};

/*
 * STUB idx-f2backconvol
 */
DH (X_idx_f2backconvol)
{
  dharg ret;
  ret.dh_idx_ptr =
    C_idx_f2backconvol (a[1].dh_idx_ptr, a[2].dh_idx_ptr, a[3].dh_idx_ptr,
			a[4].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC idx-f2backconvol
 */
DHDOC (K_idx_f2backconvol_R1898a557, X_idx_f2backconvol, "C_idx_f2backconvol",
       0, 0) =
{
DH_FUNC (3),
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_FLT,
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_FLT,
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_WRITE),
    DH_FLT,
    DH_TEMPS (1),
    DH_IDX (DHT_WRITE, 4), DH_FLT,
    DH_END_TEMPS,
    DH_RETURN,
    DH_IDX (DHT_WRITE, 4), DH_SRG (DHT_WRITE), DH_FLT, DH_END_FUNC, DH_NIL};

/*
 * STUB idx-d2backconvol
 */
DH (X_idx_d2backconvol)
{
  dharg ret;
  ret.dh_idx_ptr =
    C_idx_d2backconvol (a[1].dh_idx_ptr, a[2].dh_idx_ptr, a[3].dh_idx_ptr,
			a[4].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC idx-d2backconvol
 */
DHDOC (K_idx_d2backconvol_R07b07373, X_idx_d2backconvol, "C_idx_d2backconvol",
       0, 0) =
{
DH_FUNC (3),
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_REAL,
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_REAL,
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_WRITE),
    DH_REAL,
    DH_TEMPS (1),
    DH_IDX (DHT_WRITE, 4), DH_REAL,
    DH_END_TEMPS,
    DH_RETURN,
    DH_IDX (DHT_WRITE, 4), DH_SRG (DHT_WRITE), DH_REAL, DH_END_FUNC, DH_NIL};

/*
 * STUB idx-u2backconvol
 */
DH (X_idx_u2backconvol)
{
  dharg ret;
  ret.dh_idx_ptr =
    C_idx_u2backconvol (a[1].dh_idx_ptr, a[2].dh_idx_ptr, a[3].dh_idx_ptr,
			a[4].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC idx-u2backconvol
 */
DHDOC (K_idx_u2backconvol_Rf64c7d7a, X_idx_u2backconvol, "C_idx_u2backconvol",
       0, 0) =
{
DH_FUNC (3),
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_WRITE),
    DH_UBYTE,
    DH_TEMPS (1),
    DH_IDX (DHT_WRITE, 4), DH_UBYTE,
    DH_END_TEMPS,
    DH_RETURN,
    DH_IDX (DHT_WRITE, 4), DH_SRG (DHT_WRITE), DH_UBYTE, DH_END_FUNC, DH_NIL};

/*
 * STUB idx-f2backconvolacc
 */
DH (X_idx_f2backconvolacc)
{
  dharg ret;
  ret.dh_idx_ptr =
    C_idx_f2backconvolacc (a[1].dh_idx_ptr, a[2].dh_idx_ptr, a[3].dh_idx_ptr,
			   a[4].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC idx-f2backconvolacc
 */
DHDOC (K_idx_f2backconvolacc_R1898a557, X_idx_f2backconvolacc,
       "C_idx_f2backconvolacc", 0, 0) =
{
DH_FUNC (3),
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_FLT,
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_FLT,
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_WRITE),
    DH_FLT,
    DH_TEMPS (1),
    DH_IDX (DHT_WRITE, 4), DH_FLT,
    DH_END_TEMPS,
    DH_RETURN,
    DH_IDX (DHT_WRITE, 4), DH_SRG (DHT_WRITE), DH_FLT, DH_END_FUNC, DH_NIL};

/*
 * STUB idx-d2backconvolacc
 */
DH (X_idx_d2backconvolacc)
{
  dharg ret;
  ret.dh_idx_ptr =
    C_idx_d2backconvolacc (a[1].dh_idx_ptr, a[2].dh_idx_ptr, a[3].dh_idx_ptr,
			   a[4].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC idx-d2backconvolacc
 */
DHDOC (K_idx_d2backconvolacc_R07b07373, X_idx_d2backconvolacc,
       "C_idx_d2backconvolacc", 0, 0) =
{
DH_FUNC (3),
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_REAL,
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_REAL,
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_WRITE),
    DH_REAL,
    DH_TEMPS (1),
    DH_IDX (DHT_WRITE, 4), DH_REAL,
    DH_END_TEMPS,
    DH_RETURN,
    DH_IDX (DHT_WRITE, 4), DH_SRG (DHT_WRITE), DH_REAL, DH_END_FUNC, DH_NIL};

/*
 * STUB idx-u2backconvolacc
 */
DH (X_idx_u2backconvolacc)
{
  dharg ret;
  ret.dh_idx_ptr =
    C_idx_u2backconvolacc (a[1].dh_idx_ptr, a[2].dh_idx_ptr, a[3].dh_idx_ptr,
			   a[4].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC idx-u2backconvolacc
 */
DHDOC (K_idx_u2backconvolacc_Rf64c7d7a, X_idx_u2backconvolacc,
       "C_idx_u2backconvolacc", 0, 0) =
{
DH_FUNC (3),
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_WRITE),
    DH_UBYTE,
    DH_TEMPS (1),
    DH_IDX (DHT_WRITE, 4), DH_UBYTE,
    DH_END_TEMPS,
    DH_RETURN,
    DH_IDX (DHT_WRITE, 4), DH_SRG (DHT_WRITE), DH_UBYTE, DH_END_FUNC, DH_NIL};

/*
 * STUB idx-f1subsample
 */
DH (X_idx_f1subsample)
{
  dharg ret;
  ret.dh_idx_ptr =
    C_idx_f1subsample (a[1].dh_idx_ptr, a[2].dh_int, a[3].dh_idx_ptr,
		       a[4].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC idx-f1subsample
 */
DHDOC (K_idx_f1subsample_R13197d4f, X_idx_f1subsample, "C_idx_f1subsample", 0,
       0) =
{
DH_FUNC (3),
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ),
    DH_FLT,
    DH_INT,
    DH_IDX (DHT_WRITE, 1),
    DH_SRG (DHT_WRITE),
    DH_FLT,
    DH_TEMPS (1),
    DH_IDX (DHT_WRITE, 2), DH_FLT,
    DH_END_TEMPS,
    DH_RETURN,
    DH_IDX (DHT_READ, 2), DH_SRG (DHT_READ), DH_FLT, DH_END_FUNC, DH_NIL};

/*
 * STUB idx-d1subsample
 */
DH (X_idx_d1subsample)
{
  dharg ret;
  ret.dh_idx_ptr =
    C_idx_d1subsample (a[1].dh_idx_ptr, a[2].dh_int, a[3].dh_idx_ptr,
		       a[4].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC idx-d1subsample
 */
DHDOC (K_idx_d1subsample_R0fbcb543, X_idx_d1subsample, "C_idx_d1subsample", 0,
       0) =
{
DH_FUNC (3),
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ),
    DH_REAL,
    DH_INT,
    DH_IDX (DHT_WRITE, 1),
    DH_SRG (DHT_WRITE),
    DH_REAL,
    DH_TEMPS (1),
    DH_IDX (DHT_WRITE, 2), DH_REAL,
    DH_END_TEMPS,
    DH_RETURN,
    DH_IDX (DHT_READ, 2), DH_SRG (DHT_READ), DH_REAL, DH_END_FUNC, DH_NIL};

/*
 * STUB idx-u1subsample
 */
DH (X_idx_u1subsample)
{
  dharg ret;
  ret.dh_idx_ptr =
    C_idx_u1subsample (a[1].dh_idx_ptr, a[2].dh_int, a[3].dh_idx_ptr,
		       a[4].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC idx-u1subsample
 */
DHDOC (K_idx_u1subsample_Rdece3b80, X_idx_u1subsample, "C_idx_u1subsample", 0,
       0) =
{
DH_FUNC (3),
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_INT,
    DH_IDX (DHT_WRITE, 1),
    DH_SRG (DHT_WRITE),
    DH_UBYTE,
    DH_TEMPS (1),
    DH_IDX (DHT_WRITE, 2), DH_UBYTE,
    DH_END_TEMPS,
    DH_RETURN,
    DH_IDX (DHT_READ, 2), DH_SRG (DHT_READ), DH_UBYTE, DH_END_FUNC, DH_NIL};

/*
 * STUB idx-f1oversample
 */
DH (X_idx_f1oversample)
{
  dharg ret;
  ret.dh_char =
    C_idx_f1oversample (a[1].dh_idx_ptr, a[2].dh_int, a[3].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC idx-f1oversample
 */
DHDOC (K_idx_f1oversample_R266c8340, X_idx_f1oversample, "C_idx_f1oversample",
       0, 0) =
{
DH_FUNC (3),
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ),
    DH_FLT,
    DH_INT,
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ), DH_FLT, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB idx-d1oversample
 */
DH (X_idx_d1oversample)
{
  dharg ret;
  ret.dh_char =
    C_idx_d1oversample (a[1].dh_idx_ptr, a[2].dh_int, a[3].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC idx-d1oversample
 */
DHDOC (K_idx_d1oversample_R20b03004, X_idx_d1oversample, "C_idx_d1oversample",
       0, 0) =
{
DH_FUNC (3),
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ),
    DH_REAL,
    DH_INT,
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ), DH_REAL, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB idx-u1oversample
 */
DH (X_idx_u1oversample)
{
  dharg ret;
  ret.dh_char =
    C_idx_u1oversample (a[1].dh_idx_ptr, a[2].dh_int, a[3].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC idx-u1oversample
 */
DHDOC (K_idx_u1oversample_R71ea71f5, X_idx_u1oversample, "C_idx_u1oversample",
       0, 0) =
{
DH_FUNC (3),
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_INT,
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ), DH_UBYTE, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB idx-f2subsample
 */
DH (X_idx_f2subsample)
{
  dharg ret;
  ret.dh_char =
    C_idx_f2subsample (a[1].dh_idx_ptr, a[2].dh_int, a[3].dh_int,
		       a[4].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC idx-f2subsample
 */
DHDOC (K_idx_f2subsample_Re421fe62, X_idx_f2subsample, "C_idx_f2subsample", 0,
       0) =
{
DH_FUNC (4),
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_FLT,
    DH_INT,
    DH_INT,
    DH_IDX (DHT_WRITE, 2),
    DH_SRG (DHT_WRITE), DH_FLT, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB idx-d2subsample
 */
DH (X_idx_d2subsample)
{
  dharg ret;
  ret.dh_char =
    C_idx_d2subsample (a[1].dh_idx_ptr, a[2].dh_int, a[3].dh_int,
		       a[4].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC idx-d2subsample
 */
DHDOC (K_idx_d2subsample_Rebd309d6, X_idx_d2subsample, "C_idx_d2subsample", 0,
       0) =
{
DH_FUNC (4),
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_REAL,
    DH_INT,
    DH_INT,
    DH_IDX (DHT_WRITE, 2),
    DH_SRG (DHT_WRITE), DH_REAL, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB idx-u2subsample
 */
DH (X_idx_u2subsample)
{
  dharg ret;
  ret.dh_char =
    C_idx_u2subsample (a[1].dh_idx_ptr, a[2].dh_int, a[3].dh_int,
		       a[4].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC idx-u2subsample
 */
DHDOC (K_idx_u2subsample_R79ae4a9b, X_idx_u2subsample, "C_idx_u2subsample", 0,
       0) =
{
DH_FUNC (4),
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_INT,
    DH_INT,
    DH_IDX (DHT_WRITE, 2),
    DH_SRG (DHT_WRITE), DH_UBYTE, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB idx-f2oversample
 */
DH (X_idx_f2oversample)
{
  dharg ret;
  ret.dh_char =
    C_idx_f2oversample (a[1].dh_idx_ptr, a[2].dh_int, a[3].dh_int,
			a[4].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC idx-f2oversample
 */
DHDOC (K_idx_f2oversample_Re421fe62, X_idx_f2oversample, "C_idx_f2oversample",
       0, 0) =
{
DH_FUNC (4),
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_FLT,
    DH_INT,
    DH_INT,
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ), DH_FLT, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB idx-d2oversample
 */
DH (X_idx_d2oversample)
{
  dharg ret;
  ret.dh_char =
    C_idx_d2oversample (a[1].dh_idx_ptr, a[2].dh_int, a[3].dh_int,
			a[4].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC idx-d2oversample
 */
DHDOC (K_idx_d2oversample_Rebd309d6, X_idx_d2oversample, "C_idx_d2oversample",
       0, 0) =
{
DH_FUNC (4),
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_REAL,
    DH_INT,
    DH_INT,
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ), DH_REAL, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB idx-u2oversample
 */
DH (X_idx_u2oversample)
{
  dharg ret;
  ret.dh_char =
    C_idx_u2oversample (a[1].dh_idx_ptr, a[2].dh_int, a[3].dh_int,
			a[4].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC idx-u2oversample
 */
DHDOC (K_idx_u2oversample_R79ae4a9b, X_idx_u2oversample, "C_idx_u2oversample",
       0, 0) =
{
DH_FUNC (4),
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_INT,
    DH_INT,
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ), DH_UBYTE, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * INIT FUNCTION
 */
extern_c void
init_idx_convol (void)
{
  dh_define ("error-notcontiguous", &K_error_notcontiguous_Ra8b05737);
  dh_define ("idx-m1fastconvol-check", &K_idx_m1fastconvol_check_Rcfe6720e);
  dh_define ("idx-f1fastconvol2acc", &K_idx_f1fastconvol2acc_R2ded5b58);
  dh_define ("idx-d1fastconvol2acc", &K_idx_d1fastconvol2acc_R28bcf634);
  dh_define ("idx-u1fastconvol2acc", &K_idx_u1fastconvol2acc_R5968370f);
  dh_define ("idx-f1fastconvol3acc", &K_idx_f1fastconvol3acc_R2ded5b58);
  dh_define ("idx-d1fastconvol3acc", &K_idx_d1fastconvol3acc_R28bcf634);
  dh_define ("idx-u1fastconvol3acc", &K_idx_u1fastconvol3acc_R5968370f);
  dh_define ("idx-f1fastconvol4acc", &K_idx_f1fastconvol4acc_R2ded5b58);
  dh_define ("idx-d1fastconvol4acc", &K_idx_d1fastconvol4acc_R28bcf634);
  dh_define ("idx-u1fastconvol4acc", &K_idx_u1fastconvol4acc_R5968370f);
  dh_define ("idx-f1fastconvol5acc", &K_idx_f1fastconvol5acc_R2ded5b58);
  dh_define ("idx-d1fastconvol5acc", &K_idx_d1fastconvol5acc_R28bcf634);
  dh_define ("idx-u1fastconvol5acc", &K_idx_u1fastconvol5acc_R5968370f);
  dh_define ("idx-f1convol", &K_idx_f1convol_R07e56038);
  dh_define ("idx-d1convol", &K_idx_d1convol_R828c1cb6);
  dh_define ("idx-u1convol", &K_idx_u1convol_R51503581);
  dh_define ("idx-f1backconvol", &K_idx_f1backconvol_R1898a557);
  dh_define ("idx-d1backconvol", &K_idx_d1backconvol_R07b07373);
  dh_define ("idx-u1backconvol", &K_idx_u1backconvol_Rf64c7d7a);
  dh_define ("idx-f2convol", &K_idx_f2convol_R07e56038);
  dh_define ("idx-d2convol", &K_idx_d2convol_R828c1cb6);
  dh_define ("idx-u2convol", &K_idx_u2convol_R51503581);
  dh_define ("idx-f2convolacc", &K_idx_f2convolacc_R07e56038);
  dh_define ("idx-d2convolacc", &K_idx_d2convolacc_R828c1cb6);
  dh_define ("idx-u2convolacc", &K_idx_u2convolacc_R51503581);
  dh_define ("idx-f2backconvol", &K_idx_f2backconvol_R1898a557);
  dh_define ("idx-d2backconvol", &K_idx_d2backconvol_R07b07373);
  dh_define ("idx-u2backconvol", &K_idx_u2backconvol_Rf64c7d7a);
  dh_define ("idx-f2backconvolacc", &K_idx_f2backconvolacc_R1898a557);
  dh_define ("idx-d2backconvolacc", &K_idx_d2backconvolacc_R07b07373);
  dh_define ("idx-u2backconvolacc", &K_idx_u2backconvolacc_Rf64c7d7a);
  dh_define ("idx-f1subsample", &K_idx_f1subsample_R13197d4f);
  dh_define ("idx-d1subsample", &K_idx_d1subsample_R0fbcb543);
  dh_define ("idx-u1subsample", &K_idx_u1subsample_Rdece3b80);
  dh_define ("idx-f1oversample", &K_idx_f1oversample_R266c8340);
  dh_define ("idx-d1oversample", &K_idx_d1oversample_R20b03004);
  dh_define ("idx-u1oversample", &K_idx_u1oversample_R71ea71f5);
  dh_define ("idx-f2subsample", &K_idx_f2subsample_Re421fe62);
  dh_define ("idx-d2subsample", &K_idx_d2subsample_Rebd309d6);
  dh_define ("idx-u2subsample", &K_idx_u2subsample_R79ae4a9b);
  dh_define ("idx-f2oversample", &K_idx_f2oversample_Re421fe62);
  dh_define ("idx-d2oversample", &K_idx_d2oversample_Rebd309d6);
  dh_define ("idx-u2oversample", &K_idx_u2oversample_R79ae4a9b);
}

int majver_idx_convol = 40;
int minver_idx_convol = 10;

#endif
