/*
 * Object-Oriented Programming
 * Copyright (C) 2012 Robert Grimm
 * Modifications Copyright (C) 2013 Thomas Wies
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301,
 * USA.
 */

#include "ptr.h"

#include <iostream>

template<typename T>
__rt::Ptr<T> id(__rt::Ptr<T> p) {
  TRACE("return");     return p;
}

int main(void) {
  TRACE("declaration of p");    __rt::Ptr<int> p(new int(5));
  TRACE("declaration of q");    __rt::Ptr<int> q = id(p);
  TRACE("assigning q to p");    p = q;
  TRACE("print content of p");  std::cout << *p << std::endl;
  TRACE("delete content of q"); delete q;
  TRACE("return");              return 0;
}
