/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar;

import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LAAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LAEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.MutableAffinTerm;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class AnnotationToProofTerm {
    private static final Annotation TRICHOTOMY = new Annotation(":trichotomy", null);

    private Rational computeGcd(LAAnnotation annot) {
        Rational gcd = null;
        Iterator<Rational> it = annot.getCoefficients().values().iterator();
        if (it.hasNext()) {
            gcd = it.next();
        }
        while (it.hasNext()) {
            gcd = gcd.gcd(it.next());
        }
        it = annot.getAuxAnnotations().values().iterator();
        if (gcd == null && it.hasNext()) {
            gcd = it.next();
        }
        while (it.hasNext()) {
            gcd = gcd.gcd(it.next());
        }
        assert (gcd != null);
        return gcd;
    }

    private void computeLiterals(LAAnnotation annot, Theory theory, AnnotationInfo info) {
        MutableAffinTerm at = new MutableAffinTerm();
        at.add(Rational.ONE, annot.getLinVar());
        at.add(annot.getBound().negate());
        if (!annot.isUpper()) {
            at.add(annot.getLinVar().getEpsilon());
        }
        Term posTerm = at.toSMTLibLeq0(theory, true);
        if (annot.isUpper()) {
            info.mLiteral = posTerm;
            info.mNegLiteral = theory.term("not", posTerm);
        } else {
            info.mLiteral = theory.term("not", posTerm);
            info.mNegLiteral = posTerm;
        }
    }

    public Term convert(LAAnnotation parent, Theory theory) {
        assert (parent.getLinVar() == null);
        HashMap<LAAnnotation, AnnotationInfo> infos = new HashMap<LAAnnotation, AnnotationInfo>();
        ArrayDeque<LAAnnotation> todo = new ArrayDeque<LAAnnotation>();
        todo.add(parent);
        while (!todo.isEmpty()) {
            LAAnnotation annot = (LAAnnotation)todo.removeFirst();
            AnnotationInfo info = (AnnotationInfo)infos.get(annot);
            if (info == null) {
                info = new AnnotationInfo();
                infos.put(annot, info);
                if (annot.getLinVar() != null) {
                    this.computeLiterals(annot, theory, info);
                }
                todo.addAll(annot.getAuxAnnotations().keySet());
            }
            ++info.mCount;
        }
        ArrayDeque<ApplicationTerm> antes = new ArrayDeque<ApplicationTerm>();
        todo.add(parent);
        while (!todo.isEmpty()) {
            LAAnnotation annot = (LAAnnotation)todo.removeFirst();
            AnnotationInfo info = (AnnotationInfo)infos.get(annot);
            ++info.mVisited;
            if (info.mVisited < info.mCount) continue;
            todo.addAll(annot.getAuxAnnotations().keySet());
            Rational gcd = this.computeGcd(annot);
            int numdisjs = annot.getCoefficients().size() + annot.getAuxAnnotations().size() + (info.mLiteral == null ? 0 : 1);
            int i = 0;
            Term[] disjs = new Term[numdisjs];
            Term[] coeffs = new Term[numdisjs];
            if (info.mLiteral != null) {
                Rational sign = annot.isUpper() ? Rational.MONE : Rational.ONE;
                disjs[i] = info.mLiteral;
                coeffs[i] = sign.div(gcd).toTerm(this.getSort(theory));
                ++i;
            }
            boolean trichotomy = false;
            for (Map.Entry<Literal, Rational> entry : annot.getCoefficients().entrySet()) {
                Literal lit = entry.getKey();
                if (lit instanceof LAEquality) {
                    trichotomy = true;
                }
                disjs[i] = entry.getKey().getSMTFormula(theory, true);
                coeffs[i] = entry.getValue().div(gcd).toTerm(this.getSort(theory));
                ++i;
            }
            for (Map.Entry<Object, Rational> entry : annot.getAuxAnnotations().entrySet()) {
                AnnotationInfo auxInfo = (AnnotationInfo)infos.get(entry.getKey());
                disjs[i] = auxInfo.mNegLiteral;
                coeffs[i] = entry.getValue().div(gcd).toTerm(this.getSort(theory));
                ++i;
            }
            if (disjs.length == 2 && disjs[1] == info.mNegLiteral) continue;
            Term proofAnnot = theory.term(theory.mOr, disjs);
            Annotation[] annotationArray = new Annotation[]{trichotomy ? TRICHOTOMY : new Annotation(":LA", coeffs)};
            proofAnnot = theory.annotatedTerm(annotationArray, proofAnnot);
            proofAnnot = theory.term("@lemma", proofAnnot);
            if (!antes.isEmpty()) {
                assert (info.mLiteral != null);
                proofAnnot = theory.annotatedTerm(new Annotation[]{new Annotation(":pivot", info.mLiteral)}, proofAnnot);
            }
            antes.add((ApplicationTerm)proofAnnot);
        }
        if (antes.size() == 1) {
            return (Term)antes.getFirst();
        }
        return theory.term("@res", antes.toArray(new Term[antes.size()]));
    }

    private Sort getSort(Theory t) {
        Sort res = t.getSort("Int", new Sort[0]);
        return res == null ? t.getSort("Real", new Sort[0]) : res;
    }

    class AnnotationInfo {
        int mCount;
        int mVisited;
        Term mLiteral;
        Term mNegLiteral;

        AnnotationInfo() {
        }
    }
}

