/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure;

import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.LeafNode;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCAppTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CClosure;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.SymmetricPair;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class CongruencePath {
    final CClosure mClosure;
    final HashMap<SymmetricPair<CCTerm>, SubPath> mVisited;
    final ArrayDeque<SubPath> mAllPaths;
    final Set<Literal> mAllLiterals;

    public CongruencePath(CClosure closure) {
        this.mClosure = closure;
        this.mVisited = new HashMap();
        this.mAllLiterals = new HashSet<Literal>();
        this.mAllPaths = new ArrayDeque();
    }

    private CCAnnotation createAnnotation(CCEquality diseq) {
        return new CCAnnotation(diseq, this.mAllPaths);
    }

    private int computeDepth(CCTerm t) {
        int depth = 0;
        while (t.mEqualEdge != null) {
            t = t.mEqualEdge;
            ++depth;
        }
        return depth;
    }

    private void computeCCPath(CCAppTerm start, CCAppTerm end) {
        while (true) {
            SubPath path;
            if ((path = this.computePath(start.mArg, end.mArg)) != null) {
                this.mAllPaths.addFirst(path);
            }
            if (start.mFunc == end.mFunc) break;
            start = (CCAppTerm)start.mFunc;
            end = (CCAppTerm)end.mFunc;
        }
    }

    private SubPath computePathTo(CCTerm t, CCTerm end) {
        SubPath path = new SubPath(t, this.mClosure.mEngine.isProofGenerationEnabled());
        CCTerm startCongruence = t;
        while (t != end) {
            if (t.mOldRep.mReasonLiteral != null) {
                if (startCongruence != t) {
                    this.computeCCPath((CCAppTerm)startCongruence, (CCAppTerm)t);
                    path.addEntry(t, null);
                }
                path.addEntry(t.mEqualEdge, t.mOldRep.mReasonLiteral);
                this.mAllLiterals.add(t.mOldRep.mReasonLiteral);
                startCongruence = t.mEqualEdge;
            }
            t = t.mEqualEdge;
        }
        assert (startCongruence == t);
        return path;
    }

    public SubPath computePath(CCTerm left, CCTerm right) {
        int leftDepth;
        if (left == right) {
            return null;
        }
        SymmetricPair<CCTerm> key = new SymmetricPair<CCTerm>(left, right);
        if (this.mVisited.containsKey(key)) {
            return this.mVisited.get(key);
        }
        int rightDepth = this.computeDepth(right);
        CCTerm ll = left;
        CCTerm rr = right;
        CCTerm llWithReason = ll;
        CCTerm rrWithReason = rr;
        for (leftDepth = this.computeDepth(left); leftDepth > rightDepth; --leftDepth) {
            if (ll.mOldRep.mReasonLiteral != null) {
                llWithReason = ll.mEqualEdge;
            }
            ll = ll.mEqualEdge;
        }
        while (rightDepth > leftDepth) {
            if (rr.mOldRep.mReasonLiteral != null) {
                rrWithReason = rr.mEqualEdge;
            }
            rr = rr.mEqualEdge;
            --rightDepth;
        }
        while (ll != rr) {
            if (ll.mOldRep.mReasonLiteral != null) {
                llWithReason = ll.mEqualEdge;
            }
            if (rr.mOldRep.mReasonLiteral != null) {
                rrWithReason = rr.mEqualEdge;
            }
            ll = ll.mEqualEdge;
            rr = rr.mEqualEdge;
        }
        assert (ll != null);
        SubPath path = this.computePathTo(left, llWithReason);
        if (llWithReason != rrWithReason) {
            this.computeCCPath((CCAppTerm)llWithReason, (CCAppTerm)rrWithReason);
            path.addEntry(rrWithReason, null);
        }
        SubPath pathBack = this.computePathTo(right, rrWithReason);
        path.addSubPath(pathBack);
        this.mVisited.put(key, path);
        return path;
    }

    public Clause computeCycle(CCEquality eq, boolean produceProofs) {
        SubPath path = this.computePath(eq.getLhs(), eq.getRhs());
        this.mAllPaths.addFirst(path);
        Literal[] cycle = new Literal[this.mAllLiterals.size() + 1];
        int i = 0;
        cycle[i++] = eq;
        for (Literal l : this.mAllLiterals) {
            cycle[i++] = l.negate();
        }
        Clause c = new Clause(cycle);
        if (produceProofs) {
            c.setProof(new LeafNode(-3, this.createAnnotation(eq)));
        }
        return c;
    }

    public Clause computeCycle(CCTerm lconstant, CCTerm rconstant, boolean produceProofs) {
        this.mClosure.mEngine.getLogger().debug("computeCycle for Constants");
        SubPath path = this.computePath(lconstant, rconstant);
        this.mAllPaths.addFirst(path);
        Literal[] cycle = new Literal[this.mAllLiterals.size()];
        int i = 0;
        for (Literal l : this.mAllLiterals) {
            cycle[i++] = l.negate();
        }
        Clause c = new Clause(cycle);
        if (produceProofs) {
            c.setProof(new LeafNode(-3, this.createAnnotation(null)));
        }
        return c;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CongruencePath[");
        sb.append(this.mAllLiterals.toString());
        sb.append(']');
        return sb.toString();
    }

    public static class SubPath {
        ArrayList<CCTerm> mTermsOnPath;

        public SubPath(CCTerm start) {
            this(start, true);
        }

        public SubPath(CCTerm start, boolean produceProofs) {
            if (produceProofs) {
                this.mTermsOnPath = new ArrayList();
                this.mTermsOnPath.add(start);
            }
        }

        public CCTerm[] getTerms() {
            return this.mTermsOnPath.toArray(new CCTerm[this.mTermsOnPath.size()]);
        }

        public void addEntry(CCTerm term, CCEquality reason) {
            if (this.mTermsOnPath != null) {
                this.mTermsOnPath.add(term);
            }
        }

        public void addSubPath(SubPath second) {
            block5: {
                if (this.mTermsOnPath == null || second == null) break block5;
                if (second.mTermsOnPath.get(0) == this.mTermsOnPath.get(this.mTermsOnPath.size() - 1)) {
                    for (int i = 1; i < second.mTermsOnPath.size(); ++i) {
                        this.mTermsOnPath.add(second.mTermsOnPath.get(i));
                    }
                } else {
                    assert (second.mTermsOnPath.get(second.mTermsOnPath.size() - 1) == this.mTermsOnPath.get(this.mTermsOnPath.size() - 1));
                    for (int i = second.mTermsOnPath.size() - 2; i >= 0; --i) {
                        this.mTermsOnPath.add(second.mTermsOnPath.get(i));
                    }
                }
            }
        }

        public String toString() {
            return this.mTermsOnPath.toString();
        }
    }
}

