/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.model;

import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.SMTAffineTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.SharedTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LinArSolve;

public class SharedTermEvaluator {
    private final LinArSolve mLa;

    public SharedTermEvaluator(LinArSolve la) {
        this.mLa = la;
    }

    public Rational evaluate(SharedTerm st, Theory t) {
        if (st.validShared()) {
            if (st.getLinVar() == null) {
                SMTAffineTerm sat = SMTAffineTerm.create(st.getTerm());
                assert (sat.isConstant());
                return sat.getConstant();
            }
            Rational val = st.getFactor().mul(this.mLa.realValue(st.getLinVar())).add(st.getOffset());
            return val;
        }
        throw new InternalError("Not a valid shared term: " + st.getTerm());
    }
}

