/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.convert;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.NonRecursive;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.InternTermTransformer;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.SMTAffineTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.Utils;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.NoopProofTracker;
import java.util.HashMap;
import java.util.Map;

public class EqualityDestructor
extends NonRecursive {
    private final Map<TermVariable, Term> mEqs = new HashMap<TermVariable, Term>();

    public Term destruct(Term qbody) {
        this.run(new SearchEqualities(qbody));
        return new InternTermTransformer(){
            Utils mUtils = new Utils(new NoopProofTracker());

            protected void convert(Term term) {
                Term replacement;
                if (term instanceof TermVariable && (replacement = (Term)EqualityDestructor.this.mEqs.get(term)) != null) {
                    this.setResult(replacement);
                    return;
                }
                super.convert(term);
            }

            public void convertApplicationTerm(ApplicationTerm appTerm, Term[] newArgs) {
                if (newArgs == appTerm.getParameters()) {
                    this.setResult(appTerm);
                } else {
                    Theory t = appTerm.getTheory();
                    if (appTerm.getFunction() == t.mNot) {
                        this.setResult(this.mUtils.createNot(newArgs[0]));
                    } else if (appTerm.getFunction() == t.mOr) {
                        this.setResult(this.mUtils.createOr(newArgs));
                    } else if (appTerm.getFunction().getName().equals("=")) {
                        this.setResult(this.mUtils.createEq(newArgs));
                    } else if (appTerm.getFunction().getName().equals("<=")) {
                        this.setResult(this.mUtils.createLeq0((SMTAffineTerm)newArgs[0]));
                    } else if (appTerm.getFunction().getName().equals("ite")) {
                        this.setResult(this.mUtils.createIte(newArgs[0], newArgs[1], newArgs[2]));
                    } else {
                        assert (!appTerm.getFunction().isIntern());
                        this.setResult(t.term(appTerm.getFunction(), newArgs));
                    }
                }
            }
        }.transform(qbody);
    }

    private static final class SearchEqualities
    implements NonRecursive.Walker {
        private Term mTerm;
        private boolean mPositive;

        public SearchEqualities(Term term) {
            this(term, true);
        }

        public SearchEqualities(Term term, boolean positive) {
            this.mTerm = term;
            this.mPositive = positive;
        }

        public void walk(NonRecursive engine) {
            if (this.mTerm instanceof ApplicationTerm) {
                ApplicationTerm at = (ApplicationTerm)this.mTerm;
                if (at.getFunction() == at.getTheory().mNot) {
                    engine.enqueueWalker(new SearchEqualities(at.getParameters()[0], !this.mPositive));
                } else if (!this.mPositive && at.getFunction() == at.getTheory().mOr) {
                    for (Term t : at.getParameters()) {
                        engine.enqueueWalker(new SearchEqualities(t, false));
                    }
                } else if (at.getFunction().getName().equals("=")) {
                    Term[] args = at.getParameters();
                    assert (args.length == 2);
                    EqualityDestructor ed = (EqualityDestructor)engine;
                    if (args[0] instanceof TermVariable) {
                        TermVariable v0 = (TermVariable)args[0];
                        if (args[1] instanceof TermVariable) {
                            TermVariable v1 = (TermVariable)args[1];
                            if (ed.mEqs.containsKey(v0)) {
                                if (ed.mEqs.containsKey(v1)) {
                                    return;
                                }
                                ed.mEqs.put(v1, ed.mEqs.get(v0));
                            } else if (ed.mEqs.containsKey(v1)) {
                                ed.mEqs.put(v0, ed.mEqs.get(v1));
                            } else {
                                ed.mEqs.put(v1, v0);
                            }
                        } else {
                            this.checkVariable(ed, v0, args[1]);
                        }
                    } else if (args[1] instanceof TermVariable) {
                        TermVariable v1 = (TermVariable)args[1];
                        this.checkVariable(ed, v1, args[0]);
                    }
                }
            }
        }

        private void checkVariable(EqualityDestructor ed, TermVariable var, Term val) {
            TermVariable[] freeVars;
            for (TermVariable v : freeVars = SMTAffineTerm.cleanup(val).getFreeVars()) {
                if (v != var) continue;
                return;
            }
            if (!ed.mEqs.containsKey(var)) {
                ed.mEqs.put(var, val);
            }
        }
    }
}

