fun fib(n) =
  if n <= 1 then n else fib(n-1) + fib(n-2)

fun fib(n) =
  if n <= 1 then n
  else
  let
    val (a, b) = ForkJoin.par (fn () => fib(n-1),
                               fn () => fib(n-2))
  in
    a + b
  end

(* f(x) = x^2 + 2x ... *)

(* fib(0) = 0
 * fib(1) = 1
 * fib(2) = 1
 * fib(3) = fib(2) + fib(1) = 2
 * fib(4) = 3
 * fib(5) = 5
 * fib(6) = 8
 *)

val my_func = fn () => fib(100)
val result = my_func()

val unit = ()

fun f(x,y,z) = x+y+z
fun f(args) =
  let
    val (x,y,z) = args
  in
    x+y+z
  end

fun fib (n) =
  if n <= 1 then
    n
  else
    let
      val (a, b) = (fib (n - 1), fib (n - 2))
    in
      a+b
    end

(*
fib(5)
-> if 5 <= 1 then 5 else fib(5-1) + fib(5-2)
-> fib(5-1) + fib(5-2)
-> fib(4) + fib(5-2)
-> (if 4 <= 1 then 4 else fib(4-1) + fib(4-2))  + fib(5-2)
*)

val nth = fn s => (fn i => ...)

fun nth s i =
  Array.get(s, i)

val nth: sequence -> int -> elem
val s_getter: int -> elem = nth s


(* Seq.length(s)    length of a sequence
 * Seq.nth s i      get the ith element
 * Char.isSpace(c)  check if a character is whitespace character
 *) 
fun word_count(chars: char Seq.t) =
  let
    fun getter(i) =
      if i = 0 then #" " else Seq.nth chars (i-1)
  in
    parallel_sum(0, Seq.length(chars), fn i =>
      let
        val c1: char = getter i
        val c2: char = getter (i+1)
      in
        Char.isSpace c1 andalso not (Char.isSpace c2)
      end)
  end



(* f(lo) + f(lo+1) + ... + f(hi-1) *)
fun parallel_sum(lo: int, hi: int, f: int -> int) =
  if lo >= hi then
    0
  else if ??? then
    ???
  else
  let
    val mid = lo + (hi - lo) div 2
    val (left, right) =
      ForkJoin.par (fn () => parallel_sum(lo, mid, f),
                    fn () => parallel_sum(mid, hi, f))
  in
    left + right
  end
