
structure VS = VersionedSeq

val n = 30

val s = VS.tabulate (0, n, fn i => 0)
val s' = VS.update s (5, 5)
val s'' = VS.update s' (10, 10)

val s''' = VS.inject s'' (Seq.fromList [(3, ~3), (6, ~6), (9, ~9)])

val () =
  Util.for (0, n) (fn i =>
    print (Int.toString (VS.nth s''' i) ^ " "))

val () = print "\n"


(* val _ =
  ForkJoin.par (fn () => VS.update s''' (15, 15),
                fn () => VS.update s''' (20, 20)) *)


val graph =
  (7, Seq.fromList [
    (0,1),
    (0,2),
    (1,3),
    (2,3),
    (4,5)])

val count = ContractGraph.count_connected_components graph
val _ = print (Int.toString count ^ "\n")