structure ContractGraph :>
sig
  type edge = int * int

  val star_contract: int -> (int VersionedSeq.t) * (edge Seq.t) -> 
    (int VersionedSeq.t) * (edge Seq.t)

  val count_connected_components: int * (edge Seq.t) -> int
end =
struct
 
  type edge = int * int


  fun star_contract seed (representatives, edges) =
    let
      fun heads u =
        Word64.mod (Util.hash64 (Word64.xorb (Word64.fromInt u, Word64.fromInt seed)), 0w2) = 0w0
      fun tails u = not (heads u)

      val tailsheads = Seq.filter (fn (u, v) => tails u andalso heads v) edges
      val representatives' = VersionedSeq.inject representatives tailsheads
      fun repr u = VersionedSeq.nth representatives' u

      val edges' =
        Seq.map (fn (u, v) => (repr u, repr v))
          (Seq.filter (fn (u, v) => repr u <> repr v) edges)
    in
      (representatives', edges')
    end


  fun count_connected_components (num_vertices, edges) =
    let
      fun loop round_number (representatives, edges) =
        if Seq.length edges = 0 then
          representatives
        else
          let
            val () = print ("round number " ^ Int.toString round_number ^ ":\n  " ^
              VersionedSeq.to_string Int.toString representatives ^ "\n  " ^
              Seq.toString (fn (u, v) => "(" ^ Int.toString u ^ "," ^ Int.toString v ^ ")") edges ^ "\n")
          in
            loop (round_number+1)
              (star_contract (Util.hash round_number) (representatives, edges))
          end

      val edges_both_ways =
        Seq.append (edges, Seq.map (fn (u, v) => (v, u)) edges)
      val init_repr = VersionedSeq.tabulate (0, num_vertices, fn i => i)

      val final_repr = loop 0 (init_repr, edges_both_ways)
      val final_repr = VersionedSeq.to_seq final_repr
    in
      Parallel.reduce op+ 0 (0, Seq.length final_repr) (fn i =>
        if Seq.nth final_repr i = i then 1 else 0)
    end


end