val n = CommandLineArgs.parseInt "n" (1000 * 1000)
val impl = CommandLineArgs.parseString "impl" "sequential"
val chunk_size = CommandLineArgs.parseInt "chunk-size" 2

val _ = print ("n " ^ Int.toString n ^ "\n")
val _ = print ("impl " ^ impl ^ "\n")

val func =
  case impl of
    "sequential" => SequentialPrefixSums.sequential_prefix_sums {init = 0}
  | "contraction" => ContractionPrefixSums.contraction_prefix_sums
  | "chunked-contraction" =>
      let
        val _ = print ("chunk-size " ^ Int.toString chunk_size ^ "\n")
      in
        ChunkedContractionPrefixSums.chunked_contraction_prefix_sums
          {chunk_size = chunk_size}
      end
  | "dc" => DCPrefixSums.dc_prefix_sums
  | "updown" => UpDownPrefixSums.up_down_prefix_sums
  | "scan" =>
      let
        val _ = print ("chunk-size " ^ Int.toString chunk_size ^ "\n")
      in
        (fn input =>
           ArraySlice.full
             (SeqBasis.scan chunk_size op+ 0 (0, Seq.length input)
                (Seq.nth input)))
      end
  | _ => Util.die ("unknown impl " ^ impl)

val input = Seq.tabulate (fn i => 1) n
val result = Benchmark.run (fn () => func input)
val _ = print
  ("output " ^ Util.summarizeArraySlice 10 Int.toString result ^ "\n")
