structure SequentialPrefixSums:
sig
  val write_sequential_prefix_sums: {init: int}
                                    -> {input: int Seq.t, output: int Seq.t}
                                    -> unit
  val sequential_prefix_sums: {init: int} -> int Seq.t -> int Seq.t
end =
struct

  fun write_sequential_prefix_sums {init} {input, output} =
    let
      val n = Int.min (Seq.length input, Seq.length output)

      fun loop acc i =
        if i >= n then
          acc
        else
          ( ArraySlice.update (output, i, acc)
          ; loop (acc + Seq.nth input i) (i + 1)
          )

      val final = loop init 0
    in
      if n < Seq.length output then ArraySlice.update (output, n, final) else ()
    end

  fun sequential_prefix_sums {init} input =
    let
      val output = ArraySlice.full (ForkJoin.alloc (Seq.length input + 1))
    in
      write_sequential_prefix_sums {init = init}
        {input = input, output = output};
      output
    end

end
