structure DCPrefixSums:
sig
  val dc_prefix_sums: int Seq.t -> int Seq.t
end =
struct
  fun dc_prefix_sums s =
    if Seq.length s = 0 then
      Seq.singleton 0
    else if Seq.length s = 1 then
      Seq.fromList [0, Seq.nth s 0]
    else
      let
        val n1 = Seq.length s div 2
        val n2 = Seq.length s - n1
        val s1 = Seq.subseq s (0, n1)
        val s2 = Seq.subseq s (n1, n2)
        val (p1, p2) = ForkJoin.par (fn () => dc_prefix_sums s1, fn () =>
          dc_prefix_sums s2)
        val t1 = Seq.nth p1 n1
      in
        Seq.append (Seq.subseq p1 (0, n1), Seq.map (fn x => t1 + x) p2)
      end
end
