structure ContractionPrefixSums:
sig
  val contraction_prefix_sums: int Seq.t -> int Seq.t
end =
struct

  fun contraction_prefix_sums (s: int Seq.t) =
    if Seq.length s = 0 then
      Seq.singleton 0
    else if Seq.length s = 1 then
      Seq.fromList [0, Seq.nth s 0]
    else
      let
        val n = Seq.length s
        val half = Util.ceilDiv n 2
        fun contract i =
          if 2 * i + 1 = n then Seq.nth s (2 * i)
          else Seq.nth s (2 * i) + Seq.nth s (2 * i + 1)
        val contracted = Seq.tabulate contract half
        val recursive_sums = contraction_prefix_sums contracted
        fun output_elem i =
          if i mod 2 = 0 then Seq.nth recursive_sums (i div 2)
          else Seq.nth recursive_sums (i div 2) + Seq.nth s (i - 1)
        val expanded = Seq.tabulate output_elem (n + 1)
      in
        expanded
      end

end
