structure CLA = CommandLineArgs

(* =========================================================================
 * parse -problem [mps | mcss]
 *)

val problem = CLA.parseString "problem" "mps"

val func: (int * int) -> (int -> int) -> int =
  case problem of
    "mps" => MaxSums.mps_as_reduce
  | "mcss" => MaxSums.mcss
  | _ => Util.die ("unknown -problem " ^ problem)

val _ = print ("problem " ^ problem ^ "\n")

(* =========================================================================
 * parse sequence of input numbers
 *)

val input = Seq.map (valOf o Int.fromString) (Seq.fromList (CLA.positional ()))
val _ = print ("input: " ^ Util.summarizeArraySlice 10 Int.toString input ^ "\n")
val n = Seq.length input

(* val n = CLA.parseInt "n" 10000000 *)
(* val input = Seq.tabulate (fn i => (Util.hash i) mod 10 - 5) n *)

(* =========================================================================
 * run it
 *)

(*val result = Benchmark.run problem (fn () => func (0, n) (fn i => Seq.nth input i))*)

val result = func (0, n) (fn i => Seq.nth input i)
val _ = print ("result: " ^ Int.toString result ^ "\n")

