structure CLA = CommandLineArgs

(* =========================================================================
 * parse -impl [foldl | dc_reduce]
 *)

val impl = CLA.parseString "impl" "foldl"

val func: (int * int -> int) -> int -> (int * int) -> (int -> int) -> int =
  case impl of
    "foldl" => Examples.foldl
  | "dc_reduce" => Examples.dc_reduce
  | _ => Util.die ("unknown -impl " ^ impl)

val _ = print ("impl " ^ impl ^ "\n")

(* =========================================================================
 * parse sequence of input numbers
 *)

val input = Seq.map (valOf o Int.fromString) (Seq.fromList (CLA.positional ()))

val _ = print ("input: " ^ Util.summarizeArraySlice 10 Int.toString input ^ "\n")

(* =========================================================================
 * run it
 *)


fun combine (a, b) =
  if b < 0 then a else a+b
val zero = 0


val result = func combine zero (0, Seq.length input) (fn i => Seq.nth input i)
val _ = print ("result: " ^ Int.toString result ^ "\n")