structure Examples =
struct


  fun foldl combine acc (lo, hi) f =
    if lo >= hi then 
      acc
    else
      let
        val acc' = combine (acc, f lo)
      in
        foldl combine acc' (lo+1, hi) f
      end


  fun dc_reduce combine z (lo, hi) f =
    if lo >= hi then
      z
    else if lo+1 = hi then
      f lo
    else
      let
        val mid = lo + (hi-lo) div 2
        val (left, right) = ForkJoin.par (fn () => dc_reduce combine z (lo, mid) f,
                                          fn () => dc_reduce combine z (mid, hi) f)
      in
        combine (left, right)
      end

end