fun usage () =
  Util.die ("Usage: ./main [fib | wc | wc_faster | data_race | data_race_faster | ...]\n")

val ex = List.hd (CommandLineArgs.positional ()) handle _ => usage ()

val () =
  case ex of
    "fib" => Ex.bench_fib ()
  | "wc" => Ex.bench_wc ()
  | "wc_faster" => Ex.bench_wc_faster ()
  | "data_race" => Ex.data_race_ex ()
  | "data_race_faster" => Ex.data_race_faster_ex ()
  | _ => usage ()
