package main

import (
	"math"
)

func primesUpto(n int) []int64 {
	if n < 2 {
		return make([]int64, 0)
	}

	sqrtPrimes := primesUpto(int(math.Floor(math.Sqrt(float64(n)))))
	// fmt.Printf("primesUpto(%d): len(sqrtPrimes) = %d\n", n, len(sqrtPrimes))

	flags := make([]bool, n+1)
	parallelRange(5000, 0, n+1, func(low, high int) {
		for i := low; i < high; i++ {
			flags[i] = true
		}
	})

	parallelRange(1, 0, len(sqrtPrimes), func(iLo, iHi int) {
		for i := iLo; i < iHi; i++ {
			p := int(sqrtPrimes[i])
			numMultiples := n/p - 1
			// fmt.Printf("num multiples of %d: %d\n", p, numMultiples)
			parallelRange(5000, 0, numMultiples, func(jLo, jHi int) {
				for j := jLo; j < jHi; j++ {
					// fmt.Printf("multiple of %d: %d\n", p, (j+2)*p)
					flags[(j+2)*p] = false
				}
			})
		}
	})

	result := filterRange(5000,
		func(i int) bool { return flags[i] },
		2,
		n+1,
		func(i int) int64 { return int64(i) })

	// fmt.Printf("primesUpto(%d): len(result) = %d\n", n, len(result))

	return result
}