package main

import (
	"fmt"
	"runtime"
)

func main() {
  procs := max[int](1, parseInt("procs", 1))
	runtime.GOMAXPROCS(procs)

	bench := parseString("bench", "wc")

	if (bench == "primes") {
		n := parseInt("n", 100000000)
		fmt.Printf("n %d\n", n)

		var result []int64
		benchmarkRun("primes", func() { result = primesUpto(n) })

		fmt.Printf("number of primes %d\n", len(result))
		for i := 0; i < 10; i++ {
			// result[i].Print()
			fmt.Printf("%d ", result[i])
		}
		fmt.Printf("...\n")

	} else if (bench == "wc") {
		input := parseString("input", "../data/words.txt")
		fmt.Printf("input %s\n", input)

		chars := readFileContents(input)

    var result int
		benchmarkRun("wc", func() { result = wc(chars) })

		fmt.Printf("%d\n", result)

	} else if (bench == "data_race") {
		n := parseInt("n", 1000000)
		dataRaceExample(n)

	} else {
		fmt.Printf("./main -procs <n> -bench [primes | wc | ...]\n")
	}
}
