structure CLA = CommandLineArgs
structure Seq = ArraySequence

structure L = LinearRec(SimpleSeq)
structure LD = LinearRec(SimpleDelayedSeq)
structure LSM = LinearRecScanMap(SimpleSeq)

val n = CLA.parseInt "n" (1000 * 1000 * 100)
val impl = CLA.parseString "impl" "simple-seq"

val _ = print ("n " ^ Int.toString n ^ "\n")

val input = Seq.tabulate (fn i => (1.0, 1.0)) n

val linear_rec =
  case impl of
    "simple-seq" => L.linear_rec
  | "simple-seq-scan-map" => LSM.linear_rec
  | "simple-delayed-seq" => LD.linear_rec
  | _ => raise Fail ("unknown impl: " ^ impl)

fun task () = linear_rec input

val result = Benchmark.run "linear recurrence" task
val x = Seq.nth result (n - 1)
val _ = print ("result " ^ Real.toString x ^ "\n")
