structure SimpleDelayedSeq: SIMPLE_SEQ =
struct

  open DelayedSeq

  fun tabulate n f = DelayedSeq.tabulate f n

  fun map s f = DelayedSeq.map f s

  fun scan_map g z s f =
    let val (scanned, total) = DelayedSeq.scan g z s
    in (DelayedSeq.map f scanned, f total)
    end

  fun from_array_seq a = DelayedSeq.fromArraySeq a

  fun to_array_seq a = DelayedSeq.toArraySeq a
end
