signature SIMPLE_SEQ =
sig
  type 'a seq
  type 'a t = 'a seq

  val from_array_seq: 'a ArraySequence.t -> 'a seq
  val to_array_seq: 'a seq -> 'a ArraySequence.t

  val length: 'a seq -> int
  val nth: 'a seq -> int -> 'a

  val tabulate: int -> (int -> 'a) -> 'a seq
  val map: 'a seq -> ('a -> 'b) -> 'b seq
  val reduce: ('a * 'a -> 'a) -> 'a -> 'a seq -> 'a

  val scan: ('a * 'a -> 'a) -> 'a -> 'a seq -> ('a seq * 'a)
  val scan_map: ('a * 'a -> 'a) -> 'a -> 'a seq -> ('a -> 'b) -> 'b seq * 'b
end
