functor LinearRecScanMap(Seq: SIMPLE_SEQ):
sig
  val linear_rec: (real * real) ArraySequence.t -> real ArraySequence.t
end =
struct

  fun combine ((x1, y1), (x2, y2)) =
    (x1 * x2, y1 * x2 + y2)

  val z = (1.0, 0.0)

  fun linear_rec input =
    let
      val tm = Timer.start ()

      val input = Seq.from_array_seq input

      val tm = Timer.tick tm "from_array_seq"

      val (scan_mapped, _) = Seq.scan_map combine z input (fn (x, y) => y)

      val tm = Timer.tick tm "scan_map"

      val output = Seq.to_array_seq scan_mapped

      val tm = Timer.tick tm "to_array_seq"
    in
      output
    end

end
