functor LinearRec(Seq: SIMPLE_SEQ):
sig
  val linear_rec: (real * real) ArraySequence.t -> real ArraySequence.t
end =
struct

  fun combine ((x1, y1), (x2, y2)) =
    (x1 * x2, y1 * x2 + y2)

  val z = (1.0, 0.0)

  fun linear_rec input =
    let
      val tm = Timer.start ()

      val input = Seq.from_array_seq input

      val tm = Timer.tick tm "from_array_seq"

      val (scanned, _) = Seq.scan combine z input

      val tm = Timer.tick tm "scan"

      val mapped = Seq.map scanned (fn (x, y) => y)

      val tm = Timer.tick tm "map"

      val output = Seq.to_array_seq mapped

      val tm = Timer.tick tm "to_array_seq"
    in
      output
    end

end
