structure SimpleSeq: SIMPLE_SEQ =
struct
  type 'a seq = 'a array
  type 'a t = 'a seq

  fun length s = Array.length s
  fun nth s i = Array.sub (s, i)

  fun tabulate n f =
    let val a = ForkJoin.alloc n
    in ForkJoin.parform (0, n) (fn i => Array.update (a, i, f i)); a
    end

  fun map s f =
    tabulate (length s) (fn i => f (nth s i))

  fun reduce g z s =
    ForkJoin.reducem g z (0, length s) (fn i => nth s i)

end
