structure SimpleDelayedSeq: SIMPLE_SEQ =
struct
  datatype 'a seq = Delayed of {start: int, len: int, get: int -> 'a}
  type 'a t = 'a seq

  fun length (Delayed {len, ...}) = len

  fun nth (Delayed {start, get, ...}) i =
    get (start + i)

  fun tabulate n f = Delayed {start = 0, len = n, get = f}

  fun map (Delayed {start, len, get}) f =
    Delayed {start = start, len = len, get = f o get}

  fun reduce g z (Delayed {start, len, get}) =
    ForkJoin.reducem g z (start, start + len) get
end
