structure IntegrateSequential:
sig
  val integrate: (real -> real) -> (real * real) -> int -> real
end =
struct

  fun integrate f (s, e) n =
    let
      val delta = (e - s) / (Real.fromInt n)
      val s' = s + delta / 2.0

      fun loop acc i =
        if i = n then
          acc
        else
          let
            val rectangle_position = s' + (Real.fromInt i) * delta
            val height = f rectangle_position
          in
            loop (acc + height) (i + 1)
          end

      val summed_heights = loop 0.0 0
    in
      delta * summed_heights
    end

end
