functor Integrate(Seq: SIMPLE_SEQ):
sig
  val integrate: (real -> real) -> (real * real) -> int -> real
end =
struct

  fun integrate f (s, e) n =
    let
      val delta = (e - s) / (Real.fromInt n)
      val s' = s + delta / 2.0

      val tm = Timer.start ()

      val rectangle_positions = Seq.tabulate n (fn i =>
        s' + (Real.fromInt i) * delta)

      val tm = Timer.tick tm "rectangle_positions"

      val rectangle_heights = Seq.map rectangle_positions f

      val tm = Timer.tick tm "rectangle_heights"

      val summed_heights = Seq.reduce (op+) 0.0 rectangle_heights

      val tm = Timer.tick tm "summed_heights"
    in
      summed_heights * delta
    end

end
