structure IntersectionCount:
sig
  val intersection_count: ('a * 'a -> order) -> ('a Seq.t * 'a Seq.t) -> int
end =
struct

  (* You might find this library function useful. It counts the number of
   * elements within s that are strictly less than x, assuming the input s
   * is sorted. O(log|s|) work and span. *)
  fun count_less (cmp: 'a * 'a -> order) (s: 'a Seq.t) (x: 'a) =
    BinarySearch.countLess cmp s x


  (* cmp is a comparison function for the elements of s and t; it returns
   * one of LESS, EQUAL, or GREATER.
   *)
  fun intersection_count cmp (s, t) =
    raise Fail "TODO: IntersectionCount.sml: your code here"

end
