structure CLA = CommandLineArgs
structure Seq = ArraySequence

val n = CLA.parseInt "n" (1000 * 1000)
val impl = CLA.parseString "impl" "mine"
val seed = CLA.parseInt "seed" 15210
val _ = print ("n " ^ Int.toString n ^ "\n")
val _ = print ("impl " ^ impl ^ "\n")
val _ = print ("seed " ^ Int.toString seed ^ "\n")

fun rtos x =
  if x < 0.0 then "-" ^ rtos (~x) else Real.fmt (StringCvt.FIX (SOME 3)) x
fun pttos (x, y) =
  String.concat ["(", rtos x, ",", rtos y, ")"]


val resolution = 1000000
fun rand_real seed =
  Real.fromInt (Util.hash seed mod resolution) / Real.fromInt resolution
fun rand_point_in_circle {center = (cx, cy), radius} seed =
  let
    val r = radius * Math.sqrt (rand_real seed)
    val theta = rand_real (seed + 1) * 2.0 * Math.pi
  in
    (cx + r * Math.cos (theta), cy + r * Math.sin (theta))
  end

fun frac n alpha =
  Real.round (Real.fromInt n * alpha)

val inputPts = Seq.flatten (Seq.fromList
  [ Seq.tabulate
      (fn i =>
         rand_point_in_circle {center = (0.0, 0.0), radius = 1.0} (seed + 2 * i))
      (frac n 0.7)
  , Seq.tabulate
      (fn i =>
         rand_point_in_circle {center = (0.8, 0.1), radius = 0.4}
           (Util.hash seed + 2 * i)) (frac n 0.1)
  , Seq.tabulate
      (fn i =>
         rand_point_in_circle {center = (~0.8, ~0.8), radius = 0.2}
           (Util.hash (Util.hash seed) + 2 * i)) (frac n 0.1)
  , Seq.tabulate
      (fn i =>
         rand_point_in_circle {center = (0.0, 1.0), radius = 0.2}
           (Util.hash (Util.hash (Util.hash seed)) + 2 * i)) (frac n 0.1)
  , Seq.fromList [(~1.05, 0.05)]
  ])

val n = Seq.length inputPts
val _ = print ("num points " ^ Int.toString n ^ "\n")

structure RQH =
  ReferenceQuickhull
    (type point = real * real val tri_area = Geometry2D.Point.triArea)
structure MQH =
  MyQuickhull (type point = real * real val tri_area = Geometry2D.Point.triArea)

val task =
  case impl of
    "reference" => (fn () => RQH.hull inputPts)
  | "mine" => (fn () => MQH.hull inputPts)
  | _ =>
      Util.die
        ("unknown -impl " ^ impl ^ "\npossible options are: [reference, mine]")

val result = Benchmark.run task
val _ = print ("hull size " ^ Int.toString (Seq.length result) ^ "\n")
