functor ReferenceQuickhull
  (type point = real * real val tri_area: point * point * point -> real):
sig
  val hull: (real * real) Seq.t -> int Seq.t
end =
struct

  fun pt (i, p) = p
  fun dist p q r =
    tri_area (pt p, pt q, pt r)
  fun above_line a b pt =
    dist a b pt > 0.0
  fun max_x (p1, p2) =
    if #1 (#2 p1) > #1 (#2 p2) then p1 else p2
  fun min_x (p1, p2) =
    if #1 (#2 p1) < #1 (#2 p2) then p1 else p2

  fun rtos x =
    if x < 0.0 then "-" ^ rtos (~x) else Real.fmt (StringCvt.FIX (SOME 3)) x
  fun pttos (i, (x, y)) =
    String.concat [Int.toString i, ":(", rtos x, ",", rtos y, ")"]


  fun single (i, p) =
    TFlatten.leaf (Seq.singleton i)


  fun semihull pts lp rp =
    if Seq.length pts <= 1 then
      TFlatten.leaf (Seq.map #1 pts)
    else
      let
        val (mid, _) =
          Parallel.reduce (fn (a, b) => if #2 a > #2 b then a else b)
            (~1, Real.negInf) (0, Seq.length pts)
            (fn i => (i, dist lp rp (Seq.nth pts i)))

        val midp = Seq.nth pts mid

        val left_pts = Seq.filter (above_line lp midp) pts
        val right_pts = Seq.filter (above_line midp rp) pts

        val (left, right) =
          ForkJoin.par (fn () => semihull left_pts lp midp, fn () =>
            semihull right_pts midp rp)
      in
        TFlatten.node (left, TFlatten.node (single midp, right))
      end


  fun hull pts =
    let
      val pts = Seq.mapIdx (fn (i, p) => (i, p)) pts
      val lp = Seq.reduce min_x (~1, (Real.posInf, Real.posInf)) pts
      val rp = Seq.reduce max_x (~1, (Real.negInf, Real.negInf)) pts

      val above_pts = Seq.filter (above_line lp rp) pts
      val below_pts = Seq.filter (above_line rp lp) pts

      val (above, below) =
        ForkJoin.par (fn () => semihull above_pts lp rp, fn () =>
          semihull below_pts rp lp)

      val whole = TFlatten.node
        (TFlatten.node (single lp, above), TFlatten.node (single rp, below))
    in
      TFlatten.flatten whole
    end

end
