val usage =
  "Usage: main <n> <k> [<input_sortedness>] [-warmup <w>] [-repeat <r>]\n"
  ^
  "  sort and deduplicate <n> randomly generated elements with approximately <k> unique elements\n"
  ^
  "  <input_sortedness> (integer between 0 and 100, interpreted as percent) controls how sorted the input is (default 60)\n"
  ^ "  optional warmup for <w> seconds\n"
  ^ "  repeat <r> times for measuring average performance\n"

val (n, k, sortedness) =
  (case CommandLineArgs.positional () of
     [n, k] => (valOf (Int.fromString n), valOf (Int.fromString k), 60)
   | [n, k, s] =>
       ( valOf (Int.fromString n)
       , valOf (Int.fromString k)
       , valOf (Int.fromString s)
       )
   | _ => Util.die usage)
  handle e => Util.die (exnMessage e ^ "\n" ^ usage)

val () =
  if sortedness < 0 orelse sortedness > 100 then
    Util.die ("Error: sortedness must be in range 0-100\n" ^ usage)
  else
    ()

val _ = print ("n " ^ Int.toString n ^ "\n")
val _ = print ("k " ^ Int.toString k ^ "\n")
val _ = print ("sortedness " ^ Int.toString sortedness ^ "\n")
val _ = print
  ("(input is n randomly generated elements with approximately k unique elements)\n")

val approx_num_unique = k

val _ = print ("generating input... (might take a moment)\n")

val input = Parallel.tabulate (0, n) (fn i =>
  Word64.mod (Util.hash64 (Word64.fromInt i), Word64.fromInt approx_num_unique))
val input =
  Scramble.scramble {target_sortedness = sortedness, cmp = Word64.compare} input

val () = print
  ("input " ^ Util.summarizeArraySlice 20 (Word64.fmt StringCvt.DEC) input
   ^ "\n")

fun pairtos (x, c) =
  "(" ^ Word64.fmt StringCvt.DEC x ^ "," ^ Int.toString c ^ ")"

val result = Benchmark.run (fn () => DedupSort.dedup_sort Word64.compare input)
val _ = print (Util.summarizeArraySlice 10 pairtos result ^ "\n")
val _ = print ("num unique " ^ Int.toString (Seq.length result) ^ "\n")
