structure Scramble :>
sig
  val scramble: {target_sortedness: int, cmp: 'a * 'a -> order}
                -> 'a Seq.t
                -> 'a Seq.t
end =
struct

  fun scramble {target_sortedness, cmp} input =
    let
      val n = Seq.length input
      val sorted = Mergesort.sort cmp input

      fun flip idx =
        Word64.toInt (Word64.mod
          (Word64.andb (0wxFFFF, (Util.hash64 (Word64.fromInt idx))), 0w100))
        >= target_sortedness

      fun redirect idx =
        if flip idx then
          Word64.toInt (Word64.mod
            ( Word64.andb (0wxFFFFFFFF, Util.hash64 (Word64.fromInt (idx + n)))
            , Word64.fromInt n
            ))
        else
          idx

      val redirects = Seq.tabulate redirect n

      fun cmp' (i1, i2) =
        Int.compare (Seq.nth redirects i1, Seq.nth redirects i2)

      val ids = StableSort.sort cmp' (Seq.tabulate (fn i => i) n)
    in
      Seq.map (Seq.nth sorted) ids
    end

end
