(* !!!
 *
 * DO NOT EDIT THIS FILE
 * 
 * !!!
 *
 * This file provides sequential solutions to the two coding tasks, to
 * help check correctness. These solutions DO NOT satisfy the requirements
 * of the coding tasks, because they are entirely sequential, and therefore
 * do not meet the required cost bounds.
 *)
structure ReferenceSolutions:
sig
  val in_string_flags: char Seq.t -> bool Seq.t
  val bracket_depths: char Seq.t -> (int * int * int) Seq.t
end =
struct

  fun is_quote c = (c = #"\"")
  fun is_backslash c = (c = #"\\")
  fun is_bracket c =
    c = #"{" orelse c = #"}" orelse c = #"[" orelse c = #"]"


  fun in_string_flags json_chars =
    let
      val n = Seq.length json_chars

      (* allocate flags array and initialize to all `false` *)
      val flags = ForkJoin.alloc n
      val () = Parallel.parfor (0, n) (fn i => Array.update (flags, i, false))

      (* walk through a string, writing flags as we go; returns the first index
       * outside of the string
       *)
      fun loop_in_string i =
        if i >= n then
          i (* actually impossible, if the input is valid JSON *)
        else
          ( Array.update (flags, i, true)
          ; case Seq.nth json_chars i of
              #"\"" => i + 1 (* done *)
            | #"\\" =>
                (* A backslash starts an escape sequence. Possible escape
                 * sequences are:
                 *   \" \\ \/ \b \f \n \r \t \uXXXX   (where X is a hex digit)
                 * All of these can effectively be handled by just skipping the
                 * character that immediately follows the first backslash. We
                 * need to update the next flag, too, before skipping over that
                 * index.
                 *)
                (Array.update (flags, i + 1, true); loop_in_string (i + 2))
            | _ => loop_in_string (i + 1)
          )

      fun loop i =
        if i >= n then
          ()
        else
          case Seq.nth json_chars i of
            #"\"" =>
              (Array.update (flags, i, true); loop (loop_in_string (i + 1)))
          | _ => loop (i + 1)
    in
      loop 0;
      ArraySlice.full flags
    end


  fun bracket_depths json_chars =
    let
      val n = Seq.length json_chars

      fun advance_to_end_of_string i =
        if i >= n then
          i (* this should actually be impossible, if the input is valid JSON *)
        else
          case Seq.nth json_chars i of
            #"\"" => i + 1 (* done *)
          | #"\\" =>
              (* A backslash starts an escape sequence. Possible escape
               * sequences are:
               *   \" \\ \/ \b \f \n \r \t \uXXXX   (where X is a hex digit)
               * All of these can effectively be handled by just skipping the
               * character that immediately follows the first backslash.
               *)
              advance_to_end_of_string (i + 2)
          | _ => advance_to_end_of_string (i + 1)

      fun loop (acc, dc, ds, i) =
        if i >= n then
          acc
        else
          let
            val c = Seq.nth json_chars i
          in
            case c of
              #"\"" => loop (acc, dc, ds, advance_to_end_of_string (i + 1))
            | #"{" => loop ((i, dc, ds) :: acc, dc + 1, ds, i + 1)
            | #"}" => loop ((i, dc - 1, ds) :: acc, dc - 1, ds, i + 1)
            | #"[" => loop ((i, dc, ds) :: acc, dc, ds + 1, i + 1)
            | #"]" => loop ((i, dc, ds - 1) :: acc, dc, ds - 1, i + 1)
            | _ => loop (acc, dc, ds, i + 1)
          end

      val acc = loop ([], 0, 0, 0)
    in
      Seq.fromList (List.rev acc)
    end

end
