library(ggplot2)
# Plotting some of the outputs of the pairs program from NUPACK
data_dir <- 'in'

args <- commandArgs(TRUE)

filepath <- paste(args[1], 'ppairs', sep='.')
data <- read.delim(filepath, header=FALSE, comment.char='%')
N <- data[1,1] + 1
data <- data[seq(2, dim(data)[1]),]
# data[order(data[,3]),] # Sort by number of matches
newdata <- data.frame(x=data[,1], y=data[,2]) #expand.grid

newdata = expand.grid(1:N, 1:N)
newdata$z <- c(0)
newdata$z[(data[,1]-1)*N + data[,2]] <- data[,3]

png(paste(args[1], '-pairplot.png', sep=''), width=1024, height=1024)
p <- ggplot(newdata, aes(x=newdata[,1],y=newdata[,2]))
print(p + geom_tile(aes(fill=newdata$z)) + scale_fill_gradient(low="white", high="red") + opts(panel.background = theme_blank()) + scale_x_discrete(breaks=seq(1, N, 2)) + scale_y_discrete(breaks=seq(1, N, 2)))
dev.off()
