public class Hint{
	private final int hintType;
	public final static int ODD = 0;
	public final static int EVEN = 1;
	public final static int CONTAINS = 3;
	public final static int MORE_LESS = 4;
	
	private final int contains;
	private final int moreThan;
	private final int lessThan;
	/**
	 * 
	 * @param hType
	 * @param contains
	 * @param moreThan
	 * @param lessThan
	 */
	public Hint (int hType, int contains, int moreThan, int lessThan) {
		this.moreThan = moreThan;
		this.lessThan = lessThan;
		this.contains = contains; 
		this.hintType = hType;
	}
	
	public boolean satisfy(int guess) {
		System.out.println("hint type is " + hintType + " guess is " + guess);
		switch (hintType) {
		case ODD: 
			return (guess % 2 == 1);
		case EVEN:
			return (guess % 2 == 0);
		case CONTAINS:
			return (guess%10 == contains || (contains!=0 && guess/10 == contains)) ;
		case MORE_LESS:
			return (guess<=lessThan && guess>=moreThan);
		}
		return false;
	}
	
	@Override
	public String toString() {
		switch (hintType) {
		case ODD: 
			return "The product is odd";
		case EVEN:
			return "The product is even";
		case CONTAINS:
			return "The product contains " + contains;
		case MORE_LESS:
			return "The product is more than " + moreThan + " and less than " + lessThan;
		}
		return null;
	}
}