
import java.io.*;
import java.net.*;
import java.text.DecimalFormat;
import java.util.*;


public class NotSoRandomPlayer {



    NotSoRandomPlayer( String host, int port, String dataFile,
                       int nRuns, long lag, String attrs )
            throws Exception {
        //  which attrs do we want to use
        String[] attrStrs = attrs.split( "," );
        ArrayList attrsWeWant = new ArrayList();
        for ( int i = 0; i < attrStrs.length; i++ )
            attrsWeWant.add( new Integer( attrStrs[i] ) );
        //  how many gambles, and which gambles do we want to use?
        BufferedReader br2 = new BufferedReader( new FileReader( dataFile ) );
        String line = null;
        boolean readingAttrs = false;
        int nGambles = 0;
        ArrayList gamblesWeWant = new ArrayList();
        while ( ( line = br2.readLine() ) != null ) {
            if ( line.trim().length() == 0 ) {
                if ( readingAttrs )
                    break;
                else
                    continue;
            }
            if ( line.startsWith( "#gambleatt" ) ) {
                readingAttrs = true;
                continue;
            }
            if ( !readingAttrs )
                continue;
            nGambles++;
            String[] ss = line.split( "[ ,]+" );
            int[] ii = new int[5];
            for ( int i = 0; i < 5; i++ )
                ii[i] = Integer.parseInt( ss[i] );
            int gid = ii[0];
            int attr = 0;
            for ( int j = 1; j < 5; j++ )
                if ( ii[j] == 0 )
                    ;
                else if ( ii[j] == 1 )
                    attr += 1 << (4-j);
            if ( attrsWeWant.contains( new Integer( attr ) ) )
                gamblesWeWant.add( new Integer( gid ) );
        }
        //  connect & send name
        String name = attrs + "," + lag;
        System.out.println( "connecting" );
        Socket s = new Socket( host, port );
        BufferedWriter bw = new BufferedWriter(
                            new OutputStreamWriter(
                            s.getOutputStream() ) );
        BufferedReader br = new BufferedReader(
                            new InputStreamReader(
                            s.getInputStream() ) );
        bw.write( name + "\n" );
        bw.flush();
        //  wait for OK
        String in = br.readLine();
        if ( !in.equals( "OK" ) ) {
            System.out.println( "got back: " + in );
            throw new RuntimeException();
        }
        //  play
        double[] allocs = new double[nGambles];
        Random rnd = new Random();
        DecimalFormat df = new DecimalFormat( "0.00000" );
        for ( int i = 0; i < nRuns; i++ ) {
            System.out.println( "playing round " + i );
            //  generate random allocs that sum to 1
            for ( int j = 0; j < nGambles; j++ )
                if ( gamblesWeWant.contains( new Integer(j) ) )
                    allocs[j] = rnd.nextDouble();
            normalize( allocs );
            //  send allocs
            StringBuffer sb = new StringBuffer( nGambles*8 );
            for ( int j = 0; j < nGambles; j++ )
                sb.append( df.format( allocs[j] ) ).append( " " );
            String out = sb.toString();
            System.out.println( "sending: " + out );
            bw.write( out + "\n" );
            bw.flush();
            //  make sure we get back OK
            in = br.readLine();
            if ( !in.equals( "OK" ) ) {
                System.out.println( "got back: " + in );
                throw new RuntimeException();
            }
            //  block till receive outcomes
            in = br.readLine();
            System.out.println( "got back: " + in );
            try {
                Thread.sleep( lag );
            } catch ( InterruptedException e ) {}
        }
        System.out.println( "done" );
    }


    static void normalize( double[] d ) {
        double total = 0;
        for ( int i = 0; i < d.length; i++ )
            total += d[i];
        for ( int i = 0; i < d.length; i++ )
            d[i] /= total;
    }


    public static void main( String[] args ) throws Exception {
        if ( args.length != 6) {
            System.out.println(
                "usage:  java NotSoRandomPlayer" +
                " <host> <port> <dataFile> <nRuns> <lag> <attr[,attr]*>" );
            System.exit(1);
        }
        new NotSoRandomPlayer( args[0],
                               Integer.parseInt( args[1] ),
                               args[2],
                               Integer.parseInt( args[3] ),
                               Long.parseLong( args[4] ),
                               args[5] );
    }

}
