package netmatch.algorithm;

import java.util.*;
import java.util.List;
import java.awt.*;

import cytoscape.CyNetwork;
import cytoscape.CyEdge;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;

import javax.swing.*;

import giny.model.GraphPerspective;
import giny.view.NodeView;
import giny.view.EdgeView;
import phoebe.PGraphView;
import netmatch.Strings;

public class netMatch implements Task {
  private String DBName;
  private String queryName;
  private JFrame frame;
  private CyNetwork target;
  private CyNetwork query;
  private TaskMonitor taskMonitor;
  private boolean interrupted;
  private boolean completedSuccessfully;
  private ArrayList array;
  private ArrayList source;
  private Image[] imageList;
  private String tea, tna, qea, qna;
  private GraphLoader qeLoader;
  private boolean isUsedEditor = false;

  public netMatch(String DBName, String queryName) {
    this.DBName = DBName;
    this.queryName = queryName;
    frame = null;
    target = null;
    query = null;
    taskMonitor = null;
    interrupted = false;
    completedSuccessfully = false;
    array = null;
    source = null;
    imageList = null;
    tea = null;
    tna = null;
    qea = null;
    qna = null;
  }

  /**
   * @param frame  Parent
   * @param target Target Graph
   * @param tea    Target Graph Edge Attirbutes type
   * @param tna    Target Graph Node Attributes type
   * @param query  Query Graph
   * @param qea    Query Graph Edge Attirbutes type
   * @param qna    Query Graph Node Attirbutes type
   */
  public netMatch(JFrame frame, CyNetwork target, String tea, String tna, CyNetwork query, String qea, String qna) {
    this.DBName = null;
    this.queryName = null;
    this.frame = frame;
    this.target = target;
    this.query = query;
    this.tea = tea;
    this.tna = tna;
    this.qea = qea;
    this.qna = qna;
    taskMonitor = null;
    interrupted = false;
    completedSuccessfully = false;
    array = null;
    imageList = null;
    source = null;
  }

  public netMatch(JFrame frame, CyNetwork target, String tea, String tna, GraphLoader gl) {
    this.DBName = null;
    this.queryName = null;
    this.frame = frame;
    this.target = target;
    this.tea = tea;
    this.tna = tna;
    this.qeLoader = gl;
    this.isUsedEditor = true;

    taskMonitor = null;
    interrupted = false;
    completedSuccessfully = false;
    array = null;
    imageList = null;
    source = null;
  }

  public GraphLoader loadGraphFromNetwork(CyNetwork network, String edgeAttr, String nodeAttr) throws Exception {
    GraphLoader loader;
    Hashtable names = new Hashtable();
    int i, k;
    boolean any;

    i = k = 0;
    loader = new GraphLoader(frame);
    List nodes = network.nodesList();
    List edges = network.edgesList();
    CyAttributes nodesAttributes = Cytoscape.getNodeAttributes();
    CyAttributes edgesAttributes = Cytoscape.getEdgeAttributes();

    int size = nodes.size() + edges.size();
    for(Iterator it = nodes.iterator();it.hasNext();) {
      CyNode node = (CyNode)it.next();
      String name1 = node.getIdentifier();
      //String name1Attr = (String)Cytoscape.getNodeAttributeValue(node, nodeAttr); //DEPRECATED
      //String name1Attr = nodesAttributes.getStringAttribute(node.getIdentifier(),nodeAttr);
      String name1Attr = getAttribute(nodesAttributes, node.getIdentifier(), nodeAttr);
      if(!names.containsKey(name1)) {
        names.put(name1, new Integer(i++));
        //System.out.println("Add Node:" + name1Attr + " " + node.getRootGraphIndex());
        loader.InsertNode(name1Attr, node.getRootGraphIndex());
      }
      taskMonitor.setPercentCompleted((++k * 100) / size);
      if(checkTask())
        return null;
    }
    for(Iterator it = edges.iterator();it.hasNext();) {
      CyEdge edge = (CyEdge)it.next();
      //String type = Cytoscape.getEdgeAttributeValue(edge, edgeAttr).toString(); //DEPRECATED
      //String type = edgesAttributes.getStringAttribute(edge.getIdentifier(),edgeAttr);
      String type = getAttribute(edgesAttributes, edge.getIdentifier(), edgeAttr);
      CyNode source = (CyNode)edge.getSource();
      CyNode dest = (CyNode)edge.getTarget();
      String name1 = source.getIdentifier();
      String name2 = dest.getIdentifier();
      //String name1Attr = (String)Cytoscape.getNodeAttributeValue(source, nodeAttr); //DEPRECATED
      //String name2Attr = (String)Cytoscape.getNodeAttributeValue(dest, nodeAttr); //DEPRECATED
      //String name1Attr = nodesAttributes.getStringAttribute(source.getIdentifier(),nodeAttr);
      //String name2Attr = nodesAttributes.getStringAttribute(dest.getIdentifier(),nodeAttr);
      String name1Attr = getAttribute(nodesAttributes, source.getIdentifier(), nodeAttr);
      String name2Attr = getAttribute(nodesAttributes, dest.getIdentifier(), nodeAttr);
      any = false;
      if(name1.equals(name2)) {
        name2 += Common.SELF_EDGE;
        name2Attr += Common.SELF_EDGE;
        if(!names.containsKey(name2)) {
          names.put(name2, new Integer(i++));
          //System.out.println("Add Node:" + name2Attr + " " + source.getRootGraphIndex());
          loader.InsertNode(name2Attr, source.getRootGraphIndex());
        }
        any = true;
      }
      if(any) {
        //System.out.println("Add edge:" + ((Integer)names.get(name1)).intValue() + " " + ((Integer)names.get(name2)).intValue() + " " + type+Common.SELF_EDGE);
        loader.InsertEdge(((Integer)names.get(name1)).intValue(), ((Integer)names.get(name2)).intValue(), type + Common.SELF_EDGE);
        if(!Common.DIRECTED) {
          //System.out.println("Add edge:" + ((Integer)names.get(name1)).intValue() + " " + ((Integer)names.get(name2)).intValue() + " " + type + Common.SELF_EDGE);
          loader.InsertEdge(((Integer)names.get(name2)).intValue(), ((Integer)names.get(name1)).intValue(), type + Common.SELF_EDGE);
        }
      }
      else {
        //System.out.println("Add edge:" + ((Integer)names.get(name1)).intValue() + " " + ((Integer)names.get(name2)).intValue() + " " + type);
        loader.InsertEdge(((Integer)names.get(name1)).intValue(), ((Integer)names.get(name2)).intValue(), type);
        if(!Common.DIRECTED) {
          //System.out.println("Add edge:" + ((Integer)names.get(name1)).intValue() + " " + ((Integer)names.get(name2)).intValue() + " " + type);
          loader.InsertEdge(((Integer)names.get(name2)).intValue(), ((Integer)names.get(name1)).intValue(), type);
        }
      }
      taskMonitor.setPercentCompleted((++k * 100) / size);
      if(checkTask())
        return null;
    }
    return loader;
  }

  public GraphLoader loadGraphFromNetwork(CyNetwork network, String edgeAttr) throws Exception {
    GraphLoader loader;
    Hashtable names = new Hashtable();
    int i, k;
    boolean any;

    i = k = 0;
    loader = new GraphLoader(frame);
    List nodes = network.nodesList();
    List edges = network.edgesList();
    CyAttributes edgesAttributes = Cytoscape.getEdgeAttributes();

    int size = nodes.size() + edges.size();
    for(Iterator it = nodes.iterator();it.hasNext();) {
      CyNode node = (CyNode)it.next();
      String name1 = node.getIdentifier();
      if(!names.containsKey(name1)) {
        names.put(name1, new Integer(i++));
        loader.InsertNode(name1, node.getRootGraphIndex());
      }
      taskMonitor.setPercentCompleted((++k * 100) / size);
      if(checkTask())
        return null;
    }
    for(Iterator it = edges.iterator();it.hasNext();) {
      CyEdge edge = (CyEdge)it.next();
      String type = getAttribute(edgesAttributes, edge.getIdentifier(), edgeAttr);
      CyNode source = (CyNode)edge.getSource();
      CyNode dest = (CyNode)edge.getTarget();
      String name1 = source.getIdentifier();
      String name2 = dest.getIdentifier();
      any = false;
      if(name1.equals(name2)) {
        name2 += Common.SELF_EDGE;
        if(!names.containsKey(name2)) {
          names.put(name2, new Integer(i++));
          loader.InsertNode(name2, source.getRootGraphIndex());
        }
        any = true;
      }
      if(any) {
        loader.InsertEdge(((Integer)names.get(name1)).intValue(), ((Integer)names.get(name2)).intValue(), type + Common.SELF_EDGE);
        if(!Common.DIRECTED)
          loader.InsertEdge(((Integer)names.get(name2)).intValue(), ((Integer)names.get(name1)).intValue(), type + Common.SELF_EDGE);
      }
      else {
        loader.InsertEdge(((Integer)names.get(name1)).intValue(), ((Integer)names.get(name2)).intValue(), type);
        if(!Common.DIRECTED)
          loader.InsertEdge(((Integer)names.get(name2)).intValue(), ((Integer)names.get(name1)).intValue(), type);
      }
      taskMonitor.setPercentCompleted((++k * 100) / size);
      if(checkTask())
        return null;
    }
    return loader;
  }

  private String getAttribute(CyAttributes attributes, String id, String attr) {
    String type = "UNDEFINED";
    if(attributes != null) {
      if(attributes.getType(attr) == CyAttributes.TYPE_STRING)
        type = attributes.getStringAttribute(id, attr);
      else if(attributes.getType(attr) == CyAttributes.TYPE_BOOLEAN)
        type = attributes.getBooleanAttribute(id, attr).toString();
      else if(attributes.getType(attr) == CyAttributes.TYPE_FLOATING)
        type = attributes.getDoubleAttribute(id, attr).toString();
      else if(attributes.getType(attr) == CyAttributes.TYPE_INTEGER)
        type = attributes.getIntegerAttribute(id, attr).toString();
    }
    return type;
  }

  /**
   * @return true if the task has completed successfully
   */
  public boolean isCompletedSuccessfully() {
    return completedSuccessfully;
  }

  /**
   * Gets the Task Title.
   *
   * @return human readable task title.
   */
  public String getTitle() {
    return "NetMatch";
  }

  /**
   * Run Algorithm for Cytoscape
   */
  public void run() {
    if(taskMonitor == null) {
      throw new IllegalStateException("Task Monitor is not set.");
    }
    try {
      taskMonitor.setPercentCompleted(0);
      taskMonitor.setStatus("Create Network Loader (Step 1 of 5)");
      GraphLoader dbLoader;
      if(tna.equals(Strings.DEFAULT_ATTRIBUTES))
        dbLoader = loadGraphFromNetwork(target, tea);
      else
        dbLoader = loadGraphFromNetwork(target, tea, tna);
      if(checkTask())
        return;
      taskMonitor.setPercentCompleted(0);
      taskMonitor.setStatus("Create Network Graph Data (Step 2 of 5)");
      Graph db = new Graph(dbLoader,this);
      if(checkTask())
        return;
      taskMonitor.setPercentCompleted(0);
      taskMonitor.setStatus("Create Query Loader (Step 3 of 5)");
      GraphLoader qLoader;
      if(isUsedEditor)
        qLoader = this.qeLoader;
      else {
        if(qna.equals(Strings.DEFAULT_ATTRIBUTES))
          qLoader = loadGraphFromNetwork(query, qea);
        else
          qLoader = loadGraphFromNetwork(query, qea, qna);
      }
      if(checkTask())
        return;
      taskMonitor.setPercentCompleted(0);
      taskMonitor.setStatus("Create Query Graph Data (Step 4 of 5)");
      Graph q = new Graph(qLoader, this);
      if(Common.LABELED) {
        q.SetNodeComparator(new exactNodeComparator());
        q.SetEdgeComparator(new exactEdgeComparator());
      }
      else {
        q.SetNodeComparator(new approxNodeComparator());
        q.SetEdgeComparator(new approxEdgeComparator());
      }
      if(checkTask())
        return;
      taskMonitor.setPercentCompleted(-1);
      taskMonitor.setStatus("Start Matching... (Step 5 of 5)");
      VF2MonoState s0 = new VF2MonoState(q, db); // First parameter is query
      if(checkTask())
        return;
      array = new ArrayList();
      source = new ArrayList();
      myMatch m = new myMatch(this, frame);
      myInteger val = m.match(s0, array, source);
      if(checkTask())
        return;
      if(val.intValue() > 0) {
        if(val.intValue() > 500) {
          int r = JOptionPane.showConfirmDialog(frame, "The number of matches is " + val.intValue() + ". Do you really want to draw all matches?", "NetMatch", JOptionPane.YES_NO_OPTION);
          if(r == JOptionPane.YES_OPTION) {
            taskMonitor.setPercentCompleted(0);
            taskMonitor.setStatus("Draw results...");
            GraphPerspective gpComplexArray[] = convertComplexListToNetworkList(array, target);
            imageList = new Image[array.size()];
            for(int i = 0;i < array.size();i++) {
              if(checkTask())
                return;
              taskMonitor.setPercentCompleted((i * 100) / gpComplexArray.length);
              imageList[i] = convertNetworkToImage(gpComplexArray[i], Common.imageSize, Common.imageSize);
            }
          }
          else {
            imageList = null;
          }
        }
        else {
          taskMonitor.setPercentCompleted(0);
          taskMonitor.setStatus("Draw results...");
          GraphPerspective gpComplexArray[] = convertComplexListToNetworkList(array, target);
          imageList = new Image[array.size()];
          for(int i = 0;i < array.size();i++) {
            if(checkTask())
              return;
            taskMonitor.setPercentCompleted((i * 100) / gpComplexArray.length);
            imageList[i] = convertNetworkToImage(gpComplexArray[i], Common.imageSize, Common.imageSize);
          }
        }
      }
      if(checkTask())
        return;
      completedSuccessfully = true;
    }
    catch(Exception e) {
      completedSuccessfully = false;
      target.putClientData("NetMatch_running", new Boolean(false));
      taskMonitor.setException(e, "Please check data!");
    }
    catch(Error e) {
      completedSuccessfully = false;
      target.putClientData("NetMatch_running", new Boolean(false));
      taskMonitor.setException(e, "NetMatch cancelled!");
    }
  }

  public Image[] getImageList() {
    return imageList;
  }

  public ArrayList getArrayDest() {
    return array;
  }

  public ArrayList getArraySource() {
    return source;
  }

  private GraphPerspective convertComplexToNetwork(int[] complex, CyNetwork sourceNetwork) {
    GraphPerspective gpComplex;
    gpComplex = sourceNetwork.createGraphPerspective(complex);
    return gpComplex;
  }

  private GraphPerspective[] convertComplexListToNetworkList(ArrayList complexList, CyNetwork sourceNetwork) {
    int val = complexList.size();
    GraphPerspective gpComplexArray[] = new GraphPerspective[val];
    for(int i = 0;i < val;i++) {
      gpComplexArray[i] = convertComplexToNetwork((int[])complexList.get(i), sourceNetwork);
    }
    return gpComplexArray;
  }

  private Image convertNetworkToImage(GraphPerspective gpInput, int height, int width) {
    PGraphView view;
    //SpringEmbeddedLayouter lay;
    Image image;

    view = new PGraphView(gpInput);
    for(Iterator in = view.getNodeViewsIterator();in.hasNext();) {
      NodeView nv = (NodeView)in.next();
      String label = nv.getNode().getIdentifier();
      nv.getLabel().setText(label);
      nv.setWidth(40);
      nv.setHeight(40);
      nv.setShape(NodeView.ELLIPSE);
      nv.setUnselectedPaint(Color.red);
      nv.setBorderPaint(Color.black);
      nv.setXPosition(view.getCanvas().getLayer().getGlobalFullBounds().getWidth() * Math.random());
      nv.setYPosition((view.getCanvas().getLayer().getGlobalFullBounds().getHeight() + 100) * Math.random());
    }
    for(Iterator ie = view.getEdgeViewsIterator();ie.hasNext();) {
      EdgeView ev = (EdgeView)ie.next();
      ev.setUnselectedPaint(Color.blue);
      ev.setTargetEdgeEnd(EdgeView.BLACK_ARROW);
      ev.setTargetEdgeEndPaint(Color.CYAN);
      ev.setSourceEdgeEndPaint(Color.CYAN);
      ev.setStroke(new BasicStroke(5f));
    }
    //lay = new SpringEmbeddedLayouter(view);
    //lay.doLayout();
    image = view.getCanvas().getLayer().toImage(width, height, null);
    //double largestSide = view.getCanvas().getLayer().getFullBounds().width;
    //if(view.getCanvas().getLayer().getFullBounds().height > largestSide)
    //  largestSide = view.getCanvas().getLayer().getFullBounds().height;
    return image;
  }

  /**
   * Non-blocking call to interrupt the task.
   */
  public void halt() {
    this.interrupted = true;
  }

  /**
   * Sets the Task Monitor.
   *
   * @param taskMonitor TaskMonitor Object.
   */
  public void setTaskMonitor(TaskMonitor taskMonitor) throws IllegalThreadStateException {
    if(this.taskMonitor != null)
      throw new IllegalStateException("Task Monitor is already set.");
    this.taskMonitor = taskMonitor;
  }

  public void setPercentageComplete(int val) {
    taskMonitor.setPercentCompleted(val);
  }

  public boolean checkTask() {
    if(interrupted)
      target.putClientData("NetMatch_running", new Boolean(false));
    return interrupted;
  }

  /*public GraphLoader loadGraphFromFile(String name) {
    GraphLoader loader = null;
    StringTokenizer st;
    BufferedReader in;
    String line;
    int i;
    Hashtable names = new Hashtable();

    try {
      loader = new GraphLoader(null);
      in = new BufferedReader(new InputStreamReader(new FileInputStream(name)));
      i = 0;
      while((line = in.readLine()) != null && !line.equals("")) {
        st = new StringTokenizer(line, " \t");
        String name1 = st.nextToken();
        if(!names.containsKey(name1)) {
          names.put(name1, new Integer(i++));
          loader.InsertNode(name1);
        }
        String type = st.nextToken();
        while(st.hasMoreTokens()) {
          boolean any = false;
          String name2 = st.nextToken();
          if(name1.equals(name2)) {
            name2 += Common.SELF_EDGE;
            any = true;
          }
          if(!names.containsKey(name2)) {
            names.put(name2, new Integer(i++));
            loader.InsertNode(name2);
          }
          if(any) {
            loader.InsertEdge(((Integer)names.get(name1)).intValue(), ((Integer)names.get(name2)).intValue(), type + Common.SELF_EDGE);
            if(!Common.DIRECTED)
              loader.InsertEdge(((Integer)names.get(name2)).intValue(), ((Integer)names.get(name1)).intValue(), type + Common.SELF_EDGE);
          }
          else {
            loader.InsertEdge(((Integer)names.get(name1)).intValue(), ((Integer)names.get(name2)).intValue(), type);
            if(!Common.DIRECTED)
              loader.InsertEdge(((Integer)names.get(name2)).intValue(), ((Integer)names.get(name1)).intValue(), type);
          }
        }
      }
      in.close();
    }
    catch(IOException e) {
      if(frame != null)
        JOptionPane.showMessageDialog(frame, "NetMatch Error. Unable to read " + name + "!", "NetMatch Error", JOptionPane.ERROR_MESSAGE);
      else {
        System.err.println("NetMatch Error. Unable to read " + name + "!");
        System.exit(1);
      }
    }
    catch(Exception e) {
      if(frame != null)
        JOptionPane.showMessageDialog(frame, "NetMatch Error. File Format Exception!", "NetMatch Error", JOptionPane.ERROR_MESSAGE);
      else {
        System.err.println("NetMatch Error. File Format Exception!");
        System.exit(1);
      }
    }
    return loader;
  }*/

  /**
   * Run Algorithm from Command Line
   */

  /*public void startFileApplication() {
    BufferedWriter out;
    try {
      System.out.print("Start reading Query: " + queryName + "... ");
      GraphLoader queryLoader = loadGraphFromFile(queryName);
      Graph queryGraph = new Graph(queryLoader, null);
      if(Common.LABELED) {
        queryGraph.SetNodeComparator(new exactNodeComparator());
        queryGraph.SetEdgeComparator(new exactEdgeComparator());
      }
      else {
        queryGraph.SetNodeComparator(new approxNodeComparator());
        queryGraph.SetEdgeComparator(new approxEdgeComparator());
      }
      System.out.print("done!\nStart reading Graph: " + DBName + "... ");
      GraphLoader dbGraphLoader = loadGraphFromFile(DBName);
      Graph dbGraph = new Graph(dbGraphLoader, null);
      System.out.print("done!\nStart Matching... ");
      VF2MonoState s0 = new VF2MonoState(queryGraph, dbGraph);
      out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(queryName + ".out")));
      out.write("query:\r\n");
      int n = queryGraph.NodeCount();
      for(int i = 0;i < n;i++)
        out.write(queryGraph.GetNodeAttr(i) + "=" + i + " ");
      out.write("\r\ngraph:\r\n");
      n = dbGraph.NodeCount();
      for(int i = 0;i < n;i++)
        out.write(dbGraph.GetNodeAttr(i) + "=" + i + " ");
      out.write("\r\nmatch:\r\n");
      myMatch m = new myMatch(null, null);
      myInteger val = m.match(s0, out);
      System.out.print("Found " + val + " match!");
      out.close();
    }
    catch(IOException e) {
      System.err.println("IO Exception in netMatch. Unable to write " + queryName + ".out: ");
      System.exit(1);
    }
    catch(Exception e) {
      System.err.println("Exception in netMatch. " + e.toString());
      System.exit(1);
    }
  }*/

  /*public static void main(String[] args) {
    String db = null;
    String query = null;
    Common.DIRECTED = true;
    Common.LABELED = true;

    for(int n = 0;n < args.length;n++) {
      if(args[n].equals("-db"))
        db = args[++n];
      else if(args[n].equals("-q"))
        query = args[++n];
      else if(args[n].equals("-ud"))
        Common.DIRECTED = false;
      else if(args[n].equals("-ul"))
        Common.LABELED = false;
      else {
        System.out.println("Usage:java netMatch -q queryname -db dbname [-d/-ud] [-l/-ul]");
        System.exit(1);
      }
    }
    if(db != null && query != null) {
      Date d = new Date();
      long init = d.getTime();
      netMatch m = new netMatch(db, query);
      m.startFileApplication();
      d = new Date();
      long end = d.getTime();
      System.out.println("Elapsed Time (ms): " + (end - init));
    }
    else {
      System.out.println("Usage:java netMatch -q queryname -db dbname [-d/-ud] [-l/-ul]");
      System.exit(1);
    }
  }*/
}