package netmatch.qtool;

import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PNodeFilter;
import edu.umd.cs.piccolox.event.PSelectionEventHandler;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Iterator;

public class QSelectHandler extends PSelectionEventHandler implements ActionListener {

  private JPopupMenu popup;
  //private Collection popupSel;
  private QElement popupElement;
  private PLayer nodeLayer;
  private PLayer edgeLayer;
  private JTextArea info;
  private QToolFrame frame;

  public QSelectHandler(PNode pNode, PNode pNodel, JTextArea info, QToolFrame frame) {
    super(pNode, pNodel);
    this.info = info;
    this.frame = frame;

    popup = new JPopupMenu();
    JMenuItem mItem = new JMenuItem("Edit Attribute...");
    mItem.addActionListener(this);
    popup.add(mItem);
    mItem = new JMenuItem("Delete");
    mItem.addActionListener(this);
    popup.add(mItem);
  }

  public void decorateSelectedNode(PNode node) {
    node.setPaint(QNode.SELECTED_NODE_COLOR);
    super.decorateSelectedNode(node);
  }

  public void undecorateSelectedNode(PNode node) {
    node.setPaint(QNode.NODE_COLOR);
    super.undecorateSelectedNode(node);
  }

  public void mousePressed(PInputEvent event) {
    //System.out.println("press.. " + event.getPickedNode());
    super.mousePressed(event);
    checkPopup(event);
  }


  public void mouseMoved(PInputEvent event) {
    super.mouseMoved(event);
    QElement elem;
    if(event.getPickedNode() instanceof QText)
      elem = ((QText)event.getPickedNode()).getOwner();
    else if(event.getPickedNode() instanceof QElement)
      elem = (QElement)event.getPickedNode();
    else {
      info.setText("");
      return;
    }
    info.setText(elem.getInfo());

  }

  public void mouseClicked(PInputEvent event) {
    super.mouseClicked(event);
    checkPopup(event);
  }

  public void mouseReleased(PInputEvent event) {
    super.mouseReleased(event);
    checkPopup(event);
  }

  private void checkPopup(PInputEvent event) {
    if(event.isPopupTrigger()) {
      Point2D pos = event.getPosition();
      int x = (int)pos.getX();
      int y = (int)pos.getY();

      if(event.getPickedNode() instanceof QText)
        popupElement = ((QText)event.getPickedNode()).getOwner();
      else if(!(event.getPickedNode() instanceof QElement))
        return;
      else
        popupElement = (QElement)event.getPickedNode();
      nodeLayer = ((PCanvas)event.getComponent()).getCamera().getLayer(1);
      edgeLayer = ((PCanvas)event.getComponent()).getCamera().getLayer(0);
      Component c = (Component)event.getComponent();
      popup.show(c, x, y);
    }
  }

  public void keyPressed(PInputEvent event) {
    //System.out.println("Code: " + event.getKeyCode());
  }

  protected void drag(PInputEvent e) {
    /* if(e.getPickedNode() instanceof PText) {
        e.getPickedNode().replaceWith((PNode)e.getPickedNode().getAttribute("node"));
    }*/
    //System.out.println("draging.. " + e.getPickedNode());
    super.drag(e);
    Collection selectedNodes = getSelectionReference();
    Iterator it = selectedNodes.iterator();
    while(it.hasNext()) {
      PNode node = (PNode)it.next();
      if(node instanceof QNode)
        ((QNode)node).update();
    }
  }

  protected void startDrag(PInputEvent e) {
    super.startDrag(e);
  }

  public void select(PNode node) {
    //System.out.println("selecting.. " + node);
    if(node instanceof QText)
      super.select(((QText)node).getOwner());
    else
      super.select(node);
  }


  protected PNodeFilter createNodeFilter(PBounds bounds) {
    return new MyBoundsFilter(bounds);
  }

  protected class MyBoundsFilter extends PSelectionEventHandler.BoundsFilter {

    protected MyBoundsFilter(PBounds bounds) {
      super(bounds);
    }

    public boolean accept(PNode node) {
      if(node instanceof QText)
        return false;
      return super.accept(node);
    }

    public boolean acceptChildrenOf(PNode node) {
      if(node instanceof QText)
        return false;
      return super.acceptChildrenOf(node);
    }

    public boolean isCameraLayer(PNode node) {
      return super.isCameraLayer(node);
    }
  }

  // Popup menu commands
  public void actionPerformed(ActionEvent e) {
    String command = e.getActionCommand();

    if(command.equals("Edit Attribute...")) {
      String oldLabel = popupElement.getAttr();
      String newLabel = JOptionPane.showInputDialog("Change attribute:", oldLabel);
      if(newLabel != null) {
        popupElement.setAttr(newLabel);
        frame.isModif = true;
        frame.setTitleModif();
      }
    }
    else if(command.equals("Delete")) {
      popupElement.delete(nodeLayer, edgeLayer);
      frame.isModif = true;
      frame.setTitleModif();
      if(popupElement instanceof QNode)
        Network.nCount--;
      else if(popupElement instanceof QLoop)
        Network.lCount--;
      else if(popupElement instanceof QEdge)
        Network.eCount--;
      else if(popupElement instanceof QPath)
        Network.pCount--;
      frame.updateStatus();
    }
  }


}

