package netmatch.qtool;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;

/**
 * Created by IntelliJ IDEA.
 * User: Dimitry
 * Date: 25-ott-2005
 * Time: 12.10.08
 * To change this template use File | Settings | File Templates.
 */
public class QCreateLoopHandler extends PBasicInputEventHandler {

  private QToolFrame frame;

  public QCreateLoopHandler(QToolFrame frame) {
    this.frame = frame;
  }

  public void mouseClicked(PInputEvent e) {

    if(!e.isLeftMouseButton())
      return;

    PCamera pCamera = ((PCanvas)(e.getComponent())).getCamera();
    PLayer edgeLayer = pCamera.getLayer(0);

    if(!(e.getPickedNode() instanceof QNode || e.getPickedNode() instanceof QText))
      return;

    QNode node;
    if(e.getPickedNode() instanceof QText)
      node = ((QText)e.getPickedNode()).getOwner();
    else
      node = (QNode)e.getPickedNode();
    QLoop loop = new QLoop(node, "l" + Network.loopCount++);
    frame.isModif = true;
    frame.setTitleModif();
    node.addLoop(loop);
    edgeLayer.addChild(loop);
    loop.update();
    Network.lCount++;
    frame.updateStatus();
  }
}
